<?php
declare(strict_types=1);

namespace App\Controller;

/**
 * Campaigns Controller
 *
 * @property \App\Model\Table\CampaignsTable $Campaigns
 */
class CampaignsController extends AppController
{
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $this->viewBuilder()->setLayout('adminlayout');

        $query = $this->Campaigns->find();
        $campaigns = $this->paginate($query);

        $this->set(compact('campaigns'));
    }

    /**
     * View method
     *
     * @param string|null $id Campaign id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $this->viewBuilder()->setLayout('adminlayout');

        $campaign = $this->Campaigns->get($id, contain: ['Donations']);
        $this->set(compact('campaign'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $this->viewBuilder()->setLayout('adminlayout');

        $campaign = $this->Campaigns->newEmptyEntity();
        if ($this->request->is('post')) {
            $imageFile = $this->request->getData('image_file');
            if ($imageFile && $imageFile->getError() === UPLOAD_ERR_OK) {
                $filename = time() . '_' . $imageFile->getClientFilename();
                $targetPath = WWW_ROOT . 'img' . DS . 'campaigns' . DS . $filename;
                if (!file_exists(dirname($targetPath))) {
                    mkdir(dirname($targetPath), 0775, true);
                }
                $imageFile->moveTo($targetPath);
                $campaign->image_url = '/img/campaigns/' . $filename;
            }
            $campaign = $this->Campaigns->patchEntity($campaign, $this->request->getData());
            if ($this->Campaigns->save($campaign)) {
                \Cake\Log\Log::debug('New campaign saved with ID: ' . $campaign->id);
                $this->request->getSession()->write('Campaign.id', $campaign->id);
                $this->Flash->success(__('The campaign has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The campaign could not be saved. Please, try again.'));
        }
        $this->set(compact('campaign'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Campaign id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $this->viewBuilder()->setLayout('adminlayout');

        $campaign = $this->Campaigns->get($id, contain: []);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $imageFile = $this->request->getData('image_file');
            if ($imageFile && $imageFile->getError() === UPLOAD_ERR_OK) {
                $filename = time() . '_' . $imageFile->getClientFilename();
                $targetPath = WWW_ROOT . 'img' . DS . 'campaigns' . DS . $filename;
                if (!file_exists(dirname($targetPath))) {
                    mkdir(dirname($targetPath), 0775, true);
                }
                $imageFile->moveTo($targetPath);
                $campaign->image_url = '/img/campaigns/' . $filename;
            }
            $campaign = $this->Campaigns->patchEntity($campaign, $this->request->getData());
            if ($this->Campaigns->save($campaign)) {
                $this->Flash->success(__('The campaign has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The campaign could not be saved. Please, try again.'));
        }
        $this->set(compact('campaign'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Campaign id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->viewBuilder()->setLayout('adminlayout');

        $this->request->allowMethod(['post', 'delete']);
        $campaign = $this->Campaigns->get($id);
        if ($this->Campaigns->delete($campaign)) {
            $this->Flash->success(__('The campaign has been deleted.'));
        } else {
            $this->Flash->error(__('The campaign could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
    public function toggleVisibility($id = null)
{
    $this->request->allowMethod(['post', 'put']);
    $campaign = $this->Campaigns->get($id);
    $campaign->is_active = !$campaign->is_active;

    if ($this->Campaigns->save($campaign)) {
        $message = $campaign->is_active ? 'Campaign reopened.' : 'Campaign closed.';
        $this->Flash->success(__($message));
    } else {
        $this->Flash->error(__('Unable to update campaign visibility.'));
    }

    return $this->redirect(['action' => 'index']);
}
}
