<?php
// src/Controller/CertificatesController.php
namespace App\Controller;

use App\Controller\AppController;
use App\Model\Table\BadgesTable;
use App\Model\Table\DocTable;
use App\Model\Table\DocumentsTable;
use App\Model\Table\EnquiriesTable;
use App\Model\Table\ProgramsStudentsTable;
use App\Model\Table\ProgramsTable;
use App\Model\Table\ProgramsVolunteersTable;
use App\Model\Table\StudentsTable;
use App\Model\Table\VolunteersTable;
use Cake\Event\EventInterface;
use Cake\Http\Exception\BadRequestException;
use Cake\I18n\FrozenDate;
use Cake\I18n\FrozenTime;
use Cake\ORM\TableRegistry;
use Cake\Utility\Security;

class CertificateController extends AppController
{

    private VolunteersTable $VolunteersTable;
    private ProgramsTable $ProgramsTable;
    private ProgramsVolunteersTable $ProgramsVolunteersTable;
    private DocumentsTable $DocumentTable;

    private DocTable $DocTable;


    private BadgesTable $BadgesTable;


    public function initialize(): void
    {
        parent::initialize();
        $this->loadComponent('RequestHandler');
        $this->loadComponent('Flash');
        $this->VolunteersTable = $this->fetchTable('Volunteers');
        $this->ProgramsTable = $this->fetchTable('Programs');
        $this->ProgramsVolunteersTable = $this->fetchTable('ProgramsVolunteers');
        $this->DocumentTable = $this->fetchTable('Documents');
        $this->BadgesTable = $this->fetchTable('Badges');
        $this->Authentication->allowUnauthenticated(['showcertificate']);
        $this->DocTable = $this->fetchTable('Doc');

    }

    public function index()
    {
        $this->viewBuilder()->setLayout('adminlayout');

        $query = $this->DocTable->find();
        $search = $this->request->getQuery('search');
        if (!empty($search)) {
            $query->where([
                'OR' => [
                    'docuniqueid LIKE' => '%' . $search . '%',
                    'volunteer LIKE' => '%' . $search . '%',
                ]
            ]);
        }
        $doc = $this->paginate($query);
        $this->set(compact('doc'));


    }

    public function editor($id = null)
    {
        $this->viewBuilder()->setLayout('adminlayout');
        $volunteer = $this->VolunteersTable->get($id);
        $programmedVolunteers = $this->ProgramsVolunteersTable->find()
            ->where(['volunteer_id' => $volunteer->id])
            ->all();

        $programIds = $programmedVolunteers->extract('program_id')->toArray();

        if (!empty($programIds)) {
            $programs = $this->ProgramsTable->find()
                ->where(['id IN' => $programIds])
                ->all();
        } else {
            $programs = []; // Return an empty array if no programs are found
        }

        $badges = $this->BadgesTable->find();
//        \Cake\Error\debug($badges);
        // Define badge options
//        $badges = ['Best Volunteer Ever', 'Outstanding Contributor', 'Excellence Award'];

        if ($this->request->is('post')) {
            $data = $this->request->getData();

            // Prepare certificate data
            $certData = [
                'recipient_name' => $data['recipient_name'],
                'badge' => $data['badge1'],
                'organization_name' => "STEM incubators",
                'custom_text' => $data['custom_text'] ?? 'for helpful contributions in',
                'date_of_creation' => FrozenTime::now(),
                'cert_id' => $this->generateRandomString(20),
                'volunteer_id' => $volunteer->id,
            ];


            $selectedPrograms = $this->request->getData('programs'); // array of IDs
            $programNames = ['N/A', 'N/A', 'N/A']; // default size 3

            $programs = $this->ProgramsTable->find('all', [
                'conditions' => ['Programs.id IN' => $selectedPrograms]
            ])->all();

            // Iterate over the programs and set them in the programNames array
            $i = 0;
            foreach ($programs as $program) {
                if ($i < 3) {  // Only allow up to 3 programs
                    $programNames[$i] = $program->name; // Replace with the actual program name
                    $i++;
                }
            }


//            $badgeSelected=$this->BadgesTable->get($certData['badge']);
            $volunteer1 = $this->VolunteersTable->get($certData['volunteer_id']);
//            \Cake\Error\debug($badgeSelected->text_badge);
            // Create certificate document in the database
            $documentData = $this->DocTable->newEmptyEntity();
            $documentData['docuniqueid'] = $certData['cert_id'];
//            $documentData['volunteer'] = $volunteer1->first_name;
            $documentData['volunteer'] = $certData["recipient_name"];
            $documentData['badges'] = $certData["badge"];
            $documentData['certified'] = $certData['custom_text'];
            $documentData['issue_date'] = $certData["date_of_creation"];

            $documentData['program_name1'] = $programNames[0];
            $documentData['program_name2'] = $programNames[1];
            $documentData['program_name3'] = $programNames[2];
            $documentData['name'] = $certData["badge"] . ' - ' . $programNames[0];
//            \Cake\Error\debug($documentData);
            if ($this->DocTable->save($documentData)) {
                $includeBanner = 1;

                if (isset($data['action']) && $data['action'] === 'preview') {
                    // Pass certificate ID and include_banner as separate parameters
                    return $this->redirect([
                        'action' => 'preview',
                        $documentData->id,
                        1,
                    ]);
                } else {
                    return $this->redirect([
                        'action' => 'generate',
                        $documentData->id,
                        !empty($data['include_banner'])
                    ]);
                }
            } else {
                debug($documentData->toArray());
                debug($documentData->getErrors());
                $this->Flash->error(__('There was a problem with Certificate Generation, please try again.'));
            }
        }

        $this->set(compact('programs', 'badges', 'volunteer'));
    }


    public function preview($certificate_id = null, $include_banner = 1)
    {
        $this->viewBuilder()->setLayout('adminlayout');

        if (!$certificate_id) {
            $this->Flash->error(__('No certificate ID provided.'));
            return $this->redirect(['action' => 'index']);
        }

        // Get certificate data from database
        $documentData = $this->DocTable->get($certificate_id);

        if (!$documentData) {
            $this->Flash->error(__('Certificate not found.'));
            return $this->redirect(['action' => 'index']);
        }

        // Convert document data to certificate format
        $certificate = [
            'recipient_name' => $documentData->name,
            'badge' => $documentData->badges,
            'organization_name' => "STEM incubators",
            'custom_text' => $documentData->certified,
            'date_of_creation' => $documentData->issue_date,
            'cert_id' => $documentData->docuniqueid,
            'volunteer' => $documentData->volunteer,
            'program1' => $documentData->program_name1,
            'program2' => $documentData->program_name2,
            'program3' => $documentData->program_name3,
            'include_banner' => (bool)$include_banner // Use the passed parameter
        ];

        // If you need the program name
        if ($documentData->program_id) {
            $program = $this->ProgramsTable->get($documentData->program_id);
            $certificate['selected_programs'] = $program->name;
        }

        $this->set('certificate', $certificate);
        $this->set('isPreview', true);
        $this->render('certificate_template');
    }
    public function preview1($certificate_id = null, $include_banner = 1)
    {
        $this->viewBuilder()->setLayout('adminlayout');

        if (!$certificate_id) {
            $this->Flash->error(__('No certificate ID provided.'));
            return $this->redirect(['action' => 'index']);
        }

        // Get certificate data from database
        $documentData = $this->DocTable->get($certificate_id);

        if (!$documentData) {
            $this->Flash->error(__('Certificate not found.'));
            return $this->redirect(['action' => 'index']);
        }

        // Convert document data to certificate format
        $certificate = [
            'recipient_name' => $documentData->name,
            'badge' => $documentData->badges,
            'organization_name' => "STEM incubators",
            'custom_text' => $documentData->certified,
            'date_of_creation' => $documentData->issue_date,
            'cert_id' => $documentData->docuniqueid,
            'volunteer' => $documentData->volunteer,
            'program1' => $documentData->program_name1,
            'program2' => $documentData->program_name2,
            'program3' => $documentData->program_name3,
            'include_banner' => (bool)$include_banner // Use the passed parameter
        ];

        // If you need the program name
        if ($documentData->program_id) {
            $program = $this->ProgramsTable->get($documentData->program_id);
            $certificate['selected_programs'] = $program->name;
        }

        $this->set('certificate', $certificate);
        $this->set('isPreview', true);
        $this->render('certificate_template2');
    }

    public function showcertificate($id = null)
    {
        $data = $this->DocTable->find()->where(['docuniqueid' => $id])->first();
//        $program = $this->ProgramsTable->find()->where(['id' => $data->program_id])->first();
        if ($data) {
            $certData = [
                'volunteer' => $data['volunteer'],
                'badge' => $data['badges'],
                'organization_name' => "STEM incubators",
                'custom_text' => $data['custom_text'] ?? 'for helpful contributions in',
                'date_of_creation' => $data['issue_date'],
                'include_banner' => true,
                'cert_id' => $data['docuniqueid'],
                "program1" => $data['program_name1'],
                "program2" => $data['program_name2'],
                "program3" => $data['program_name3']
            ];

            if (empty($certData)) {
                $this->Flash->error(__('No certificate data found. Please fill out the form first.'));
                return $this->redirect(['controller' => 'Pages', 'action' => '/']);
            }

            $this->set('certificate', $certData);
            $this->set('isPreview', true);
            $this->render('certificate_template1');
        }
    }


    private function generateRandomString($length = 20)
    {
        $characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, strlen($characters) - 1)];
        }
        return $randomString;
    }


}
