<?php
declare(strict_types=1);

namespace App\Controller;

/**
 * ProgramsSections Controller
 *
 * @property \App\Model\Table\ProgramsSectionsTable $ProgramsSections
 */
class ProgramsSectionsController extends AppController
{
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $query = $this->ProgramsSections->find()
            ->contain(['Programs']);
        $programsSections = $this->paginate($query);

        $this->set(compact('programsSections'));
    }

    /**
     * View method
     *
     * @param string|null $id Programs Section id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $programsSection = $this->ProgramsSections->get($id, contain: ['Programs']);
        $this->set(compact('programsSection'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $programsSection = $this->ProgramsSections->newEmptyEntity();
        if ($this->request->is('post')) {
            $programsSection = $this->ProgramsSections->patchEntity($programsSection, $this->request->getData());
            if ($this->ProgramsSections->save($programsSection)) {
                $this->Flash->success(__('The programs section has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The programs section could not be saved. Please, try again.'));
        }
        $programs = $this->ProgramsSections->Programs->find('list', limit: 200)->all();
        $this->set(compact('programsSection', 'programs'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Programs Section id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $programsSection = $this->ProgramsSections->get($id, contain: []);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $programsSection = $this->ProgramsSections->patchEntity($programsSection, $this->request->getData());
            if ($this->ProgramsSections->save($programsSection)) {
                $this->Flash->success(__('The programs section has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The programs section could not be saved. Please, try again.'));
        }
        $programs = $this->ProgramsSections->Programs->find('list', limit: 200)->all();
        $this->set(compact('programsSection', 'programs'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Programs Section id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $programsSection = $this->ProgramsSections->get($id);
        if ($this->ProgramsSections->delete($programsSection)) {
            $this->Flash->success(__('The programs section has been deleted.'));
        } else {
            $this->Flash->error(__('The programs section could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
