<?php
declare(strict_types=1);

namespace App\Controller;

/**
 * ProgramsVolunteers Controller
 *
 * @property \App\Model\Table\ProgramsVolunteersTable $ProgramsVolunteers
 */
class ProgramsVolunteersController extends AppController
{
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function initialize(): void
    {
        parent::initialize(); // TODO: Change the autogenerated stub
        $this->viewBuilder()->setLayout('adminlayout');
    }

    public function index()
    {
        $query = $this->ProgramsVolunteers->find()
            ->contain(['Programs', 'Volunteers']);
        $programsVolunteers = $this->paginate($query);

        $this->set(compact('programsVolunteers'));
    }

    /**
     * View method
     *
     * @param string|null $id Programs Volunteer id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $programsVolunteer = $this->ProgramsVolunteers->get($id, contain: ['Programs', 'Volunteers']);
        $this->set(compact('programsVolunteer'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $programsVolunteer = $this->ProgramsVolunteers->newEmptyEntity();
        if ($this->request->is('post')) {
            $programsVolunteer = $this->ProgramsVolunteers->patchEntity($programsVolunteer, $this->request->getData());
            if ($this->ProgramsVolunteers->save($programsVolunteer)) {
                $this->Flash->success(__('The programs volunteer has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The programs volunteer could not be saved. Please, try again.'));
        }
        $programs = $this->ProgramsVolunteers->Programs->find('list', limit: 200)->all();
        $volunteers = $this->ProgramsVolunteers->Volunteers->find('list', limit: 200)->all();
        $this->set(compact('programsVolunteer', 'programs', 'volunteers'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Programs Volunteer id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $programsVolunteer = $this->ProgramsVolunteers->get($id, contain: []);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $programsVolunteer = $this->ProgramsVolunteers->patchEntity($programsVolunteer, $this->request->getData());
            if ($this->ProgramsVolunteers->save($programsVolunteer)) {
                $this->Flash->success(__('The programs volunteer has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The programs volunteer could not be saved. Please, try again.'));
        }
        $programs = $this->ProgramsVolunteers->Programs->find('list', limit: 200)->all();
        $volunteers = $this->ProgramsVolunteers->Volunteers->find('list', limit: 200)->all();
        $this->set(compact('programsVolunteer', 'programs', 'volunteers'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Programs Volunteer id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $programsVolunteer = $this->ProgramsVolunteers->get($id);
        if ($this->ProgramsVolunteers->delete($programsVolunteer)) {
            $this->Flash->success(__('The programs volunteer has been deleted.'));
        } else {
            $this->Flash->error(__('The programs volunteer could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
