<?php
declare(strict_types=1);

namespace App\Controller;

/**
 * StudentStatuses Controller
 *
 * @property \App\Model\Table\StudentStatusesTable $StudentStatuses
 */
class StudentStatusesController extends AppController
{
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $query = $this->StudentStatuses->find();
        $studentStatuses = $this->paginate($query);

        $this->set(compact('studentStatuses'));
    }

    /**
     * View method
     *
     * @param string|null $id Student Status id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $studentStatus = $this->StudentStatuses->get($id, contain: ['Students']);
        $this->set(compact('studentStatus'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $studentStatus = $this->StudentStatuses->newEmptyEntity();
        if ($this->request->is('post')) {
            $studentStatus = $this->StudentStatuses->patchEntity($studentStatus, $this->request->getData());
            if ($this->StudentStatuses->save($studentStatus)) {
                $this->Flash->success(__('The student status has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The student status could not be saved. Please, try again.'));
        }
        $this->set(compact('studentStatus'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Student Status id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $studentStatus = $this->StudentStatuses->get($id, contain: []);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $studentStatus = $this->StudentStatuses->patchEntity($studentStatus, $this->request->getData());
            if ($this->StudentStatuses->save($studentStatus)) {
                $this->Flash->success(__('The student status has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The student status could not be saved. Please, try again.'));
        }
        $this->set(compact('studentStatus'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Student Status id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $studentStatus = $this->StudentStatuses->get($id);
        if ($this->StudentStatuses->delete($studentStatus)) {
            $this->Flash->success(__('The student status has been deleted.'));
        } else {
            $this->Flash->error(__('The student status could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
