<?php
declare(strict_types=1);

namespace App\Controller;

/**
 * VolunteerStatuses Controller
 *
 * @property \App\Model\Table\VolunteerStatusesTable $VolunteerStatuses
 */
class VolunteerStatusesController extends AppController
{
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $this->viewBuilder()->setLayout('adminlayout');
        $query = $this->VolunteerStatuses->find();
        $volunteerStatuses = $this->paginate($query);

        $this->set(compact('volunteerStatuses'));
    }

    /**
     * View method
     *
     * @param string|null $id Volunteer Status id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $this->viewBuilder()->setLayout('adminlayout');
        $volunteerStatus = $this->VolunteerStatuses->get($id, contain: ['Volunteers']);
        $this->set(compact('volunteerStatus'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $volunteerStatus = $this->VolunteerStatuses->newEmptyEntity();
        $this->viewBuilder()->setLayout('adminlayout');
        if ($this->request->is('post')) {
            $volunteerStatus = $this->VolunteerStatuses->patchEntity($volunteerStatus, $this->request->getData());
            if ($this->VolunteerStatuses->save($volunteerStatus)) {
                $this->Flash->success(__('The volunteer status has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The volunteer status could not be saved. Please, try again.'));
        }
        $this->set(compact('volunteerStatus'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Volunteer Status id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $this->viewBuilder()->setLayout('adminlayout');
        $volunteerStatus = $this->VolunteerStatuses->get($id, contain: []);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $volunteerStatus = $this->VolunteerStatuses->patchEntity($volunteerStatus, $this->request->getData());
            if ($this->VolunteerStatuses->save($volunteerStatus)) {
                $this->Flash->success(__('The volunteer status has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The volunteer status could not be saved. Please, try again.'));
        }
        $this->set(compact('volunteerStatus'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Volunteer Status id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $volunteerStatus = $this->VolunteerStatuses->get($id);
        if ($this->VolunteerStatuses->delete($volunteerStatus)) {
            $this->Flash->success(__('The volunteer status has been deleted.'));
        } else {
            $this->Flash->error(__('The volunteer status could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
