<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * ProgramsVolunteer Entity
 *
 * @property int $id
 * @property int|null $program_id
 * @property int|null $volunteer_id
 *
 * @property \App\Model\Entity\Program $program
 * @property \App\Model\Entity\Volunteer $volunteer
 */
class ProgramsVolunteer extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'program_id' => true,
        'volunteer_id' => true,
        'program' => true,
        'volunteer' => true,
    ];
}
