<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Doc Model
 *
 * @method \App\Model\Entity\Doc newEmptyEntity()
 * @method \App\Model\Entity\Doc newEntity(array $data, array $options = [])
 * @method array<\App\Model\Entity\Doc> newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Doc get(mixed $primaryKey, array|string $finder = 'all', \Psr\SimpleCache\CacheInterface|string|null $cache = null, \Closure|string|null $cacheKey = null, mixed ...$args)
 * @method \App\Model\Entity\Doc findOrCreate($search, ?callable $callback = null, array $options = [])
 * @method \App\Model\Entity\Doc patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method array<\App\Model\Entity\Doc> patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\Doc|false save(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method \App\Model\Entity\Doc saveOrFail(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method iterable<\App\Model\Entity\Doc>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Doc>|false saveMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Doc>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Doc> saveManyOrFail(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Doc>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Doc>|false deleteMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Doc>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Doc> deleteManyOrFail(iterable $entities, array $options = [])
 */
class DocTable extends Table
{
    /**
     * Initialize method
     *
     * @param array<string, mixed> $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('doc');
        $this->setDisplayField('name');
        $this->setPrimaryKey('id');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->scalar('docuniqueid')
            ->maxLength('docuniqueid', 255)
            ->requirePresence('docuniqueid', 'create')
            ->notEmptyString('docuniqueid');

        $validator
            ->scalar('volunteer')
            ->maxLength('volunteer', 255)
            ->requirePresence('volunteer', 'create')
            ->notEmptyString('volunteer')
            ->add('volunteer', 'unique', ['rule' => 'validateUnique', 'provider' => 'table']);

        $validator
            ->scalar('name')
            ->maxLength('name', 255)
            ->requirePresence('name', 'create')
            ->notEmptyString('name');

        $validator
            ->scalar('badges')
            ->requirePresence('badges', 'create')
            ->notEmptyString('badges');

        $validator
            ->scalar('certified')
            ->maxLength('certified', 255)
            ->requirePresence('certified', 'create')
            ->notEmptyString('certified');

        $validator
            ->date('issue_date')
            ->requirePresence('issue_date', 'create')
            ->notEmptyDate('issue_date');

        $validator
            ->scalar('program_name1')
            ->maxLength('program_name1', 255)
            ->allowEmptyString('program_name1');

        $validator
            ->scalar('program_name2')
            ->maxLength('program_name2', 255)
            ->allowEmptyString('program_name2');

        $validator
            ->scalar('program_name3')
            ->maxLength('program_name3', 255)
            ->allowEmptyString('program_name3');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules): RulesChecker
    {
        // Removed unique constraint on 'volunteer'
        return $rules;
    }
}
