<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Donations Model
 *
 * @method \App\Model\Entity\Donation newEmptyEntity()
 * @method \App\Model\Entity\Donation newEntity(array $data, array $options = [])
 * @method array<\App\Model\Entity\Donation> newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Donation get(mixed $primaryKey, array|string $finder = 'all', \Psr\SimpleCache\CacheInterface|string|null $cache = null, \Closure|string|null $cacheKey = null, mixed ...$args)
 * @method \App\Model\Entity\Donation findOrCreate($search, ?callable $callback = null, array $options = [])
 * @method \App\Model\Entity\Donation patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method array<\App\Model\Entity\Donation> patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\Donation|false save(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method \App\Model\Entity\Donation saveOrFail(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method iterable<\App\Model\Entity\Donation>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Donation>|false saveMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Donation>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Donation> saveManyOrFail(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Donation>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Donation>|false deleteMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Donation>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Donation> deleteManyOrFail(iterable $entities, array $options = [])
 *
 * @mixin \Cake\ORM\Behavior\TimestampBehavior
 */
class DonationsTable extends Table
{
    /**
     * Initialize method
     *
     * @param array<string, mixed> $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('donations');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');

        $this->addBehavior('Timestamp');
        $this->belongsTo('Campaigns', [
            'foreignKey' => 'campaign_id',
            'joinType' => 'LEFT',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->decimal('amount')
            ->requirePresence('amount', 'create')
            ->notEmptyString('amount');

        $validator
            ->scalar('donor_email')
            ->maxLength('donor_email', 255)
            ->requirePresence('donor_email', 'create')
            ->notEmptyString('donor_email');

        $validator
            ->scalar('stripe_transaction_id')
            ->maxLength('stripe_transaction_id', 255)
            ->requirePresence('stripe_transaction_id', 'create')
            ->notEmptyString('stripe_transaction_id');

        $validator
            ->scalar('status')
            ->maxLength('status', 50)
            ->requirePresence('status', 'create')
            ->notEmptyString('status');

        return $validator;
    }
}
