<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\User $user
 */

$this->layout = 'login';
$this->assign('title', 'Register New User');
?>

<!-- templates/Users/signup.php -->
<div class="signup-wrapper">
    <div class="signup-container animate-container">
        <h1 class="signup-title">Sign Up</h1>
        <p class="signup-subtitle">Create your account</p>

        <?= $this->Form->create($user) ?>
        <?php echo $this->Flash->render(); ?>
        <div class="form-group animate-field">
            <?= $this->Form->control('email', [
                'label' => false,
                'placeholder' => 'Email',
                'type' => 'email',
                'required' => true,
                'class' => 'form-input'
            ]) ?>
        </div>

        <div class="form-group animate-field">
            <?= $this->Form->control('first_name', [
                'label' => false,
                'placeholder' => 'First Name',
                'type' => 'string',
                'required' => true,
                'class' => 'form-input'
            ]) ?>
        </div>
        <div class="form-group animate-field">
            <?= $this->Form->control('last_name', [
                'label' => false,
                'placeholder' => 'Last Name',
                'type' => 'string',
                'required' => true,
                'class' => 'form-input'
            ]) ?>
        </div>

        <div class="form-group animate-field">
            <?= $this->Form->control('password', [
                'label' => false,
                'placeholder' => 'Password',
                'type' => 'password',
                'required' => true,
                'class' => 'form-input'
            ]) ?>
        </div>
        <div class="form-group">
            <?= $this->Form->button('Sign Up', ['class' => 'submit-btn']) ?>
        </div>
        <p class="signup-footer">Have an account? <a href="/users/login">Log in</a></p>
        <?= $this->Form->end() ?>
    </div>
</div>

<style>
    /* webroot/css/signup.css */
    * {
        box-sizing: border-box;
        margin: 0;
        padding: 0;
        font-family: 'Arial', sans-serif;
    }

    /* Signup wrapper and container */
    .signup-wrapper {
        min-height: 100vh;
        display: flex;
        justify-content: center;
        align-items: center;
        background: linear-gradient(120deg, #f093fb, #f5576c);
        padding: 15px;
    }

    .signup-container {
        background: #fff;
        padding: 2rem;
        border-radius: 10px;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.15);
        width: 100%;
        max-width: 420px;
        transition: all 0.3s ease;
    }

    /* Container fade-in animation */
    .animate-container {
        animation: fadeIn 0.8s ease-out;
    }

    @keyframes fadeIn {
        0% { opacity: 0; transform: translateY(-20px); }
        100% { opacity: 1; transform: translateY(0); }
    }

    /* Title and subtitle */
    .signup-title {
        font-size: clamp(1.5rem, 5vw, 2rem);
        font-weight: 700;
        text-align: center;
        color: #2d3436;
        margin-bottom: 0.5rem;
    }

    .signup-subtitle {
        font-size: clamp(0.875rem, 3vw, 1rem);
        text-align: center;
        color: #636e72;
        margin-bottom: 1.5rem;
    }

    /* Form styling */
    .signup-form {
        display: flex;
        flex-direction: column;
        gap: 1rem;
    }

    .form-group {
        width: 100%;
    }

    .form-input {
        width: 100%;
        padding: 0.75rem;
        border: 1px solid #dfe6e9;
        border-radius: 6px;
        font-size: clamp(0.875rem, 2.5vw, 1rem);
        transition: border-color 0.3s ease, box-shadow 0.3s ease;
        height: 45px;
    }

    .form-input:focus {
        outline: none;
        border-color: #e84393;
        box-shadow: 0 0 5px rgba(232, 67, 147, 0.3);
    }

    /* Field slide-in animation */
    .animate-field {
        opacity: 0;
        animation: slideIn 0.5s ease-out forwards;
    }

    .animate-field:nth-child(1) { animation-delay: 0.2s; }
    .animate-field:nth-child(2) { animation-delay: 0.3s; }
    .animate-field:nth-child(3) { animation-delay: 0.4s; }
    .animate-field:nth-child(4) { animation-delay: 0.5s; }

    @keyframes slideIn {
        0% { opacity: 0; transform: translateX(-20px); }
        100% { opacity: 1; transform: translateX(0); }
    }

    /* Submit button */
    .submit-btn {
        width: 100%;
        padding: 0.2rem;
        background: #e84393;
        color: #fff;
        border: none;
        border-radius: 6px;
        font-size: clamp(0.875rem, 2.5vw, 1rem);
        font-weight: bold;
        cursor: pointer;
        transition: background 0.3s ease, transform 0.2s ease;
    }

    .submit-btn:hover {
        background: #d63031;
        transform: scale(1.05) translateY(-2px); /* Bounce effect */
        box-shadow: 0 4px 10px rgba(214, 48, 49, 0.3);
    }

    /* Footer */
    .signup-footer {
        text-align: center;
        font-size: clamp(0.75rem, 2vw, 0.875rem);
        color: #636e72;
        margin-top: 1rem;
    }

    .signup-footer a {
        color: #e84393;
        text-decoration: none;
        font-weight: 500;
    }

    .signup-footer a:hover {
        text-decoration: underline;
    }

    /* Responsive Design */
    @media (max-width: 768px) {
        .signup-container {
            max-width: 90%;
            padding: 1.5rem;
        }
    }

    @media (max-width: 480px) {
        .signup-container {
            max-width: 100%;
            padding: 1rem;
            margin: 0 10px;
        }

        .signup-form {
            gap: 0.75rem;
        }

        .form-input, .submit-btn {
            padding: 0.6rem;
            height: 40px;
        }
    }

    @media (min-width: 1200px) {
        .signup-container {
            max-width: 480px;
            padding: 2.5rem;
        }

        .signup-title {
            font-size: 2.25rem;
        }

        .signup-subtitle {
            font-size: 1.125rem;
        }
    }
</style>
