<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Badge> $badges
 */
?>

<div class="container-xxl flex-grow-2 container-p-y">
    <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Badges /</span> List</h4>

    <div class="row">
        <div class="col-xl">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Badge List</h5>
                    <?= $this->Html->link('Add Badge', ['action' => 'add'], ['class' => 'btn btn-primary']) ?>
                </div>
                <div class="card-body">
                    <div class="table-responsive text-nowrap">
                        <table class="table table-striped">
                            <thead>
                            <tr>
                                <th><?= $this->Paginator->sort('text_badge') ?></th>
<!--                                <th class="text-center">--><?php //= __('Actions') ?><!--</th>-->
                            </tr>
                            </thead>
                            <tbody class="table-border-bottom-0">
                            <?php foreach ($badges as $badge): ?>
                                <tr class="clickable-row" data-edit-url="<?= $this->Url->build(['action' => 'edit', $badge->id]) ?>">
<!--                                    <td>--><?php //= $this->Number->format($badge->id) ?><!--</td>-->
                                    <td><span class="badge bg-label-info"><?= h($badge->text_badge) ?></span></td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-4">
                        <nav aria-label="Page navigation">
                            <ul class="pagination justify-content-center">
                                <?= $this->Paginator->first('<i class="bx bx-chevrons-left"></i>', ['escape' => false, 'class' => 'page-item']) ?>
                                <?= $this->Paginator->prev('<i class="bx bx-chevron-left"></i>', ['escape' => false, 'class' => 'page-item']) ?>
                                <?php
                                $this->Paginator->setTemplates([
                                    'number' => '<li class="page-item"><a class="page-link" href="{{url}}">{{text}}</a></li>',
                                    'current' => '<li class="page-item active"><a class="page-link" href="#">{{text}}</a></li>',
                                ]);
                                echo $this->Paginator->numbers();
                                ?>
                                <?= $this->Paginator->next('<i class="bx bx-chevron-right"></i>', ['escape' => false, 'class' => 'page-item']) ?>
                                <?= $this->Paginator->last('<i class="bx bx-chevrons-right"></i>', ['escape' => false, 'class' => 'page-item']) ?>
                            </ul>
                        </nav>
                        <div class="text-center text-muted mt-2">
                            <?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<style>
    .clickable-row {
        cursor: pointer;
    }
</style>

<!-- Add JavaScript to make rows clickable -->
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const rows = document.querySelectorAll('.clickable-row');
        rows.forEach(function(row) {
            row.addEventListener('click', function() {
                const editUrl = row.getAttribute('data-edit-url');
                if (editUrl) {
                    window.location.href = editUrl; // Redirect to the edit page
                }
            });
        });
    });
</script>
