<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Campaign $campaign
 */
?>

<style>
    /* Style the slider track */
    input[type="range"] {
        -webkit-appearance: none;
        width: 100%;
        height: 8px;
        background: #ddd;
        border-radius: 5px;
        outline: none;
        margin: 10px 0;
    }

    /* Style the slider thumb */
    input[type="range"]::-webkit-slider-thumb {
        -webkit-appearance: none;
        appearance: none;
        width: 20px;
        height: 20px;
        background: #007bff;
        border-radius: 50%;
        cursor: pointer;
        border: 2px solid #fff;
        box-shadow: 0 0 2px rgba(0, 0, 0, 0.3);
    }

    input[type="range"]::-moz-range-thumb {
        width: 20px;
        height: 20px;
        background: #007bff;
        border-radius: 50%;
        cursor: pointer;
        border: 2px solid #fff;
        box-shadow: 0 0 2px rgba(0, 0, 0, 0.3);
    }

    /* Style the track when the slider is active */
    input[type="range"]::-webkit-slider-runnable-track {
        background: #ddd;
    }

    input[type="range"]::-moz-range-track {
        background: #ddd;
    }

    /* Style for when the slider is focused */
    input[type="range"]:focus {
        outline: none;
    }

    input[type="range"]:focus::-webkit-slider-thumb {
        box-shadow: 0 0 5px rgba(0, 123, 255, 0.5);
    }

    input[type="range"]:focus::-moz-range-thumb {
        box-shadow: 0 0 5px rgba(0, 123, 255, 0.5);
    }
</style>

<div class="container-xxl flex-grow-1 container-p-y">
    <?= $this->Form->create($campaign, ['class' => 'row g-3', 'type' => 'file']) ?>
    <div class="card shadow p-4">
        <div class="card-header bg-white mb-3 d-flex justify-content-between align-items-center">
            <h3 class="mb-0">Add New Campaign</h3>
            <div>
                <?= $this->Html->link(
                    '<i class="bx bx-arrow-back me-1"></i> Back to Campaigns',
                    ['action' => 'index'],
                    ['class' => 'btn btn-secondary btn-sm', 'escape' => false]
                ) ?>
            </div>
        </div>

        <div class="card-body">
            <?= $this->Flash->render() ?>

            <?php if ($campaign->getErrors()): ?>
                <div class="alert alert-danger">
                    <ul>
                        <?php foreach ($campaign->getErrors() as $field => $errors): ?>
                            <?php foreach ($errors as $error): ?>
                                <li><?= h($error) ?></li>
                            <?php endforeach; ?>
                        <?php endforeach; ?>
                    </ul>
                </div>
            <?php endif; ?>

            <div class="col-12">
                <div class="form-group mb-3">
                    <label class="form-label">Title <span class="text-danger">*</span></label>
                    <?= $this->Form->control('title', [
                        'class' => 'form-control',
                        'label' => false,
                        'placeholder' => 'Enter campaign title',
                        'required' => true,
                        'maxlength' => 255,
                        'id' => 'title'
                    ]) ?>
                    <div id="title-counter" style="margin-top: 5px; font-size: 0.9rem; color: #555;">Characters: 0/255</div>
                </div>
            </div>

            <div class="col-12">
                <div class="form-group mb-3">
                    <label class="form-label">Description <span class="text-danger">*</span></label>
                    <?= $this->Form->control('description', [
                        'class' => 'form-control',
                        'type' => 'textarea',
                        'rows' => 4,
                        'label' => false,
                        'placeholder' => 'Enter campaign description',
                        'required' => true,
                        'maxlength' => 1000,
                        'id' => 'description'
                    ]) ?>
                    <div id="description-counter" style="margin-top: 5px; font-size: 0.9rem; color: #555;">Characters: 0/1000</div>
                </div>
            </div>

            <div class="col-12">
                <div class="form-group mb-3">
                    <label class="form-label" for="goal_amount">Goal Amount</label>
                    <?= $this->Form->control('goal_amount', [
                        'class' => 'form-control',
                        'label' => false,
                        'placeholder' => 'Enter the target donation amount (max: 99,999,999.9)',
                        'type' => 'text',
                        'step' => '0.01',
                        'max' => '99999999.99',
                        'required' => true,
                    ]) ?>
                    <div id="goal-amount-feedback" style="margin-top: 5px; font-size: 0.9rem; color: #555;">Max: 99,999,999.99</div>
                </div>
            </div>

            <div class="col-12">
                <div class="form-group mb-3">
                    <label class="form-label">Upload Image</label>
                    <?= $this->Form->control('image_file', [
                        'type' => 'file',
                        'class' => 'form-control',
                        'label' => false,
                        'accept' => 'image/*',
                        'id' => 'image-file'
                    ]) ?>
                    <small style="margin-top: 5px; display: block; font-size: 0.9rem; color: #555;">Supported formats: JPG, PNG, GIF (Max 5MB)</small>
                    <div id="image-file-error" style="margin-top: 5px; font-size: 0.9rem; color: red; display: none;"></div>
                </div>
            </div>

            <div class="col-12 text-end d-flex justify-content-between">
                <?= $this->Html->link(__('Cancel'), ['action' => 'index'], ['class' => 'btn btn-secondary']) ?>
                <?= $this->Form->button(__('Submit'), ['class' => 'btn btn-primary']) ?>
            </div>
        </div>
    </div>
    <?= $this->Form->end() ?>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            // Get references to form fields and feedback elements
            const titleInput = document.getElementById('title');
            const descriptionInput = document.getElementById('description');
            const goalAmountInput = document.getElementById('goal-amount');
            const imageFileInput = document.getElementById('image-file');
            const titleCounter = document.getElementById('title-counter');
            const descriptionCounter = document.getElementById('description-counter');
            const goalAmountFeedback = document.getElementById('goal-amount-feedback');
            const imageFileError = document.getElementById('image-file-error');
            const maxAmount = 99999999.99;
            const maxFileSize = 5 * 1024 * 1024; // 5MB in bytes

            // Validation functions
            function validateText(input, maxLength) {
                // Allow letters, numbers, spaces, periods, commas, quotes, hyphens (same as certificate custom text)
                let sanitized = input.replace(/[^a-zA-Z0-9 .,\'"-]/g, '');
                if (sanitized.length > maxLength) {
                    sanitized = sanitized.substring(0, maxLength);
                }
                return sanitized;
            }

            function validateGoalAmount(input) {
                // Allow numbers with up to 2 decimal places
                let sanitized = input.toString().replace(/[^0-9.]/g, '');
                const parts = sanitized.split('.');
                if (parts.length > 2) {
                    sanitized = parts[0] + '.' + parts.slice(1).join('');
                }
                if (parts.length > 1) {
                    sanitized = parts[0] + '.' + parts[1].slice(0, 2);
                }
                const value = parseFloat(sanitized) || 0;
                return Math.min(value, maxAmount);
            }

            // Update counter and feedback functions
            function updateTitleCounter() {
                titleInput.value = validateText(titleInput.value, 255);
                const charCount = titleInput.value.length;
                titleCounter.textContent = `Characters: ${charCount}/255${charCount === 255 ? ' (Maximum reached)' : ''}`;
                titleCounter.style.color = charCount === 255 ? 'red' : '#555';
            }

            function updateDescriptionCounter() {
                descriptionInput.value = validateText(descriptionInput.value, 1000);
                const charCount = descriptionInput.value.length;
                descriptionCounter.textContent = `Characters: ${charCount}/1000${charCount === 1000 ? ' (Maximum reached)' : ''}`;
                descriptionCounter.style.color = charCount === 1000 ? 'red' : '#555';
            }


            function validateImageFile() {
                imageFileError.style.display = 'none';
                if (imageFileInput.files.length > 0) {
                    const file = imageFileInput.files[0];
                    const validImageTypes = ['image/jpeg', 'image/png', 'image/gif'];
                    if (!validImageTypes.includes(file.type)) {
                        imageFileError.textContent = 'Invalid file type. Only JPG, PNG, and GIF are allowed.';
                        imageFileError.style.display = 'block';
                        imageFileInput.setCustomValidity('Invalid file type');
                        return false;
                    }
                    if (file.size > maxFileSize) {
                        imageFileError.textContent = 'File size exceeds 5MB limit.';
                        imageFileError.style.display = 'block';
                        imageFileInput.setCustomValidity('File size exceeds limit');
                        return false;
                    }
                    imageFileInput.setCustomValidity('');
                    return true;
                }
                return true;
            }

            // Initialize counters on page load
            updateTitleCounter();
            updateDescriptionCounter();

            // Attach event listeners for real-time updates
            titleInput.addEventListener('input', updateTitleCounter);
            descriptionInput.addEventListener('input', updateDescriptionCounter);
            // Replace goalAmountInput validation with stricter version
            goalAmountInput.addEventListener('beforeinput', function (e) {
                const currentValue = this.value;
                const insertion = e.data || '';
                const newValue = currentValue.slice(0, this.selectionStart) + insertion + currentValue.slice(this.selectionEnd);

                if (/^\d{0,8}(\.\d{0,2})?$/.test(newValue)) {
                    return;
                }

                e.preventDefault();
            });

            goalAmountInput.addEventListener('input', function () {
                let value = this.value;
                if (/^\d+(\.\d{3,})$/.test(value)) {
                    this.value = parseFloat(value).toFixed(2);
                }
                const numeric = parseFloat(this.value);
                if (numeric > maxAmount) {
                    this.value = maxAmount.toFixed(2);
                    this.setCustomValidity("Maximum allowed is 99,999,999.9");
                    this.reportValidity();
                } else {
                    this.setCustomValidity("");
                }
                // Real-time feedback update
                goalAmountFeedback.textContent = `Current: $${this.value || '0.00'} / Max: 99,999,999.99`;
                goalAmountFeedback.style.color = (numeric > maxAmount) ? 'red' : '#555';
            });
            imageFileInput.addEventListener('change', validateImageFile);

            // Prevent form submission if validation fails
            const form = document.querySelector('form');
            form.addEventListener('submit', function (e) {
                if (!validateImageFile()) {
                    e.preventDefault();
                }
                if (goalAmountInput.getCustomValidity() !== '') {
                    e.preventDefault();
                    goalAmountInput.reportValidity();
                }
            });
        });
    </script>
</div>
