<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Campaign $campaign
 */
?>

<div class="container-xxl flex-grow-1 container-p-y">
    <div class="row">
        <div class="col-12">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Edit Campaign</h5>
                    <div>
                        <?= $this->Html->link(
                            '<i class="bx bx-arrow-back me-1"></i> Back to Campaigns',
                            ['action' => 'index'],
                            ['class' => 'btn btn-secondary btn-sm', 'escape' => false]
                        ) ?>
                        <?= $this->Form->postLink(
                            '<i class="bx bx-trash me-1"></i> Delete Campaign',
                            ['action' => 'delete', $campaign->id],
                            [
                                'confirm' => __('Are you sure you want to delete # {0}?', $campaign->id),
                                'class' => 'btn btn-danger btn-sm ms-2',
                                'escape' => false
                            ]
                        ) ?>
                        <?= $campaign->is_active
                            ? $this->Form->postLink(
                                '<i class="bx bx-block me-1"></i> Close Campaign',
                                ['action' => 'toggleVisibility', $campaign->id],
                                ['class' => 'btn btn-warning btn-sm ms-2', 'escape' => false]
                            )
                            : $this->Form->postLink(
                                '<i class="bx bx-play me-1"></i> Reopen Campaign',
                                ['action' => 'toggleVisibility', $campaign->id],
                                ['class' => 'btn btn-success btn-sm ms-2', 'escape' => false]
                            )
                        ?>
                    </div>
                </div>
                <div class="card-body">
                    <?= $this->Flash->render() ?>

                    <?php if ($campaign->getErrors()): ?>
                        <div class="alert alert-danger">
                            <ul>
                                <?php foreach ($campaign->getErrors() as $field => $errors): ?>
                                    <?php foreach ($errors as $error): ?>
                                        <li><?= h($error) ?></li>
                                    <?php endforeach; ?>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    <?php endif; ?>

                    <?= $this->Form->create($campaign, ['class' => 'row g-3', 'type' => 'file']) ?>

                    <div class="col-12">
                        <div class="form-group mb-3">
                            <label class="form-label" for="title">Title</label>
                            <?= $this->Form->control('title', [
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter the campaign title',
                                'required' => true,
                            ]) ?>
                        </div>
                    </div>

                    <div class="col-12">
                        <div class="form-group mb-3">
                            <label class="form-label" for="description">Description</label>
                            <?= $this->Form->control('description', [
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter the campaign description',
                                'type' => 'textarea',
                                'rows' => 4,
                                'required' => true,
                            ]) ?>
                        </div>
                    </div>

                    <div class="col-12">
                        <div class="form-group mb-3">
                            <label class="form-label" for="goal_amount">Goal Amount</label>
                            <?= $this->Form->control('goal_amount', [
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter the target donation amount (max: 99,999,999.9)',
                                'type' => 'text',
                                'step' => '0.01',
                                'max' => '99999999.99',
                                'required' => true,
                            ]) ?>
                            <div id="goal-amount-feedback" style="margin-top: 5px; font-size: 0.9rem; color: #555;">Max: 99,999,999.99</div>
                        </div>
                    </div>

                    <div class="col-12">
                        <div class="form-group mb-3">
                            <label class="form-label" for="image_file">Upload Image</label>
                            <?= $this->Form->control('image_file', [
                                'type' => 'file',
                                'class' => 'form-control',
                                'label' => false,
                                'accept' => 'image/*'
                            ]) ?>
                        </div>
                    </div>

                    <div class="col-12">
                        <hr class="my-4">
                        <?= $this->Form->button(__('Save Changes'), ['class' => 'btn btn-primary me-2']) ?>
                        <?= $this->Html->link(__('Cancel'), ['action' => 'index'], ['class' => 'btn btn-outline-secondary']) ?>
                    </div>

                    <?= $this->Form->end() ?>
                </div>
            </div>
        </div>
    </div>
  <script>
  document.addEventListener('DOMContentLoaded', function () {
      const goalInput = document.querySelector('input[name="goal_amount"]');
      const goalAmountFeedback = document.getElementById('goal-amount-feedback');
      const maxAmount = 99999999.99;

      goalInput.addEventListener('beforeinput', function (e) {
          const currentValue = this.value;
          const insertion = e.data || '';
          const newValue = currentValue.slice(0, this.selectionStart) + insertion + currentValue.slice(this.selectionEnd);

          if (/^\d{0,8}(\.\d{0,2})?$/.test(newValue)) {
              return;
          }

          e.preventDefault();
      });

      goalInput.addEventListener('input', function () {
          let value = this.value;
          if (/^\d+(\.\d{3,})$/.test(value)) {
              this.value = parseFloat(value).toFixed(2);
          }
          const numeric = parseFloat(this.value);
          if (numeric > maxAmount) {
              this.value = maxAmount.toFixed(2);
              this.setCustomValidity("Maximum allowed is 99,999,999.9");
              this.reportValidity();
          } else {
              this.setCustomValidity("");
          }
          goalAmountFeedback.textContent = `Current: $${this.value || '0.00'} / Max: 99,999,999.99`;
          goalAmountFeedback.style.color = (numeric > maxAmount) ? 'red' : '#555';
      });
  });
  </script>
</div>
