<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Campaign $campaign
 */
?>

<div class="container-xxl flex-grow-1 container-p-y">
    <div class="row">
        <!-- Main Card -->
        <div class="col-12">
            <div class="card shadow p-4">
                <div class="card-header bg-white rounded mb-3 d-flex justify-content-between align-items-center">
                    <h3 class="mb-0"><?= h($campaign->title) ?></h3>
                    <div>
                        <?= $this->Html->link(
                            '<i class="bx bx-edit me-1"></i> Edit Campaign',
                            ['action' => 'edit', $campaign->id],
                            ['class' => 'btn btn-outline-primary btn-sm me-2', 'escape' => false]
                        ) ?>
                        <?= $this->Form->postLink(
                            $campaign->is_active
                                ? '<i class="bx bx-block me-1"></i> Close Campaign'
                                : '<i class="bx bx-refresh me-1"></i> Reopen Campaign',
                            ['action' => 'toggleVisibility', $campaign->id],
                            [
                                'class' => $campaign->is_active ? 'btn btn-warning btn-sm me-2' : 'btn btn-success btn-sm me-2',
                                'escape' => false,
                                'confirm' => $campaign->is_active
                                    ? 'Are you sure you want to close this campaign?'
                                    : 'Are you sure you want to reopen this campaign?'
                            ]
                        ) ?>
                        <?= $this->Form->postLink(
                            '<i class="bx bx-trash me-1"></i> Delete Campaign',
                            ['action' => 'delete', $campaign->id],
                            [
                                'confirm' => __('Are you sure you want to delete # {0}?', $campaign->id),
                                'class' => 'btn btn-danger btn-sm',
                                'escape' => false
                            ]
                        ) ?>
                    </div>
                </div>

                <div class="card-body">
                    <div class="table-responsive mb-4">
                        <table class="table table-striped">
                            <tbody>
                                <tr>
                                    <th>Title</th>
                                    <td><?= h($campaign->title) ?></td>
                                </tr>
                                <tr>
                                    <th>Image</th>
                                    <td>
                                        <?php if (!empty($campaign->image_url)): ?>
                                            <img src="<?= h($campaign->image_url) ?>" alt="Campaign Image" style="max-width: 300px; height: auto; border-radius: 8px;">
                                            <div><small><?= h($campaign->image_url) ?></small></div>
                                        <?php else: ?>
                                            <em>No image provided</em>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <tr>
                                    <th>ID</th>
                                    <td><?= $this->Number->format($campaign->id) ?></td>
                                </tr>
                                <tr>
                                    <th>Goal Amount</th>
                                    <td><?= $campaign->goal_amount === null ? '' : '$' . $this->Number->format($campaign->goal_amount) ?></td>
                                </tr>
                                <tr>
                                    <th>Created</th>
                                    <td><?= h($campaign->created) ?></td>
                                </tr>
                                <tr>
                                    <th>Modified</th>
                                    <td><?= h($campaign->modified) ?></td>
                                </tr>
                                <tr>
                                    <th>Description</th>
                                    <td><?= $this->Text->autoParagraph(h($campaign->description)); ?></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                    <?php if (!empty($campaign->donations)) : ?>
                        <div class="table-responsive mb-4">
                            <h5 class="mb-3">Related Donations</h5>
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Amount</th>
                                        <th>Donor Email</th>
                                        <th>Stripe Transaction ID</th>
                                        <th>Status</th>
                                        <th>Created</th>
                                        <th>Modified</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($campaign->donations as $donation) : ?>
                                        <tr>
                                            <td><?= h($donation->id) ?></td>
                                            <td>$<?= h($donation->amount) ?></td>
                                            <td><?= h($donation->donor_email) ?></td>
                                            <td><?= h($donation->stripe_transaction_id) ?></td>
                                            <td><?= h($donation->status) ?></td>
                                            <td><?= h($donation->created) ?></td>
                                            <td><?= h($donation->modified) ?></td>
                                            <td>
                                                <?= $this->Html->link(
                                                    '<i class="bx bx-show-alt me-1"></i> View',
                                                    ['controller' => 'Donations', 'action' => 'view', $donation->id],
                                                    ['class' => 'btn btn-sm btn-outline-primary me-1', 'escape' => false]
                                                ) ?>
                                                <?= $this->Html->link(
                                                    '<i class="bx bx-edit-alt me-1"></i> Edit',
                                                    ['controller' => 'Donations', 'action' => 'edit', $donation->id],
                                                    ['class' => 'btn btn-sm btn-outline-secondary me-1', 'escape' => false]
                                                ) ?>
                                                <?= $this->Form->postLink(
                                                    '<i class="bx bx-trash me-1"></i> Delete',
                                                    ['controller' => 'Donations', 'action' => 'delete', $donation->id],
                                                    [
                                                        'class' => 'btn btn-sm btn-outline-danger',
                                                        'escape' => false,
                                                        'confirm' => __('Are you sure you want to delete # {0}?', $donation->id)
                                                    ]
                                                ) ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php endif; ?>

                    <div class="d-flex justify-content-between">
                        <?= $this->Html->link(
                            '<i class="bx bx-arrow-back me-1"></i> Back to Campaign List',
                            ['action' => 'index'],
                            ['class' => 'btn btn-secondary', 'escape' => false]
                        ) ?>
                        <?= $this->Html->link(
                            '<i class="bx bx-plus me-1"></i> Add New Campaign',
                            ['action' => 'add'],
                            ['class' => 'btn btn-primary', 'escape' => false]
                        ) ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>