<?php
/**
 * File: templates/Certificate/certificate.php
 */
?>
<!DOCTYPE html>
<html>
<head>
    <style>
        .certificate {
            text-align: center;
            font-family: Arial, sans-serif;
            width: 100%;
            height: 100%;
            position: relative;
        }
        .logo {
            margin-bottom: 20px;
        }
        .ribbon {
            text-align: right;
            margin-bottom: 20px;
        }
        .title {
            font-size: 24px;
            font-weight: bold;
            margin-bottom: 20px;
        }
        .recipient {
            font-size: 36px;
            font-weight: bold;
            margin-bottom: 20px;
            text-transform: uppercase;
        }
        .description {
            font-size: 16px;
            margin-bottom: 10px;
        }
        .event {
            font-size: 18px;
            font-weight: bold;
            margin-bottom: 10px;
        }
        .program {
            font-size: 16px;
            margin-bottom: 20px;
        }
        .footer {
            font-size: 12px;
            position: absolute;
            bottom: 15px;
            width: 100%;
            text-align: left;
            padding-left: 15px;
        }
        .footer span {
            margin-right: 20px;
        }
    </style>
</head>
<body>
<div class="certificate">
    <div class="logo">
        <img src="<?= $this->Url->webroot('img/logo.png') ?>" width="150" height="50" alt="Logo">
    </div>
    <div class="ribbon">
        <img src="<?= $this->Url->webroot('img/ribbon.png') ?>" width="100" height="100" alt="Ribbon">
    </div>
    <div class="title">Certificate of Appreciation</div>
    <div class="recipient"><?= h($user['name']) ?></div>
    <div class="description">for helpful contributions in</div>
    <div class="event"><?= h($user['event']) ?></div>
    <div class="program"><?= h($user['program']) ?></div>
    <div class="footer">
        <span>cert id: <?= h($user['cert_id']) ?></span>
        <span>verify: <?= h($user['verify_url']) ?></span>
    </div>
</div>
</body>
</html>
