<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js"></script>

<?php
// PHP code remains unchanged
?>

<div>
    <button id="backBtn" class="button" style="background-color: #f3884a">
        <svg class="back-icon" xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none"
             stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
            <path d="M15 18l-6-6 6-6"></path>
        </svg>
        Back
    </button>
    <div class="certificate-container" id="certificate-container">
        <div class="header1">
            <?= $this->ContentBlock->image('website-logo', ['class' => 'organization-logo', 'alt' => 'Organization Logo']); ?>
            <h4 style="margin-left: 20px;color: #f3884a">STEM Incubators</h4>
        </div>

        <?php
        // Truncate badge text to a maximum of 25 characters
        $badge_text = strlen($certificate['badge']) > 25 ? substr($certificate['badge'], 0, 25) . '...' : $certificate['badge'];
        ?>
        <div class="badge-container">
            <div class="badge-circle">
                <span class="badge-text"><?= h($badge_text) ?></span>
            </div>
            <div class="ribbon ribbon-left"></div>
            <div class="ribbon ribbon-right"></div>
        </div>

        <h1>Certificate of Appreciation</h1>
        <div class="h2"style="color: #f3884a; font-weight: bold; text-shadow: 1px 1px 2px rgba(0,0,0,0.3);">
            <?= h($certificate['volunteer']) ?>
        </div >


        <div class="subtitle">
            <?= h($certificate['custom_text']) ?>
        </div>

        <div class="program-list">
            <?php if (!empty($certificate['program1']) && $certificate['program1'] !== 'N/A'): ?>
                <?= h($certificate['program1']) ?><br>
            <?php endif; ?>

            <?php if (!empty($certificate['program2']) && $certificate['program2'] !== 'N/A'): ?>
                <?= h($certificate['program2']) ?><br>
            <?php endif; ?>

            <?php if (!empty($certificate['program3']) && $certificate['program3'] !== 'N/A'): ?>
                <?= h($certificate['program3']) ?><br>
            <?php endif; ?>
        </div>

        <div class="footer1">
            <div class="cert-id" style="color: #0c0c0c">
                Date: <?= h(date('d-M-y', strtotime($certificate['date_of_creation']))) ?>
            </div>
            <div class="verification">
                <?php
                $verification_url = $this->Url->build('/certificate/showcertificate/' . $certificate['cert_id'], ['fullBase' => true]);
                $qrcode_url = 'https://api.qrserver.com/v1/create-qr-code/?size=80x80&data=' . urlencode($verification_url);
                ?>
                <img src="<?= $qrcode_url ?>" alt="Verification QR Code for <?= h($verification_url) ?>"
                     class="verification-qrcode">
                <span class="verification-text" style="color: #0c0c0c">Verify</span>
            </div>
        </div>
    </div>
    <div class="certificate-image-container" id="certificate-image-container" style="display: none;">
        <img id="certificate-image" alt="Certificate Image" style="width: 100%; height: auto;">
    </div>

    <?php if (!empty($certificate['include_banner'])): ?>
        <!-- Original Banner -->
        <div class="banner-container" id="banner-container">
            <div class="banner-content">
                <div class="banner-logo">
                    <?= $this->ContentBlock->image('website-logo', ['class' => 'organization-logo', 'alt' => 'STEM Incubators Logo']); ?>
                    <h4 style="color: #f3884a;">STEM Incubators</h4>
                </div>
                <div class="banner-text" style="margin-top: 40px">
                    <h2><?= h($certificate['volunteer']) ?></h2>
                </div>
                <div class="badge-container">
                    <div class="badge-circle">
                        <span class="badge-text"><?= h($badge_text) ?></span>
                    </div>
                    <div class="ribbon ribbon-left"></div>
                    <div class="ribbon ribbon-right"></div>
                </div>
            </div>
        </div>
        <div class="banner-image-container" id="banner-image-container" style="display: none;">
            <img id="banner-image" alt="Banner Image" style="width: 100%; height: auto;">
        </div>
        <div style="margin-bottom: 30px"></div>
        <!-- Small Banner -->
        <div class="banner-container small-banner" id="small-banner-container">
            <div class="banner-content">
                <div class="banner-logo">
                    <?= $this->ContentBlock->image('website-logo', ['class' => 'organization-logo', 'alt' => 'STEM Incubators Logo']); ?>
                    <h4 style="color: #f3884a">STEM Incubators</h4>
                </div>
                <div class="banner-text" style="margin-top: 40px">
                    <h2><?= h($certificate['volunteer']) ?></h2>
                </div>
                <div class="badge-container">
                    <div class="badge-circle">
                        <span class="badge-text"><?= h($badge_text) ?></span>
                    </div>
                    <div class="ribbon ribbon-left"></div>
                    <div class="ribbon ribbon-right"></div>
                </div>
            </div>
        </div>
        <div class="banner-image-container small-banner" id="small-banner-image-container" style="display: none;">
            <img id="small-banner-image" alt="Small Banner Image" style="width: 100%; height: auto;">
        </div>
    <?php endif; ?>

    <div style="text-align: center; margin: 40px;">
        <button id="downloadBtn" class="button">Download Certificate Image</button>
        <?php if (!empty($certificate['include_banner'])): ?>
            <button id="downloadBannerBtn1" class="button">Download Banner Image</button>
            <button id="downloadBannerBtn2" class="button">Download Small Banner Image</button>
        <?php endif; ?>
    </div>
</div>

<style>
    /* Base styles */
    html, body {
        margin: 0;
        padding: 0;
        width: 100%;
        height: 100%;
    }

    body {
        color: #333;
        margin: 0;
        padding: 0;
        overflow-x: hidden;
    }

    .certificate-container {
        width: 1200px;
        min-height: 520px;
        margin: 20px auto;
        padding: 10px;
        background-color: #ffffff;
        position: relative;
        font-family: 'Arial', sans-serif;
        overflow: hidden;
        box-sizing: border-box;
        box-shadow: 0 5px 25px rgba(0, 0, 0, 0.1);
    }

    .banner-container {
        width: 1000px;
        height: 250px;
        margin: 20px auto;
        padding: 30px;
        background-image: url('../../img/bannerimg.jpg');
        background-size: cover;
        background-position: center;
        background-repeat: no-repeat;
        position: relative;
        font-family: 'Arial', sans-serif;
        overflow: hidden;
        box-sizing: border-box;
    }

    .banner-container.small-banner {
        width: 800px;
        height: 200px;
    }

    .certificate-image-container,
    .banner-image-container {
        max-width: 1200px;
        margin: 20px auto;
        text-align: center;
    }

    .banner-image-container {
        max-width: 1000px;
    }

    .banner-image-container.small-banner {
        max-width: 800px;
    }

    .certificate-container *,
    .banner-container * {
        box-sizing: border-box;
        max-width: 100%;
    }

    .header1, .banner-logo {
        display: flex;
        justify-content: flex-start;
        align-items: center;
        position: absolute;
        top: 30px;
        left: 30px;
    }

    .banner-logo {
        margin-bottom: 0;
    }

    .banner-content {
        width: 100%;
        height: 100%;
        position: relative;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .organization-logo {
        width: 120px;
        height: 70px;
        object-fit: contain;
    }

    .banner-text {
        flex: 1;
        text-align: center;
        display: flex;
        justify-content: center;
        align-items: center;
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        width: 80%;
    }

    h1 {
        font-size: 50px;
        font-weight: 700;
        color: #2b5797;
        margin: 100px 0 20px;
        text-align: center;
        text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.1);
        max-width: 90%;
    }

    .h2 {
        font-size: 40px;
        font-weight: normal;
        color: #444;
        margin: 10px 0;
        text-align: center;
        max-width: 90%;
        overflow: hidden;
        text-overflow: ellipsis;
    }

    .banner-text h2 {
        font-size: 36px;
        font-weight: bold;
        color: #2b5797;
        margin: 0;
        text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.1);
    }

    .small-banner .banner-text h2 {
        font-size: 32px;
    }

    .subtitle {
        font-size: 22px;
        text-align: center;
        color: #666;
        margin: 10px 0;
        line-height: 1.6;
        max-width: 90%;
    }

    .program-list {
        font-size: 24px;
        text-align: center;
        color: #333;
        margin: 20px 0;
        font-weight: bold;
        max-width: 90%;
    }

    .program-list br {
        margin: 10px 0;
    }

    .footer1 {
        position: absolute;
        bottom: 20px;
        left: 50px;
        right: 50px;
        display: flex;
        justify-content: space-between;
        align-items: flex-end;
        font-size: 16px;
        color: #888;
    }

    .footer1 .cert-id {
        font-weight: bold;
        color: #888;
    }

    .footer1 .verification {
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
    }

    .verification-qrcode {
        width: 50px;
        height: 50px;
        display: block;
        margin-bottom: 5px;
    }

    .verification-text {
        font-size: 8px;
        color: #555;
        font-weight: bold;
    }

    .badge-container {
        position: absolute;
        top: 30px;
        right: 40px;
        width: 150px;
        height: 180px;
        display: flex;
        justify-content: center;
        align-items: flex-start;
        z-index: 10;
    }

    .banner-container .badge-container {
        top: 20px;
        right: 30px;
        width: 120px;
        height: 150px;
    }

    .small-banner .badge-container {
        top: 15px;
        right: 20px;
        width: 100px;
        height: 130px;
    }

    .badge-circle {
        width: 120px;
        height: 120px;
        border: 5px solid #3d8dff;
        border-radius: 50%;
        background: #e3f2fb;
        position: relative;
        z-index: 2;
        display: flex;
        justify-content: center;
        align-items: center;
        text-align: center;
        box-shadow: 0 3px 6px rgba(0, 0, 0, 0.1);
        overflow: hidden;
    }

    .banner-container .badge-circle {
        width: 100px;
        height: 100px;
    }

    .small-banner .badge-circle {
        width: 90px;
        height: 90px;
        border: 4px solid #3d8dff;
    }

    .badge-text {
        color: #2b5797;
        font-weight: bold;
        font-size: 10px;
        padding: 0 12px;
        max-width: 90%;
        line-height: 1.1;
        text-transform: uppercase;
        overflow-wrap: break-word;
        overflow: hidden;
        text-overflow: ellipsis;
    }

    .banner-container .badge-text {
        font-size: 9px;
        padding: 0 10px;
    }

    .small-banner .badge-text {
        font-size: 8px;
        padding: 0 8px;
    }

    .ribbon {
        position: absolute;
        width: 50px;
        height: 70px;
        background: linear-gradient(45deg, #facc15, #f97316);
        clip-path: polygon(50% 0%, 100% 25%, 100% 100%, 50% 85%, 0% 100%, 0% 25%);
        z-index: 1;
        bottom: 15px;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.2);
    }

    .banner-container .ribbon {
        width: 40px;
        height: 60px;
    }

    .small-banner .ribbon {
        width: 35px;
        height: 50px;
    }

    .ribbon-left {
        left: calc(50% - 42px);
        transform: rotate(25deg);
    }

    .banner-container .ribbon-left {
        left: calc(50% - 35px);
    }

    .small-banner .ribbon-left {
        left: calc(50% - 30px);
    }

    .ribbon-right {
        right: calc(50% - 42px);
        transform: rotate(-25deg);
    }

    .banner-container .ribbon-right {
        right: calc(50% - 35px);
    }

    .small-banner .ribbon-right {
        right: calc(50% - 30px);
    }

    .button {
        display: inline-block;
        padding: 10px 20px;
        margin: 10px;
        background-color: #3d8dff;
        color: white;
        text-decoration: none;
        border-radius: 5px;
        font-size: 16px;
        border: none;
        cursor: pointer;
    }

    .button:hover {
        opacity: 0.9;
    }

    /* Responsive scaling for images */
    @media (max-width: 1280px) {
        .certificate-image-container,
        .banner-image-container {
            transform: scale(0.9);
            transform-origin: top center;
        }
    }

    @media (max-width: 1024px) {
        .certificate-image-container,
        .banner-image-container {
            transform: scale(0.8);
        }
    }

    @media (max-width: 768px) {
        .certificate-container {
            margin: 10px auto; /* Increased vertical margin */
            padding: 30px; /* Reduced padding for better fit */
            height: auto; /* Allow height to adjust dynamically */
        }

        .banner-container {
            margin: 30px auto; /* Increased vertical margin */
            padding: 20px;
            height: auto; /* Allow height to adjust dynamically */
        }

        .banner-container.small-banner {
            margin: 25px auto; /* Slightly smaller margin for small banner */
        }

        .certificate-image-container,
        .banner-image-container {
            margin: 25px auto; /* Increased vertical margin */
            transform: scale(0.65);
        }

        .banner-image-container.small-banner {
            margin: 20px auto; /* Slightly smaller margin */
        }

        h1 {
            font-size: 40px; /* Slightly smaller font size */
            margin: 80px 0 15px; /* Adjusted vertical margins */
        }

        h2 {
            font-size: 32px; /* Slightly smaller font size */
            font-weight: bold;
            margin: 15px 0; /* Increased vertical margin */
        }

        .banner-text h2 {
            font-size: 28px; /* Adjusted for banner */
            margin: 10px 0; /* Adjusted vertical margin */
        }

        .small-banner .banner-text h2 {
            font-size: 24px; /* Adjusted for small banner */
        }

        .subtitle {
            font-size: 18px; /* Smaller font size */
            margin: 15px 0; /* Increased vertical margin */
        }

        .program-list {
            font-size: 20px; /* Smaller font size */
            margin: 15px 0; /* Increased vertical margin */
        }

        .program-list br {
            margin: 8px 0; /* Adjusted line break spacing */
        }

        .footer1 {
            flex-direction: column; /* Stack footer items vertically */
            align-items: center;
            bottom: 15px;
            gap: 15px; /* Add spacing between footer items */
        }

        .footer1 .cert-id,
        .footer1 .verification {
            text-align: center;
        }

        .button {
            width: 90%; /* Wider buttons for better tap targets */
            max-width: 250px;
            margin: 10px auto; /* Increased vertical margin between buttons */
            padding: 12px; /* Slightly larger padding for tap targets */
            font-size: 14px; /* Slightly smaller font size */
        }
    }

    @media (max-width: 480px) {
        .certificate-container {
            margin: 20px auto; /* Further reduced margin */
            padding: 20px;
        }

        .banner-container {
            margin: 20px auto; /* Further reduced margin */
            padding: 15px;
        }

        .banner-container.small-banner {
            margin: 15px auto;
        }

        .certificate-image-container,
        .banner-image-container {
            margin: 15px auto; /* Further reduced margin */
            transform: scale(0.5);
        }

        .banner-image-container.small-banner {
            margin: 10px auto;
        }

        h1 {
            font-size: 32px; /* Further reduced font size */
            margin: 60px 0 10px; /* Adjusted vertical margins */
        }

        h2 {
            font-size: 28px;
            font-weight: bold;
            margin: 10px 0; /* Adjusted vertical margin */
        }

        .banner-text h2 {
            font-size: 24px;
            margin: 8px 0;
        }

        .small-banner .banner-text h2 {
            font-size: 20px;
        }

        .subtitle {
            font-size: 16px;
            margin: 10px 0; /* Adjusted vertical margin */
        }

        .program-list {
            font-size: 18px;
            margin: 10px 0; /* Adjusted vertical margin */
        }

        .program-list br {
            margin: 6px 0; /* Further reduced line break spacing */
        }

        .footer1 {
            gap: 10px; /* Reduced gap for smaller screens */
        }

        .button {
            width: 95%;
            max-width: 200px;
            margin: 8px auto; /* Further reduced vertical margin */
            padding: 10px;
            font-size: 13px;
        }

        /* Ensure vertical spacing after banners */
        .banner-container + .banner-container,
        .banner-image-container + .banner-image-container {
            margin-top: 20px; /* Add spacing between stacked banners */
        }
    }

</style>

<script>
    // Function to convert element to image and display it
    function convertToImage(element, imageElement, container, width, height) {
        html2canvas(element, {
            scale: 2, // High resolution
            width: width,
            height: height,
            useCORS: true,
            backgroundColor: '#ffffff' // Match certificate background
        }).then(canvas => {
            const imgData = canvas.toDataURL('image/png');
            imageElement.src = imgData;
            container.style.display = 'block';
            element.style.display = 'none'; // Hide original container
        }).catch(err => {
            console.error('Failed to convert to image:', err);
            alert('Failed to render image. Please try again.');
        });
    }

    // Convert certificate to image on page load
    const certificateContainer = document.getElementById('certificate-container');
    const certificateImage = document.getElementById('certificate-image');
    const certificateImageContainer = document.getElementById('certificate-image-container');
    const qrImage = certificateContainer.querySelector('.verification-qrcode');

    function renderCertificateImage() {
        convertToImage(certificateContainer, certificateImage, certificateImageContainer, 1200, 540);
    }

    if (qrImage.complete && qrImage.naturalWidth !== 0) {
        renderCertificateImage();
    } else {
        qrImage.onload = renderCertificateImage;
        qrImage.onerror = function () {
            console.error('Failed to load QR code image.');
            alert('QR code image failed to load. Please try again.');
            qrImage.src = qrImage.src + '?t=' + new Date().getTime();
        };
    }

    // Convert banners to images if present
    <?php if (!empty($certificate['include_banner'])): ?>
    const bannerContainer = document.getElementById('banner-container');
    const bannerImage = document.getElementById('banner-image');
    const bannerImageContainer = document.getElementById('banner-image-container');
    convertToImage(bannerContainer, bannerImage, bannerImageContainer, 1000, 250);

    const smallBannerContainer = document.getElementById('small-banner-container');
    const smallBannerImage = document.getElementById('small-banner-image');
    const smallBannerImageContainer = document.getElementById('small-banner-image-container');
    convertToImage(smallBannerContainer, smallBannerImage, smallBannerImageContainer, 800);
    <?php endif; ?>

    // Download certificate image
    document.getElementById('downloadBtn').addEventListener('click', function () {
        const link = document.createElement('a');
        link.href = certificateImage.src;
        link.download = 'certificate.png';
        link.click();
    });

    // Download banner image
    <?php if (!empty($certificate['include_banner'])): ?>
    document.getElementById('downloadBannerBtn1').addEventListener('click', function () {
        const link = document.createElement('a');
        link.href = bannerImage.src;
        link.download = 'banner.png';
        link.click();
    });

    document.getElementById('downloadBannerBtn2').addEventListener('click', function () {
        const link = document.createElement('a');
        link.href = smallBannerImage.src;
        link.download = 'small_banner.png';
        link.click();
    });

    document.getElementById('backBtn').addEventListener('click', function () {
        window.history.back();
    });

    <?php endif; ?>
</script>
