<script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js"></script>



<div>
    <div id="certificate" class="certificate-container <?= 'template-' . $certificate['template'] ?>">

    <div class="header1">
            <?= $this->ContentBlock->image('website-logo', ['class' => 'organization-logo', 'alt' => 'Organization Logo']); ?>
            <h4 style="margin-left: 20px;">STEM Incubators</h4>
        </div>

        <?php
        // Truncate badge text to a maximum of 25 characters
        $badge_text = strlen($certificate['badge']) > 25 ? substr($certificate['badge'], 0, 25) . '...' : $certificate['badge'];
        ?>
        <div class="badge-container">
            <div class="badge-circle">
                <span class="badge-text"><?= h($badge_text) ?></span>
            </div>
            <div class="ribbon ribbon-left"></div>
            <div class="ribbon ribbon-right"></div>
        </div>

        <h1 style="margin-top: 100px">Certificate of Appreciation</h1>

        <h2><?= h($certificate['recipient_name']) ?></h2>

        <div class="subtitle">
            <?= h($certificate['custom_text']) ?>
        </div>

        <div class="program-list">
            <?php foreach ($certificate['selected_programs'] as $program): ?>
                <?= h($program) ?><br>
            <?php endforeach; ?>
        </div>

        <div class="footer1">
            <div class="cert-id" style="margin-top: 10px">Date: <?= h($certificate['date_of_creation']) ?></div>
            <div class="verification">
                <?php
                $verification_url = strtolower(str_replace(' ', '', $certificate['organization_name'])) . '.com/verify';
                $qrcode_url = 'https://api.qrserver.com/v1/create-qr-code/?size=80x80&data=' . urlencode($verification_url);
                ?>
                <img src="<?= $qrcode_url ?>" alt="Verification QR Code for <?= h($verification_url) ?>" class="verification-qrcode">
                <span class="verification-text">Verify</span>
            </div>
        </div>
    </div>



    <?php if (!empty($isPreview)): ?>
        <div style="text-align: center; margin-top: 20px;">
            <button class="button" onclick="downloadCertificate()">Download Certificate</button>
            <a href="<?= $this->Url->build(['action' => 'generate']) ?>" class="button">Download1 Certificate</a>
            </div>
    <?php endif; ?>
</div>

<style>
    /* Base styles (existing) */
    body {
        font-family: 'Georgia', serif;
        color: #333;
        margin: 0;
        padding: 0;
    }

    .certificate-container {
        width: 100%;
        max-width: 1200px;
        height: auto;
        min-height: 650px;
        margin: 30px auto;
        padding: 50px;
        background-color: #e3f2fb;
        border-radius: 20px;
        border: 2px solid #ccc;
        box-shadow: 0 20px 50px rgba(0, 0, 0, 0.1);
        position: relative;
        font-family: 'Arial', sans-serif;
        overflow: visible;
        box-sizing: border-box;
    }

    .banner-container {
        width: 100%;
        max-width: 1200px;
        height: auto;
        min-height: 200px;
        margin: 30px auto;
        padding: 30px;
        background-color: #e3f2fb;
        border-radius: 20px;
        border: 2px solid #ccc;
        box-shadow: 0 20px 50px rgba(0, 0, 0, 0.1);
        position: relative;
        font-family: 'Arial', sans-serif;
        overflow: visible;
        box-sizing: border-box;
    }

    .header1, .banner-logo {
        display: flex;
        justify-content: flex-start;
        align-items: center;
    }

    .banner-logo {
        margin-bottom: 0;
        flex: 0 0 auto;
        position: absolute;
        top: 30px;
        left: 30px;
    }

    .banner-content {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 100%;
        height: 100%;
        position: relative;
        min-height: 140px;
    }

    .organization-logo {
        max-width: 120px;
        max-height: 70px;
        object-fit: contain;
    }

    .banner-text {
        flex: 1;
        text-align: center;
        display: flex;
        justify-content: center;
        align-items: center;
    }

    h1 {
        font-size: clamp(30px, 5vw, 50px);
        font-weight: 700;
        color: #2b5797;
        margin: 40px 0 20px;
        text-align: center;
        text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.1);
    }

    h2 {
        font-size: clamp(24px, 4vw, 40px);
        font-weight: normal;
        color: #444;
        margin: 10px 0;
        text-align: center;
    }

    .banner-text h2 {
        font-size: clamp(20px, 3.5vw, 36px);
        font-weight: bold;
        color: #2b5797;
        margin: 0;
        text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.1);
    }

    .subtitle {
        font-size: clamp(16px, 2vw, 22px);
        text-align: center;
        color: #666;
        margin: 20px 0;
        line-height: 1.6;
    }

    .program-list {
        font-size: clamp(18px, 2.4vw, 24px);
        text-align: center;
        color: #333;
        margin: 20px 0;
        font-weight: bold;
    }

    .program-list br {
        margin: 10px 0;
    }

    .footer1 {
        position: relative;
        bottom: 0;
        left: 0;
        width: 100%;
        display: flex;
        justify-content: space-between;
        font-size: 16px;
        color: #888;
        padding: 0;
        box-sizing: border-box;
        margin-top: 30px;
    }

    .footer1 .cert-id {
        font-weight: bold;
        color: #333;
    }

    .footer1 .verification {
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        color: initial;
    }

    .verification-qrcode {
        width: 50px;
        height: 50px;
        display: block;
        margin-bottom: 5px;
    }

    .verification-text {
        font-size: 8px;
        color: #555;
        font-weight: bold;
    }

    .badge-container {
        position: absolute;
        top: 30px;
        right: 40px;
        width: 150px;
        height: 180px;
        display: flex;
        justify-content: center;
        align-items: flex-start;
        z-index: 10;
    }

    .banner-container .badge-container {
        top: 20px;
        right: 30px;
        width: 120px;
        height: 150px;
    }

    .badge-circle {
        width: 120px;
        height: 120px;
        border: 5px solid #3d8dff;
        border-radius: 50%;
        background: radial-gradient(circle, #ffffff 85%, #f0f8ff 100%);
        position: relative;
        z-index: 2;
        display: flex;
        justify-content: center;
        align-items: center;
        text-align: center;
        box-shadow: 0 3px 6px rgba(0, 0, 0, 0.1);
        overflow: hidden;
    }

    .banner-container .badge-circle {
        width: 100px;
        height: 100px;
    }

    .badge-text {
        color: #2b5797;
        font-weight: bold;
        font-size: 10px;
        padding: 0 12px;
        max-width: 90%;
        line-height: 1.1;
        text-transform: uppercase;
        overflow-wrap: break-word;
        overflow: hidden;
        text-overflow: ellipsis;
    }

    .banner-container .badge-text {
        font-size: 9px;
        padding: 0 10px;
    }

    .ribbon {
        position: absolute;
        width: 50px;
        height: 70px;
        background: #3474c8;
        clip-path: polygon(50% 0%, 100% 25%, 100% 100%, 50% 85%, 0% 100%, 0% 25%);
        z-index: 1;
        bottom: 15px;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.2);
    }

    .banner-container .ribbon {
        width: 40px;
        height: 60px;
    }

    .ribbon-left {
        left: calc(50% - 42px);
        transform: rotate(25deg);
    }

    .banner-container .ribbon-left {
        left: calc(50% - 35px);
    }

    .ribbon-right {
        right: calc(50% - 42px);
        transform: rotate(-25deg);
    }

    .banner-container .ribbon-right {
        right: calc(50% - 35px);
    }

    .template-formal {
        border: 4px solid #3d8dff;
        background-color: #fff;
        box-shadow: 0 5px 25px rgba(0, 0, 0, 0.1);
    }

    .template-modern {
        box-shadow: 0px 0px 40px rgba(0, 0, 0, 0.1);
        border-radius: 15px;
        background-color: #eaf4fc;
    }

    .button {
        display: inline-block;
        padding: 10px 20px;
        margin: 0 10px;
        background-color: #3d8dff;
        color: white;
        text-decoration: none;
        border-radius: 5px;
        font-size: 16px;
        border: none;
        cursor: pointer;
    }

    .button.secondary {
        background-color: #ccc;
        color: #333;
    }

    .button:hover {
        opacity: 0.9;
    }

    /* Tablet Breakpoint */
    @media (max-width: 1024px) {
        .certificate-container {
            padding: 40px;
            margin: 20px auto;
        }

        .banner-container {
            padding: 25px;
            margin: 20px auto;
        }

        .organization-logo {
            max-width: 100px;
            max-height: 60px;
        }

        .badge-container {
            width: 130px;
            height: 160px;
            top: 25px;
            right: 25px;
        }

        .banner-container .badge-container {
            width: 110px;
            height: 140px;
            top: 15px;
            right: 20px;
        }

        .badge-circle {
            width: 100px;
            height: 100px;
            border: 4px solid #3d8dff;
        }

        .banner-container .badge-circle {
            width: 90px;
            height: 90px;
        }
    }

    /* Small Tablet / Large Mobile */
    @media (max-width: 768px) {
        .certificate-container {
            padding: 30px;
            min-height: 500px;
        }

        .banner-container {
            padding: 20px;
            min-height: 180px;
        }

        .header1 {
            margin-bottom: 15px;
        }

        .banner-logo {
            position: relative;
            top: 0;
            left: 0;
            margin: 0 0 10px 0;
        }

        .banner-content {
            flex-direction: column;
            padding-top: 20px;
            min-height: 120px;
        }

        h1 {
            margin: 30px 0 15px;
        }

        .organization-logo {
            max-width: 90px;
            max-height: 50px;
        }

        .badge-container {
            width: 110px;
            height: 140px;
            top: 20px;
            right: 20px;
        }

        .banner-container .badge-container {
            position: relative;
            top: 5px;
            right: 0;
            margin: 0 auto;
            width: 100px;
            height: 130px;
        }

        .badge-circle {
            width: 90px;
            height: 90px;
        }

        .banner-container .badge-circle {
            width: 80px;
            height: 80px;
        }

        .badge-text {
            font-size: 9px;
        }

        .banner-container .badge-text {
            font-size: 8px;
        }

        .ribbon {
            width: 40px;
            height: 60px;
        }

        .banner-container .ribbon {
            width: 35px;
            height: 50px;
        }

        .ribbon-left {
            left: calc(50% - 35px);
        }

        .banner-container .ribbon-left {
            left: calc(50% - 30px);
        }

        .ribbon-right {
            right: calc(50% - 35px);
        }

        .banner-container .ribbon-right {
            right: calc(50% - 30px);
        }
    }

    /* Mobile Devices */
    @media (max-width: 480px) {
        .certificate-container {
            padding: 20px;
            margin: 10px auto;
            min-height: 450px;
        }

        .banner-container {
            padding: 15px;
            margin: 10px auto;
            min-height: 250px;
        }

        .header1, .banner-logo {
            flex-direction: column;
            align-items: center;
            text-align: center;
        }

        .header1 h4, .banner-logo h4 {
            margin: 10px 0 0 0 !important;
            font-size: 16px;
        }

        .banner-text {
            margin-top: 10px;
        }

        .banner-text h2 {
            padding: 0 10px;
        }

        .subtitle {
            margin: 15px 0;
        }

        .program-list {
            margin: 15px 0;
        }

        .footer1 {
            flex-direction: column;
            align-items: center;
            gap: 15px;
            margin-top: 25px;
        }

        .badge-container {
            position: relative;
            top: 5px;
            right: 0;
            margin: 0 auto;
            width: 100px;
            height: 130px;
        }

        .badge-circle {
            width: 80px;
            height: 80px;
            border: 3px solid #3d8dff;
        }

        .badge-text {
            font-size: 8px;
            padding: 0 8px;
        }

        .ribbon {
            width: 35px;
            height: 50px;
            bottom: 10px;
        }

        .ribbon-left {
            left: calc(50% - 30px);
        }

        .ribbon-right {
            right: calc(50% - 30px);
        }

        .button {
            padding: 8px 16px;
            margin: 5px;
            font-size: 14px;
            display: block;
            width: 80%;
            max-width: 200px;
            text-align: center;
        }
    }
</style>

<script>
    function downloadCertificate() {
        const element = document.getElementById('certificate');
        const opt = {
            margin:       0,
            filename:     'certificate.pdf',
            image:        { type: 'jpeg', quality: 0.98 },
            html2canvas:  { scale: 2 },
            jsPDF:        { unit: 'in', format: 'a4', orientation: 'portrait' }
        };
        html2pdf().set(opt).from(element).save();
    }
</script>

