<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Doc> $doc
 */
?>
<div class="doc index content">
    <?= $this->Html->link(__('New Doc'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Doc') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('docuniqueid') ?></th>
                    <th><?= $this->Paginator->sort('volunteer') ?></th>
                    <th><?= $this->Paginator->sort('name') ?></th>
                    <th><?= $this->Paginator->sort('certified') ?></th>
                    <th><?= $this->Paginator->sort('issue_date') ?></th>
                    <th><?= $this->Paginator->sort('program_name1') ?></th>
                    <th><?= $this->Paginator->sort('program_name2') ?></th>
                    <th><?= $this->Paginator->sort('program_name3') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($doc as $doc): ?>
                <tr>
                    <td><?= $this->Number->format($doc->id) ?></td>
                    <td><?= h($doc->docuniqueid) ?></td>
                    <td><?= h($doc->volunteer) ?></td>
                    <td><?= h($doc->name) ?></td>
                    <td><?= h($doc->certified) ?></td>
                    <td><?= h($doc->issue_date) ?></td>
                    <td><?= h($doc->program_name1) ?></td>
                    <td><?= h($doc->program_name2) ?></td>
                    <td><?= h($doc->program_name3) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $doc->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $doc->id]) ?>
                        <?= $this->Form->postLink(
                            __('Delete'),
                            ['action' => 'delete', $doc->id],
                            [
                                'method' => 'delete',
                                'confirm' => __('Are you sure you want to delete # {0}?', $doc->id),
                            ]
                        ) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>