<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Doc $doc
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Doc'), ['action' => 'edit', $doc->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Doc'), ['action' => 'delete', $doc->id], ['confirm' => __('Are you sure you want to delete # {0}?', $doc->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Doc'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Doc'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="doc view content">
            <h3><?= h($doc->name) ?></h3>
            <table>
                <tr>
                    <th><?= __('Docuniqueid') ?></th>
                    <td><?= h($doc->docuniqueid) ?></td>
                </tr>
                <tr>
                    <th><?= __('Volunteer') ?></th>
                    <td><?= h($doc->volunteer) ?></td>
                </tr>
                <tr>
                    <th><?= __('Name') ?></th>
                    <td><?= h($doc->name) ?></td>
                </tr>
                <tr>
                    <th><?= __('Certified') ?></th>
                    <td><?= h($doc->certified) ?></td>
                </tr>
                <tr>
                    <th><?= __('Program Name1') ?></th>
                    <td><?= h($doc->program_name1) ?></td>
                </tr>
                <tr>
                    <th><?= __('Program Name2') ?></th>
                    <td><?= h($doc->program_name2) ?></td>
                </tr>
                <tr>
                    <th><?= __('Program Name3') ?></th>
                    <td><?= h($doc->program_name3) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($doc->id) ?></td>
                </tr>
                <tr>
                    <th><?= __('Issue Date') ?></th>
                    <td><?= h($doc->issue_date) ?></td>
                </tr>
            </table>
            <div class="text">
                <strong><?= __('Badges') ?></strong>
                <blockquote>
                    <?= $this->Text->autoParagraph(h($doc->badges)); ?>
                </blockquote>
            </div>
        </div>
    </div>
</div>