<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?= $this->request->getAttribute('csrfToken') ?>">
    <title>Empower STEM Futures</title>
    <?= $this->Html->css('https://cdnjs.cloudflare.com/ajax/libs/normalize/8.0.1/normalize.min.css') ?>
    <?= $this->Html->css('https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css') ?>
    <style>
        :root {
            --orange: #E87533;
            --orange-light: #FFA563;
            --orange-dark: #D05F20;
            --blue: #3E88F2;
            --blue-light: #70A8FF;
            --green: #2EA876;
            --grey-light: #f5f5f5;
            --grey-lighter: #fafafa;
            --grey: #78716c;
            --grey-dark: #4B4945;
            --radius: 20px;
            --radius-sm: 12px;
            --spacing: 30px;
            --shadow: rgba(0,0,0,0.1);
            --shadow-hover: rgba(0,0,0,0.2);
            --transition: all 0.4s cubic-bezier(0.22, 1, 0.36, 1);
        }

        * { box-sizing: border-box; margin: 0; padding: 0; }

        body {
            font-family: "Inter", system-ui, sans-serif;
            background: var(--grey-lighter);
            color: #333;
            line-height: 1.6;
            overflow-x: hidden;
        }

        body::before {
            content: "";
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: radial-gradient(circle at 15% 25%, rgba(232, 117, 51, 0.06) 0%, transparent 50%),
            radial-gradient(circle at 85% 75%, rgba(62, 136, 242, 0.05) 0%, transparent 50%);
            z-index: -1;
        }

        .page-container {
            max-width: 1400px;
            margin: 0 auto;
            padding: var(--spacing);
        }

        /* Hero Section */
        .hero {
            position: relative;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            height: clamp(450px, 70vh, 650px);
            background: linear-gradient(145deg, var(--orange-dark) 0%, var(--orange-light) 40%, var(--blue) 100%);
            background-size: 300% 300%;
            animation: gradientPulse 10s ease infinite;
            border-radius: var(--radius);
            overflow: hidden;
            padding: calc(var(--spacing) * 2);
            box-shadow: 0 12px 50px rgba(232, 117, 51, 0.3);
        }

        .hero::before {
            content: '';
            position: absolute;
            inset: 0;
            background: url('data:image/svg+xml;utf8,<svg width="60" height="60" viewBox="0 0 60 60" xmlns="http://www.w3.org/2000/svg"><path d="M30 0 L60 30 L30 60 L0 30 Z" fill="none" stroke="rgba(255,255,255,0.2)" stroke-width="1.5"/></svg>');
            background-size: 60px 60px;
            opacity: 0.25;
            animation: patternDrift 25s linear infinite;
        }

        @keyframes gradientPulse {
            0% { background-position: 0% 0%; }
            50% { background-position: 100% 100%; }
            100% { background-position: 0% 0%; }
        }

        @keyframes patternDrift {
            0% { background-position: 0 0; }
            100% { background-position: 60px 60px; }
        }

        .hero-text {
            position: relative;
            z-index: 1;
            text-align: center;
            color: #fff;
            font-family: "Poppins", sans-serif;
            max-width: 1000px;
        }

        .hero-text h1 {
            font-size: clamp(2.8rem, 7vw, 4.5rem);
            font-weight: 800;
            text-shadow: 0 5px 20px rgba(0,0,0,0.3);
            letter-spacing: -0.03em;
        }

        .hero-text p {
            font-size: clamp(1.3rem, 3.8vw, 2rem);
            margin: 1.2rem 0 0;
            font-weight: 300;
            text-shadow: 0 3px 10px rgba(0,0,0,0.2);
        }

        .hero-cta {
            margin-top: 2.5rem;
            padding: 16px 40px;
            background: #fff;
            color: var(--orange-dark);
            font-size: 1.2rem;
            font-weight: 700;
            text-decoration: none;
            border-radius: 50px;
            display: inline-flex;
            align-items: center;
            gap: 12px;
            box-shadow: 0 8px 25px rgba(0,0,0,0.2);
            transition: var(--transition);
        }

        .hero-cta:hover {
            background: var(--orange);
            color: #fff;
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(232, 117, 51, 0.35);
        }

        .hero-sparkles {
            position: absolute;
            inset: 0;
            pointer-events: none;
            z-index: 0;
        }

        .sparkle {
            position: absolute;
            width: 6px;
            height: 6px;
            background: rgba(255, 255, 255, 0.9);
            border-radius: 50%;
            animation: sparkleDance 4s infinite ease-in-out;
        }

        @keyframes sparkleDance {
            0% { transform: scale(0.5); opacity: 0; }
            50% { transform: scale(1.2); opacity: 0.8; }
            100% { transform: scale(0.5); opacity: 0; }
        }

        /* Total Donations */
        .total-donations {
            background: #fff;
            padding: calc(var(--spacing) * 1.5);
            border-radius: var(--radius);
            box-shadow: 0 12px 40px var(--shadow);
            text-align: center;
            margin: calc(var(--spacing) * 2.5) 0;
            position: relative;
            overflow: hidden;
        }

        .total-donations::before {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 8px;
            background: linear-gradient(90deg, var(--orange-light), var(--blue));
        }

        .total-donations h3 {
            font-size: 2.2rem;
            color: var(--orange);
            font-weight: 700;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 15px;
        }

        #donation-counter {
            font-size: 2.5rem;
            color: var(--orange-dark);
            font-weight: 800;
        }

        .counter-animation {
            position: absolute;
            top: -50px;
            left: 50%;
            transform: translateX(-50%);
            font-size: 1.6rem;
            color: var(--green);
            font-weight: 700;
            animation: riseFade 3s ease forwards;
        }

        @keyframes riseFade {
            0% { opacity: 0; top: 0; }
            20% { opacity: 1; }
            100% { opacity: 0; top: -60px; }
        }

        /* Donation Section */
        .donation-section {
            background: #fff;
            border-radius: var(--radius);
            box-shadow: 0 12px 40px var(--shadow);
            padding: calc(var(--spacing) * 2);
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: calc(var(--spacing) * 2.5);
            margin-bottom: calc(var(--spacing) * 2.5);
            position: relative;
        }

        .donation-amount-selector, .donation-impact {
            display: flex;
            flex-direction: column;
            gap: calc(var(--spacing) * 1.5);
        }

        .donation-amount-selector h2, .donation-impact h2 {
            font-size: 2rem;
            color: var(--orange);
            font-weight: 700;
            position: relative;
            padding-bottom: 15px;
        }

        .donation-amount-selector h2::after, .donation-impact h2::after {
            content: "";
            position: absolute;
            bottom: 0;
            left: 0;
            width: 70px;
            height: 5px;
            background: var(--orange-light);
            border-radius: 5px;
        }

        .amount-buttons {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            gap: calc(var(--spacing) * 0.75);
        }

        .amount-button {
            flex: 1 1 100px;
            max-width: 120px;
            padding: 18px;
            background: #fff;
            border: 2px solid var(--grey-light);
            border-radius: var(--radius-sm);
            cursor: pointer;
            text-align: center;
            font-size: 1.2rem;
            font-weight: 700;
            color: var(--grey-dark);
            transition: var(--transition);
            position: relative;
            overflow: hidden;
        }

        .amount-button:hover {
            border-color: var(--orange-light);
            transform: scale(1.08);
            box-shadow: 0 8px 20px rgba(232, 117, 51, 0.2);
        }

        .amount-button.selected {
            background: var(--orange);
            color: #fff;
            border-color: var(--orange);
            box-shadow: 0 8px 20px rgba(232, 117, 51, 0.25);
            transform: scale(1.08);
        }

        .amount-button::before {
            content: "";
            position: absolute;
            inset: 0;
            background: radial-gradient(circle, rgba(255,255,255,0.2), transparent);
            opacity: 0;
            transition: var(--transition);
        }

        .amount-button:hover::before, .amount-button.selected::before {
            opacity: 1;
        }

        .other-amount-button {
            flex: 1 1 100px;
            max-width: 120px;
            padding: 18px;
            border: 2px dashed var(--grey-light);
            border-radius: var(--radius-sm);
            cursor: pointer;
            text-align: center;
            font-size: 1.2rem;
            font-weight: 700;
            color: var(--grey);
            transition: var(--transition);
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
        }

        .other-amount-button:hover {
            border-color: var(--orange-light);
            color: var(--orange);
            transform: scale(1.08);
            box-shadow: 0 8px 20px rgba(232, 117, 51, 0.2);
        }

        .custom-input {
            display: none;
            align-items: center;
            gap: 12px;
            background: var(--grey-lighter);
            border-radius: var(--radius-sm);
            padding: 10px 18px;
            margin-top: 20px;
            border: 1px solid var(--grey-light);
            max-width: 300px;
            margin-left: auto;
            margin-right: auto;
        }

        .custom-input.active {
            display: flex;
            animation: popIn 0.4s ease forwards;
        }

        @keyframes popIn {
            0% { opacity: 0; transform: scale(0.9); }
            100% { opacity: 1; transform: scale(1); }
        }

        .custom-input input {
            flex: 1;
            padding: 12px;
            border: none;
            background: transparent;
            font-size: 1.3rem;
            color: var(--grey-dark);
            outline: none;
        }

        .custom-input span {
            font-size: 1.3rem;
            font-weight: 600;
            color: var(--grey-dark);
        }

        .donate-button {
            padding: 20px;
            background: var(--orange);
            color: #fff;
            border: none;
            border-radius: var(--radius);
            font-size: 1.4rem;
            font-weight: 700;
            cursor: pointer;
            transition: var(--transition);
            box-shadow: 0 8px 25px rgba(232, 117, 51, 0.25);
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            max-width: 300px;
            margin: 0 auto;
        }

        .donate-button:hover {
            background: var(--orange-dark);
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(232, 117, 51, 0.35);
        }

        .powered-by-stripe {
            font-size: 0.9rem;
            color: var(--grey);
            text-align: center;
            margin-top: 10px;
        }

        /* Impact Items */
        .donation-impact {
            background: var(--grey-lighter);
            padding: calc(var(--spacing) * 1.5);
            border-radius: var(--radius);
        }

        .impact-item {
            display: flex;
            align-items: center;
            gap: calc(var(--spacing) * 1.5);
            padding: 25px;
            border-radius: var(--radius-sm);
            background: #fff;
            transition: var(--transition);
            box-shadow: 0 4px 15px rgba(0,0,0,0.05);
        }

        .impact-item:hover {
            transform: translateY(-8px);
            box-shadow: 0 8px 25px rgba(0,0,0,0.1);
        }

        .amount-box {
            background: var(--orange);
            color: #fff;
            padding: 14px 20px;
            border-radius: var(--radius-sm);
            font-weight: 700;
            min-width: 70px;
            text-align: center;
            font-size: 1.3rem;
            transition: var(--transition);
        }

        .impact-item:hover .amount-box {
            background: var(--orange-dark);
            transform: scale(1.1);
        }

        .impact-details h3 {
            font-size: 1.4rem;
            color: var(--grey-dark);
            font-weight: 600;
        }

        .impact-details p {
            margin: 8px 0 0;
            color: var(--grey);
            font-size: 1.1rem;
        }

        /* Enhanced Campaigns Section */
        .campaigns {
            margin: calc(var(--spacing) * 4) 0;
            position: relative;
        }

        .campaign-section-title {
            font-size: 2.5rem;
            font-weight: 800;
            color: var(--grey-dark);
            text-align: center;
            margin-bottom: calc(var(--spacing) * 2.5);
            position: relative;
            z-index: 1;
        }

        .campaign-section-title::after {
            content: "";
            position: absolute;
            bottom: -12px;
            left: 50%;
            transform: translateX(-50%);
            width: 120px;
            height: 6px;
            background: linear-gradient(90deg, var(--orange-light), var(--blue));
            border-radius: 6px;
        }

        .campaign-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(360px, 1fr));
            gap: calc(var(--spacing) * 2);
            position: relative;
        }

        .campaign-card {
            background: #fff;
            border-radius: var(--radius);
            box-shadow: 0 12px 40px var(--shadow);
            overflow: hidden;
            transition: transform 0.4s ease, box-shadow 0.4s ease;
            position: relative;
            display: flex;
            flex-direction: column;
            transform-style: preserve-3d;
            perspective: 1000px;
        }

        .campaign-card:hover {
            transform: none;
            box-shadow: none;
        }

        .campaign-image-wrapper {
            position: relative;
            height: 240px;
            overflow: hidden;
        }

        .campaign-image {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.9s ease;
        }

        .campaign-card:hover .campaign-image {
            transform: none;
        }

        .campaign-overlay {
            position: absolute;
            inset: 0;
            background: linear-gradient(to top, rgba(0,0,0,0.5) 0%, transparent 50%);
            opacity: 0.8;
            transition: opacity 0.4s ease;
        }

        .campaign-card:hover .campaign-overlay {
            opacity: 0.6;
        }

        .campaign-badge {
            position: absolute;
            top: 25px;
            right: 25px;
            background: var(--blue);
            color: #fff;
            padding: 8px 18px;
            border-radius: 30px;
            font-size: 1rem;
            font-weight: 700;
            box-shadow: 0 4px 15px rgba(62, 136, 242, 0.3);
            transition: var(--transition);
            z-index: 2;
        }

        .campaign-card:hover .campaign-badge {
            background: var(--blue-light);
            transform: scale(1.1);
        }

        .campaign-card h3 {
            margin: calc(var(--spacing) * 1.5);
            color: var(--orange-dark);
            font-size: 1.7rem;
            font-weight: 700;
            transition: color 0.4s ease;
        }

        .campaign-card:hover h3 {
            color: var(--orange);
        }

        .campaign-card p {
            margin: 0 calc(var(--spacing) * 1.5) calc(var(--spacing) * 1.5);
            color: var(--grey);
            font-size: 1.1rem;
            line-height: 1.6;
        }

        .campaign-progress-wrapper {
            padding: 0 calc(var(--spacing) * 1.5);
            margin-bottom: 20px;
        }

        .progress-bar {
            width: 100%;
            height: 14px;
            background: var(--grey-light);
            border-radius: 9999px;
            overflow: hidden;
            position: relative;
            box-shadow: inset 0 2px 5px rgba(0,0,0,0.1);
        }

        .progress {
            height: 100%;
            background: linear-gradient(90deg, var(--orange-light), var(--blue));
            transition: width 1.8s ease;
            border-radius: 9999px;
            position: relative;
            overflow: hidden;
        }

        .progress::before {
            content: "";
            position: absolute;
            inset: 0;
            background: linear-gradient(45deg, transparent 40%, rgba(255,255,255,0.3) 50%, transparent 60%);
            animation: progressGlow 2s infinite;
            opacity: 0;
        }

        .campaign-card:hover .progress::before {
            opacity: 1;
        }

        @keyframes progressGlow {
            0% { transform: translateX(-100%); }
            100% { transform: translateX(100%); }
        }

        .campaign-stats {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 15px calc(var(--spacing) * 1.5);
            font-size: 1.05rem;
            color: var(--grey);
            border-top: 1px solid var(--grey-light);
            margin-top: auto;
            background: linear-gradient(to top, rgba(245,245,245,0.8), transparent);
        }

        .campaign-percentage {
            font-weight: 700;
            color: var(--blue);
            font-size: 1.2rem;
            transition: color 0.4s ease;
        }

        .campaign-card:hover .campaign-percentage {
            color: var(--blue-light);
        }

        .campaign-goal {
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .campaign-goal i {
            color: var(--orange-light);
            transition: color 0.4s ease;
        }

        .campaign-card:hover .campaign-goal i {
            color: var(--orange);
        }

        .campaign-cta {
            position: absolute;
            bottom: 20px;
            left: 50%;
            transform: translateX(-50%);
            padding: 10px 25px;
            background: var(--orange);
            color: #fff;
            font-size: 1rem;
            font-weight: 600;
            text-decoration: none;
            border-radius: 25px;
            opacity: 0;
            transition: var(--transition);
            box-shadow: 0 4px 15px rgba(232, 117, 51, 0.3);
        }

        .campaign-card:hover .campaign-cta {
            opacity: 1;
            transform: translateX(-50%) translateY(-5px);
        }

        .campaign-cta:hover {
            background: var(--orange-dark);
            transform: translateX(-50%) translateY(-8px);
            box-shadow: 0 6px 20px rgba(232, 117, 51, 0.4);
        }

        /* Back to Top */
        .back-to-top {
            position: fixed;
            bottom: 40px;
            right: 40px;
            width: 60px;
            height: 60px;
            background: var(--orange);
            color: #fff;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 2rem;
            cursor: pointer;
            opacity: 0;
            transform: translateY(40px);
            transition: var(--transition);
            box-shadow: 0 8px 25px rgba(232, 117, 51, 0.3);
            z-index: 100;
        }

        .back-to-top.visible {
            opacity: 1;
            transform: translateY(0);
        }

        .back-to-top:hover {
            background: var(--orange-dark);
            transform: translateY(-8px);
            box-shadow: 0 10px 30px rgba(232, 117, 51, 0.4);
        }

        /* Other Ways to Support */
        .support-section {
            background: #fff;
            border-radius: var(--radius);
            box-shadow: 0 12px 40px var(--shadow);
            padding: calc(var(--spacing) * 2);
            margin: calc(var(--spacing) * 2.5) 0;
            text-align: center;
            position: relative;
            overflow: hidden;
        }

        .support-section::before {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 8px;
            background: linear-gradient(90deg, var(--orange-light), var(--blue));
        }

        .support-section h2 {
            font-size: 2rem;
            color: var(--orange);
            font-weight: 700;
            position: relative;
            padding-bottom: 15px;
            margin-bottom: calc(var(--spacing) * 1.5);
        }

        .support-section h2::after {
            content: "";
            position: absolute;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 70px;
            height: 5px;
            background: var(--orange-light);
            border-radius: 5px;
        }

        .support-section p {
            color: var(--grey);
            font-size: 1.1rem;
            margin-bottom: calc(var(--spacing) * 1.5);
        }

        .support-section ul {
            list-style-type: disc;
            max-width: 500px;
            margin: 0 auto;
            text-align: left;
            color: var(--grey-dark);
            font-size: 1.1rem;
            padding-left: 20px;
        }

        .support-section ul li {
            margin-bottom: 10px;
        }

        .support-section a {
            color: var(--orange);
            text-decoration: none;
            font-weight: 600;
            transition: var(--transition);
        }

        .support-section a:hover {
            color: var(--orange-dark);
            text-decoration: underline;
        }

        /* Mobile Responsiveness */
        @media (max-width: 768px) {
            .page-container {
                padding: 15px;
            }

            .hero {
                height: clamp(300px, 60vh, 400px);
                padding: 20px;
            }

            .hero-text h1 {
                font-size: clamp(2rem, 6vw, 3rem);
            }

            .hero-text p {
                font-size: clamp(1rem, 3vw, 1.3rem);
            }

            .hero-cta {
                padding: 12px 30px;
                font-size: 1rem;
                margin-top: 1.5rem;
            }

            .donation-section {
                grid-template-columns: 1fr;
                padding: 20px;
                gap: 20px;
            }

            .donation-amount-selector h2, .donation-impact h2 {
                font-size: 1.6rem;
            }

            .amount-buttons {
                gap: 10px;
            }

            .amount-button, .other-amount-button {
                flex: 1 1 80px;
                max-width: 100px;
                padding: 12px;
                font-size: 1rem;
            }

            .custom-input {
                max-width: 100%;
                padding: 8px 12px;
            }

            .custom-input input {
                font-size: 1.1rem;
            }

            .custom-input span {
                font-size: 1.1rem;
            }

            .donate-button {
                padding: 15px;
                font-size: 1.2rem;
                max-width: 100%;
            }

            .powered-by-stripe {
                font-size: 0.8rem;
                margin-top: 8px;
            }

            .impact-item {
                padding: 15px;
                gap: 10px;
            }

            .amount-box {
                padding: 10px 15px;
                font-size: 1.1rem;
                min-width: 60px;
            }

            .impact-details h3 {
                font-size: 1.2rem;
            }

            .impact-details p {
                font-size: 1rem;
            }

            .campaigns {
                margin: 40px 0;
            }

            .campaign-section-title {
                font-size: 1.8rem;
            }

            .campaign-grid {
                grid-template-columns: 1fr;
                gap: 20px;
            }

            .campaign-card {
                max-width: 100%;
            }

            .campaign-image-wrapper {
                height: 180px;
            }

            .campaign-card h3 {
                font-size: 1.4rem;
                margin: 20px;
            }

            .campaign-card p {
                font-size: 1rem;
                margin: 0 20px 20px;
            }

            .campaign-progress-wrapper {
                padding: 0 20px;
            }

            .campaign-stats {
                padding: 10px 20px;
                font-size: 0.9rem;
            }

            .campaign-percentage {
                font-size: 1rem;
            }

            .campaign-donate-form {
                padding: 15px;
            }

            .campaign-donate-form .amount-buttons {
                flex-direction: column;
                align-items: center;
            }

            .campaign-donate-form label {
                margin-right: 0;
                margin-bottom: 10px;
                width: 100%;
                text-align: center;
            }

            .campaign-donate-form input[type="number"] {
                font-size: 1rem;
                padding: 10px;
            }

            .campaign-donate-form .donate-button {
                font-size: 0.9rem;
                padding: 10px;
            }

            .support-section {
                padding: 20px;
                margin: 20px 0;
            }

            .support-section h2 {
                font-size: 1.6rem;
            }

            .support-section p {
                font-size: 1rem;
            }

            .support-section ul {
                font-size: 1rem;
                padding-left: 15px;
            }

            .back-to-top {
                width: 50px;
                height: 50px;
                bottom: 20px;
                right: 20px;
                font-size: 1.5rem;
            }
        }
    </style>
    <script src="https://js.stripe.com/v3/"></script>
</head>
<body>
<div class="page-container">
    <!-- Hero Section -->
    <div class="hero">
        <div class="hero-sparkles">
            <div class="sparkle" style="left: 15%; top: 20%; animation-delay: 0s;"></div>
            <div class="sparkle" style="left: 85%; top: 40%; animation-delay: 1s;"></div>
            <div class="sparkle" style="left: 50%; top: 70%; animation-delay: 2s;"></div>
            <div class="sparkle" style="left: 30%; top: 50%; animation-delay: 3s;"></div>
        </div>
        <div class="hero-text">
            <h1 style="color: #fff;">Ignite STEM Innovation</h1>
            <p>Support the next generation of problem-solvers with your donation.</p>
            <a href="#donate-form" class="hero-cta"><i class="fas fa-lightbulb"></i> Donate Now</a>
        </div>
    </div>

    <!-- Total Donations -->
    <!-- <div class="total-donations">
        <h3>
            <i class="fas fa-hand-holding-heart"></i>
            Total Raised:
            <span id="donation-counter" data-target=" ">$0.00</span>
        </h3>
        <div class="counter-animation" id="counter-float"></div>
    </div> -->

    <!-- Donation Section -->
    <form id="donate-form" action="#" method="post">
        <input type="hidden" name="amount" id="amount-input" value="50">
        <div class="donation-section">
            <div class="donation-amount-selector">
                <h2>Your Contribution</h2>
                <div class="amount-buttons">
                    <?php foreach ([10, 25, 50, 100] as $amt): ?>
                        <div class="amount-button<?= $amt === 50 ? ' selected' : '' ?>" data-amt="<?= $amt ?>">
                            $<?= $amt ?>
                        </div>
                    <?php endforeach; ?>
                    <div class="other-amount-button" id="other-btn">
                        <i class="fas fa-pen"></i> Custom
                    </div>
                </div>
                <div class="custom-input" id="custom-wrap">
                    <span>$</span>
                    <input type="number" min="1" step="0.01" id="customAmount" placeholder="Enter Amount">
                </div>
                <button type="submit" class="donate-button">
                    <i class="fas fa-donate"></i> Donate Now
                </button>
                <p class="powered-by-stripe">Powered by Stripe</p>
            </div>
            <div class="donation-impact">
                <h2>Your Impact</h2>
                <div class="impact-item">
                    <div class="amount-box">$25</div>
                    <div class="impact-details">
                        <h3>STEM Kits</h3>
                        <p>Hands-on learning materials.</p>
                    </div>
                </div>
                <div class="impact-item">
                    <div class="amount-box">$50</div>
                    <div class="impact-details">
                        <h3>Workshops</h3>
                        <p>Training for 5 students.</p>
                    </div>
                </div>
                <div class="impact-item">
                    <div class="amount-box">$100</div>
                    <div class="impact-details">
                        <h3>Mentorship</h3>
                        <p>Expert support for growth.</p>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <!-- Enhanced Campaigns Section -->
    <?php if (!empty($campaigns)): ?>
        <div class="campaigns">
            <h2 class="campaign-section-title">Featured Campaigns</h2>
            <div class="campaign-grid">
                <?php foreach ($campaigns as $c): ?>
                    <?php if (!$c->is_active) continue; ?>
                    <?php
                    $raised = 0;
                    foreach ($totalsByCampaign as $row) {
                        if ($row['campaign_id'] == $c->id) { $raised = $row['total']; break; }
                    }
                    $goal = $c->goal_amount ?? 0;
                    $pct = $goal ? min(100, round($raised / $goal * 100)) : 0;
                    ?>
                    <div class="campaign-card" data-tilt>
                        <div class="campaign-image-wrapper">
                            <?php
                            $imagePath = !empty($c->image_url) ? $c->image_url : 'default_campaign.jpg';
                            ?>
                            <img src="<?= $this->Url->image($imagePath) ?>" class="campaign-image" alt="<?= h($c->title) ?>">
                            <div class="campaign-overlay"></div>
                            <?php if (!empty($c->badge)): ?>
                                <div class="campaign-badge"><?= h($c->badge) ?></div>
                            <?php endif; ?>
                        </div>
                        <h3><?= h($c->title) ?></h3>
                        <p><?= h($c->description) ?></p>
                        <div class="campaign-progress-wrapper">
                            <div class="progress-bar">
                                <div class="progress" style="width: <?= $pct ?>%"></div>
                            </div>
                        </div>
                        <div class="campaign-stats">
                            <span class="campaign-percentage"><?= $pct ?>%</span>
                            <span class="campaign-goal"><i class="fas fa-bullseye"></i> $<?= number_format($raised, 2) ?> / $<?= number_format($goal, 2) ?></span>
                        </div>
                        <form class="campaign-donate-form" data-campaign-id="<?= $c->id ?>" style="padding: 20px;">
                            <div class="amount-buttons" style="margin-bottom: 10px;">
                                <?php foreach ([10, 25, 50, 100] as $amt): ?>
                                    <label style="margin-right: 10px;">
                                        <input type="radio" name="amount_<?= $c->id ?>" value="<?= $amt ?>"<?= $amt === 25 ? ' checked' : '' ?>> $<?= $amt ?>
                                    </label>
                                <?php endforeach; ?>
                                <label>
                                    <input type="radio" name="amount_<?= $c->id ?>" value="custom" id="customAmountRadio_<?= $c->id ?>"> Custom
                                </label>
                            </div>
                            <input type="number" name="custom_amount_<?= $c->id ?>" id="customAmount_<?= $c->id ?>" placeholder="Enter custom amount" min="1" step="0.01" class="custom-amount" style="width: 100%; margin-bottom: 10px; display: none;">
                            <button type="submit" class="donate-button" style="width: 100%; font-size: 1rem; padding: 12px;">Donate to this Campaign</button>
                        </form>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    <?php endif; ?>

    <!-- Other Ways to Support -->
    <div class="support-section">
        <h2>Other Ways to Support</h2>
        <p>We also welcome non-monetary contributions that support our mission. You can help us by offering:</p>
        <ul>
            <li>Donating unused laptops or tablets</li>
            <li>Volunteering your time or expertise</li>
            <li>Providing venues or equipment for workshops</li>
            <li>Spreading the word through social media or community groups</li>
        </ul>
        <p>To offer non-monetary support, please email us at <a href="mailto:karthik@stemincubators.com.au">karthik@stemincubators.com.au</a>.</p>
    </div>

    <div class="back-to-top">
        <i class="fas fa-chevron-up"></i>
    </div>

    <?= $this->Html->script([
        'https://cdnjs.cloudflare.com/ajax/libs/gsap/3.11.5/gsap.min.js',
        'https://cdnjs.cloudflare.com/ajax/libs/gsap/3.11.5/ScrollTrigger.min.js',
        // 'https://cdnjs.cloudflare.com/ajax/libs/vanilla-tilt/1.7.2/vanilla-tilt.min.js'
    ]) ?>
    <script>
        gsap.registerPlugin(ScrollTrigger);

        document.addEventListener('DOMContentLoaded', () => {
            // Donation Counter Animation
            const counter = document.getElementById('donation-counter');
            const floatEl = document.getElementById('counter-float');
            if (counter) {
                const target = parseFloat(counter.dataset.target) || 0;
                gsap.to(counter, {
                    innerHTML: target,
                    duration: 3,
                    ease: 'power3.out',
                    snap: { innerHTML: 1 },
                    onUpdate: () => {
                        counter.textContent = '$' + Math.round(counter.innerHTML).toLocaleString('en-US', { minimumFractionDigits: 2 });
                    },
                    onStart: () => {
                        floatEl.textContent = `+ $${target.toLocaleString('en-US', { minimumFractionDigits: 2 })}`;
                        floatEl.classList.add('counter-animation');
                    }
                });
            }

            // Amount Selection Logic
            const buttons = document.querySelectorAll('.amount-button');
            const customWrap = document.getElementById('custom-wrap');
            const customInput = document.getElementById('customAmount');
            const amountInput = document.getElementById('amount-input');

            buttons.forEach(btn => {
                btn.addEventListener('click', () => {
                    buttons.forEach(b => b.classList.remove('selected'));
                    btn.classList.add('selected');
                    customWrap.classList.remove('active');
                    amountInput.value = btn.dataset.amt;
                });
            });

            document.getElementById('other-btn').addEventListener('click', () => {
                customWrap.classList.toggle('active');
                if (customWrap.classList.contains('active')) {
                    buttons.forEach(b => b.classList.remove('selected'));
                    amountInput.value = '';
                    customInput.focus();
                }
            });

            customInput.addEventListener('input', e => {
                amountInput.value = e.target.value;
            });

            // Scroll Animations
            gsap.utils.toArray('.hero, .total-donations, .donation-section, .campaign-card, .support-section').forEach((el, i) => {
                gsap.from(el, {
                    opacity: 0,
                    y: 50,
                    duration: 1,
                    ease: 'power3.out',
                    scrollTrigger: {
                        trigger: el,
                        start: 'top 85%',
                    },
                    delay: i * 0.1
                });
            });

            // VanillaTilt.init(document.querySelectorAll('.campaign-card'), {
            //     max: 15,
            //     speed: 400,
            //     glare: true,
            //     'max-glare': 0.3,
            // });

            // Back to Top Button
            const backBtn = document.querySelector('.back-to-top');
            window.addEventListener('scroll', () => {
                backBtn.classList.toggle('visible', window.scrollY > 500);
            });
            backBtn.addEventListener('click', () => window.scrollTo({ top: 0, behavior: 'smooth' }));
        });

        // CSRF token retrieval
        const csrfToken = document.querySelector('meta[name="csrf-token"]')?.getAttribute('content');

        // Stripe form submit handler
        const form = document.getElementById('donate-form');
        if (form) {
            form.addEventListener('submit', async function (e) {
                e.preventDefault();
                const amount = document.getElementById('amount-input').value;
                if (!amount || parseFloat(amount) < 1) {
                    alert('Minimum donation is $1.');
                    return;
                }

                const response = await fetch('<?= $this->Url->build(["controller" => "Donate", "action" => "createDonationSession"]) ?>', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                        'X-CSRF-Token': csrfToken
                    },
                    body: 'amount=' + encodeURIComponent(amount)
                });

                if (!response.ok) {
                    const errorText = await response.text();
                    console.error('Error creating Stripe session:', errorText);
                    alert('Failed to create Stripe session.');
                    return;
                }

                const session = await response.json();
                const stripe = Stripe('pk_test_51RDfQI06V9ptDlsHV66ObtSeLbJm0Qmp7KmnQyobcIUtGLebrW5CINOm6NY32RvF45uPMlLlt8zgAzk4EsUfwfAG00n5mMNRnP');
                stripe.redirectToCheckout({ sessionId: session.id });
            });
        }
    </script>
    <script>
        // Campaign-specific donation forms
        document.querySelectorAll('.campaign-donate-form').forEach(form => {
            form.addEventListener('submit', async function (e) {
                e.preventDefault();
                const campaignId = this.getAttribute('data-campaign-id');
                const selectedAmount = this.querySelector('input[name="amount_' + campaignId + '"]:checked');
                const customAmountInput = this.querySelector('#customAmount_' + campaignId);
                let finalAmount = selectedAmount?.value === 'custom' ? customAmountInput?.value : selectedAmount?.value;

                if (!finalAmount || parseFloat(finalAmount) < 1) {
                    alert('Minimum donation is $1.');
                    return;
                }

                const response = await fetch('<?= $this->Url->build(["controller" => "Donate", "action" => "createDonationSession"]) ?>', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                        'X-CSRF-Token': csrfToken
                    },
                    body: 'amount=' + encodeURIComponent(finalAmount) + '&custom_amount=' + encodeURIComponent(finalAmount) + '&campaign_id=' + encodeURIComponent(campaignId)
                });

                if (!response.ok) {
                    const errorText = await response.text();
                    console.error('Error creating Stripe session:', errorText);
                    alert('Failed to create Stripe session.');
                    return;
                }

                const session = await response.json();
                const stripe = Stripe('pk_test_51RDfQI06V9ptDlsHV66ObtSeLbJm0Qmp7KmnQyobcIUtGLebrW5CINOm6NY32RvF45uPMlLlt8zgAzk4EsUfwfAG00n5mMNRnP');
                stripe.redirectToCheckout({ sessionId: session.id });
            });

            const campaignId = form.getAttribute('data-campaign-id');
            const customRadio = document.getElementById('customAmountRadio_' + campaignId);
            const customInput = document.getElementById('customAmount_' + campaignId);
            if (customRadio?.checked) {
                customInput.style.display = 'block';
            }
            form.querySelectorAll('input[name="amount_' + campaignId + '"]').forEach(radio => {
                radio.addEventListener('change', () => {
                    if (radio.value === 'custom') {
                        customInput.style.display = 'block';
                    } else {
                        customInput.style.display = 'none';
                    }
                });
            });
            customInput?.addEventListener('input', () => {
                if (customInput.value.trim() !== '') {
                    customRadio.checked = true;
                }
            });
        });

        // Ensure custom amount field appears on browser "Back" navigation
        window.addEventListener('pageshow', function () {
            document.querySelectorAll('.campaign-donate-form').forEach(form => {
                const campaignId = form.getAttribute('data-campaign-id');
                const customRadio = document.getElementById('customAmountRadio_' + campaignId);
                const customInput = document.getElementById('customAmount_' + campaignId);
                if (customRadio?.checked) {
                    customInput.style.display = 'block';
                }
            });
        });
    </script>
</body>
</html>
