<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Enquiry $enquiry
 */
?>
<div class="container-xxl flex-grow-1 container-p-y">
    <?= $this->Flash->render() ?>

    <!-- Card container for the form -->
    <div class="card">
        <div class="card-header">
            <!-- Display page title -->
            <h2><?= __('Add Enquiry') ?></h2>
        </div>
        <div class="card-body">
            <?= $this->Form->create($enquiry) ?>
            <fieldset>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="name">Name</label>
                            <?= $this->Form->control('name', ['label' => false, 'class' => 'form-control', 'id' => 'name']) ?>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="email">Email</label>
                            <?= $this->Form->control('email', ['label' => false, 'class' => 'form-control', 'id' => 'email']) ?>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="subject">Subject</label>
                            <?= $this->Form->control('subject', ['label' => false, 'class' => 'form-control', 'id' => 'subject']) ?>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="response_status">Response Status</label>
                            <?= $this->Form->control('response_status', ['label' => false, 'class' => 'form-control', 'id' => 'response_status']) ?>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group mb-3">
                            <label class="form-label" for="message">Message</label>
                            <?= $this->Form->control('message', ['label' => false, 'class' => 'form-control', 'id' => 'message']) ?>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group mb-3">
                            <label class="form-label" for="response">Response</label>
                            <?= $this->Form->control('response', ['label' => false, 'class' => 'form-control', 'id' => 'response']) ?>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="created_at">Created At</label>
                            <?= $this->Form->control('created_at', ['empty' => true, 'label' => false, 'class' => 'form-control', 'id' => 'created_at']) ?>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="updated_at">Updated At</label>
                            <?= $this->Form->control('updated_at', ['empty' => true, 'label' => false, 'class' => 'form-control', 'id' => 'updated_at']) ?>
                        </div>
                    </div>
                </div>
            </fieldset>
            <div class="text-end">
                <?= $this->Form->button(__('Submit'), ['class' => 'btn btn-primary']) ?>
            </div>
            <?= $this->Form->end() ?>
        </div>
    </div>

    <!-- Link to List Enquiries page -->
    <div class="mt-3">
        <?= $this->Html->link(__('List Enquiries'), ['action' => 'index'], ['class' => 'btn btn-secondary']) ?>
    </div>
</div>