<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Enquiry $enquiry
 */
?>
<div class="container-xxl flex-grow-1 container-p-y">
    <?= $this->Flash->render() ?>

    <div class="row">
        <!-- Sidebar -->
        <aside class="col-md-3">
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0"><?= __('Actions') ?></h5>
                </div>
                <div class="card-body">
                    <?= $this->Form->postLink(
                        __('Delete Enquiry'),
                        ['action' => 'delete', $enquiry->id],
                        [
                            'confirm' => __('Are you sure you want to delete # {0}?', $enquiry->id),
                            'class' => 'btn btn-danger btn-sm mb-2 w-100',
                            'escape' => false
                        ]
                    ) ?>
                    <?= $this->Html->link(
                        '<i class="bx bx-arrow-back me-1"></i> Back to Enquiries',
                        ['action' => 'index'],
                        ['class' => 'btn btn-secondary btn-sm w-100', 'escape' => false]
                    ) ?>
                </div>
            </div>
        </aside>

        <!-- Main Content -->
        <div class="col-md-9">
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0"><?= __('Edit Enquiry') ?></h5>
                </div>
                <div class="card-body">
                    <?= $this->Form->create($enquiry, ['class' => 'row g-3']) ?>
                    <fieldset>
                        <!-- Name -->
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label class="form-label" for="name">Name *</label>
                                <?= $this->Form->control('name', [
                                    'class' => 'form-control',
                                    'label' => false,
                                    'placeholder' => 'Enter name',
                                    'required' => true,
                                    'maxlength' => 50,
                                    'id' => 'name'
                                ]) ?>
                                <div id="name-counter" style="margin-top: 5px; font-size: 0.9rem; color: #555;">Characters: 0/50</div>
                            </div>
                        </div>

                        <!-- Email -->
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label class="form-label" for="email">Email *</label>
                                <?= $this->Form->control('email', [
                                    'class' => 'form-control',
                                    'label' => false,
                                    'placeholder' => 'Enter email',
                                    'type' => 'email',
                                    'required' => true,
                                    'maxlength' => 50,
                                    'id' => 'email'
                                ]) ?>
                                <div id="email-counter" style="margin-top: 5px; font-size: 0.9rem; color: #555;">Characters: 0/50</div>
                            </div>
                        </div>

                        <!-- Subject -->
                        <div class="col-12">
                            <div class="form-group mb-3">
                                <label class="form-label" for="subject">Subject *</label>
                                <?= $this->Form->control('subject', [
                                    'class' => 'form-control',
                                    'label' => false,
                                    'placeholder' => 'Enter subject',
                                    'required' => true,
                                    'maxlength' => 100,
                                    'id' => 'subject'
                                ]) ?>
                                <div id="subject-counter" style="margin-top: 5px; font-size: 0.9rem; color: #555;">Characters: 0/100</div>
                            </div>
                        </div>

                        <!-- Message -->
                        <div class="col-12">
                            <div class="form-group mb-3">
                                <label class="form-label" for="message">Message *</label>
                                <?= $this->Form->control('message', [
                                    'class' => 'form-control',
                                    'label' => false,
                                    'placeholder' => 'Enter message',
                                    'type' => 'textarea',
                                    'rows' => 5,
                                    'required' => true,
                                    'maxlength' => 1000,
                                    'id' => 'message'
                                ]) ?>
                                <div id="message-counter" style="margin-top: 5px; font-size: 0.9rem; color: #555;">Characters: 0/1000</div>
                            </div>
                        </div>

                        <!-- Response -->
                        <div class="col-12">
                            <div class="form-group mb-3">
                                <label class="form-label" for="response">Response</label>
                                <?= $this->Form->control('response', [
                                    'class' => 'form-control',
                                    'label' => false,
                                    'placeholder' => 'Enter response',
                                    'type' => 'textarea',
                                    'rows' => 5,
                                    'maxlength' => 1000,
                                    'id' => 'response'
                                ]) ?>
                                <div id="response-counter" style="margin-top: 5px; font-size: 0.9rem; color: #555;">Characters: 0/1000</div>
                            </div>
                        </div>

                        <!-- Response Status -->
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label class="form-label" for="response-status">Response Status</label>
                                <?= $this->Form->control('response_status', [
                                    'options' => ['0' => 'Not Responded', '1' => 'Responded'],
                                    'class' => 'form-select',
                                    'label' => false,
                                    'id' => 'response-status'
                                ]) ?>
                            </div>
                        </div>

                        <!-- Created At (Disabled) -->
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label class="form-label" for="created-at">Created At</label>
                                <?= $this->Form->control('created_at', [
                                    'class' => 'form-control',
                                    'label' => false,
                                    'disabled' => true,
                                    'id' => 'created-at'
                                ]) ?>
                            </div>
                        </div>

                        <!-- Updated At (Disabled) -->
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label class="form-label" for="updated-at">Updated At</label>
                                <?= $this->Form->control('updated_at', [
                                    'class' => 'form-control',
                                    'label' => false,
                                    'disabled' => true,
                                    'id' => 'updated-at'
                                ]) ?>
                            </div>
                        </div>
                    </fieldset>

                    <div class="col-12">
                        <hr class="my-4">
                        <?= $this->Form->button(__('Save Changes'), ['class' => 'btn btn-primary me-2']) ?>
                        <?= $this->Html->link(
                            __('Cancel'),
                            ['action' => 'index'],
                            ['class' => 'btn btn-outline-secondary']
                        ) ?>
                    </div>
                    <?= $this->Form->end() ?>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener("DOMContentLoaded", function () {
        // Get references to input fields and counters
        const nameInput = document.getElementById('name');
        const emailInput = document.getElementById('email');
        const subjectInput = document.getElementById('subject');
        const messageInput = document.getElementById('message');
        const responseInput = document.getElementById('response');

        const nameCounter = document.getElementById('name-counter');
        const emailCounter = document.getElementById('email-counter');
        const subjectCounter = document.getElementById('subject-counter');
        const messageCounter = document.getElementById('message-counter');
        const responseCounter = document.getElementById('response-counter');

        // Validation functions
        function validateName(input, maxLength) {
            // Allow letters, spaces, periods, commas, quotes, hyphens (same as certificate recipient name)
            let sanitized = input.replace(/[^a-zA-Z .,\'"-]/g, '');
            if (sanitized.length > maxLength) {
                sanitized = sanitized.substring(0, maxLength);
            }
            return sanitized;
        }

        function validateEmail(input, maxLength) {
            // Allow standard email characters (letters, numbers, @, dots, etc.)
            let sanitized = input.replace(/[^a-zA-Z0-9@._-]/g, '');
            if (sanitized.length > maxLength) {
                sanitized = sanitized.substring(0, maxLength);
            }
            return sanitized;
        }

        function validateText(input, maxLength) {
            // Allow letters, numbers, spaces, periods, commas, quotes, hyphens (same as certificate custom text)
            let sanitized = input.replace(/[^a-zA-Z0-9 .,\'"-]/g, '');
            if (sanitized.length > maxLength) {
                sanitized = sanitized.substring(0, maxLength);
            }
            return sanitized;
        }

        // Update counter functions
        function updateNameCounter() {
            nameInput.value = validateName(nameInput.value, 50);
            const charCount = nameInput.value.length;
            nameCounter.textContent = `Characters: ${charCount}/50${charCount === 50 ? ' (Maximum reached)' : ''}`;
            nameCounter.style.color = charCount === 50 ? 'red' : '#555';
        }

        function updateEmailCounter() {
            emailInput.value = validateEmail(emailInput.value, 50);
            const charCount = emailInput.value.length;
            emailCounter.textContent = `Characters: ${charCount}/50${charCount === 50 ? ' (Maximum reached)' : ''}`;
            emailCounter.style.color = charCount === 50 ? 'red' : '#555';
        }

        function updateSubjectCounter() {
            subjectInput.value = validateText(subjectInput.value, 100);
            const charCount = subjectInput.value.length;
            subjectCounter.textContent = `Characters: ${charCount}/100${charCount === 100 ? ' (Maximum reached)' : ''}`;
            subjectCounter.style.color = charCount === 100 ? 'red' : '#555';
        }

        function updateMessageCounter() {
            messageInput.value = validateText(messageInput.value, 1000);
            const charCount = messageInput.value.length;
            messageCounter.textContent = `Characters: ${charCount}/1000${charCount === 1000 ? ' (Maximum reached)' : ''}`;
            messageCounter.style.color = charCount === 1000 ? 'red' : '#555';
        }

        function updateResponseCounter() {
            responseInput.value = validateText(responseInput.value, 1000);
            const charCount = responseInput.value.length;
            responseCounter.textContent = `Characters: ${charCount}/1000${charCount === 1000 ? ' (Maximum reached)' : ''}`;
            responseCounter.style.color = charCount === 1000 ? 'red' : '#555';
        }

        // Initialize counters on page load
        updateNameCounter();
        updateEmailCounter();
        updateSubjectCounter();
        updateMessageCounter();
        updateResponseCounter();

        // Attach event listeners for real-time updates
        nameInput.addEventListener('input', updateNameCounter);
        emailInput.addEventListener('input', updateEmailCounter);
        subjectInput.addEventListener('input', updateSubjectCounter);
        messageInput.addEventListener('input', updateMessageCounter);
        responseInput.addEventListener('input', updateResponseCounter);
    });
</script>
