<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Enquiry $enquiry
 */
?>
<div class="container">
    <div class="header-container">
        <h3 class="program-header">Enquiry from: <?= h($enquiry->name) ?></h3>
    </div>

    <table class="info-table">
        <tr>
            <th>Name</th>
            <td><?= h($enquiry->name) ?></td>
        </tr>
        <tr>
            <th>Email</th>
            <td><?= h($enquiry->email) ?></td>
        </tr>
        <tr>
            <th>Subject</th>
            <td><?= h($enquiry->subject) ?></td>
        </tr>
        <tr>
            <th>ID</th>
            <td><?= $this->Number->format($enquiry->id) ?></td>
        </tr>
        <tr>
            <th>Created At</th>
            <td><?= h($enquiry->created_at) ?></td>
        </tr>
        <tr>
            <th>Updated At</th>
            <td><?= h($enquiry->updated_at) ?></td>
        </tr>
    </table>

    <div class="related-section">
        <h4>Message</h4>
        <div class="text">
            <blockquote>
                <?= $this->Text->autoParagraph(h($enquiry->message)); ?>
            </blockquote>
        </div>
    </div>


    <div class="related-section">
        <h4>Response Status</h4>
        <div class="text">
            <blockquote>
                <?= $enquiry->response_status == 1 ? 'Responded' : 'Not Responded'; ?>
            </blockquote>
        </div>
    </div>
</div>

<style>
    * {
        box-sizing: border-box;
        font-family: Arial, sans-serif;
    }

    .container {
        max-width: 1000px;
        margin: 0 auto;
        padding: 20px;
    }

    .header-container {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 20px;
    }

    .program-header {
        color: #333;
        margin: 0;
    }

    .info-table {
        width: 100%;
        border-collapse: collapse;
        margin-bottom: 30px;
        background: #fff;
        box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
    }

    .info-table th,
    .info-table td {
        padding: 15px;
        text-align: left;
        border-bottom: 1px solid #eee;
    }

    .info-table th {
        background: #f5f5f5;
        width: 30%;
    }

    .related-section {
        margin: 30px 0;
    }

    .related-section h4 {
        color: #2c3e50;
        margin-bottom: 15px;
        border-bottom: 2px solid #e87532;
        padding-bottom: 5px;
    }

    .text blockquote {
        background-color: #f9f9f9;
        border-left: 5px solid #ccc;
        margin: 0;
        padding: 10px 15px;
    }
</style>