<?php
    use Cake\Core\Configure;
    use Cake\Http\Exception\NotFoundException;

    $this->disableAutoLayout();
    ?>
    <!DOCTYPE html>
    <html>
    <head>
        <?= $this->Html->charset() ?>
        <?= $this->Html->meta('viewport', 'width=device-width, initial-scale=1.0') ?>
        <link rel="icon" type="image/x-icon" href="<?= $this->Url->webroot('favicon.ico') ?>">

        <title>Explore - Year 8 Program - <?= date('Y') ?></title>


        <?= $this->Html->css([
            'https://fonts.googleapis.com/css2?family=Roboto&display=swap',
            'vendor/bootstrap/css/bootstrap.min.css',
            'vendor/bootstrap-icons/bootstrap-icons.css',
            'vendor/aos/aos.css',
            'vendor/glightbox/css/glightbox.min.css',
            'vendor/swiper/swiper-bundle.min.css'
        ], ['pathPrefix' => 'assets/']) ?>

        <?= $this->Html->css('main.css', ['pathPrefix' => 'assets/css/']) ?>
    </head>

    <body class="index-page">
    <?= $this->element('header'); ?>

    <main class="main section py-5">
        <div class="container" data-aos="fade-up">
            <h1 class="text-center mb-5">Explore - Year 8 Program - <?= date('Y') ?></h1>

            <div class="row align-items-center mb-5">
                <div class="col-md-6 text-center">
                    <?= $this->ContentBlock->image('year-8-program-overview-image', ['class' => 'img-fluid rounded', 'alt' => 'Year 8 Program Overview']) ?>
                </div>
                <div class="col-md-6">
                    <h4>So... What do we do?</h4>
                    <ul>
                    <?= $this->ContentBlock->html('year-8-program-what-we-do'); ?>
                    </ul>
                </div>
            </div>

            <div class="row align-items-center bg-light p-4 rounded mb-5">
            <div class="col-md-6">
                <h4>Class Structure</h4>
                <?= $this->ContentBlock->html('year-8-program-class-structure'); ?>
            </div>
        </div>
        <div class="accordion mb-5" id="topicsAccordion">
            <div class="accordion-item">
                <h2 class="accordion-header">
                    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#mathematicsContent" aria-expanded="true">
                        Content – Mathematics Topics
                    </button>
                </h2>
                <div id="mathematicsContent" class="accordion-collapse collapse">
                <div class="accordion-body">
    <?= $this->ContentBlock->html('year-8-program-content-topics'); ?>
</div>
                </div>
            </div>
        </div>

            <section class="bg-light p-4 rounded mb-4">
                <h4>Payment – Terms and Conditions</h4>
                <?= $this->ContentBlock->html('year-8-program-payment-terms'); ?>

                <a href="https://docs.google.com/document/d/1pbcq0tRv2G7ZADh2h4HfKPife8BMQA_vsRY2qcb4C-E/edit?usp=sharing" class="btn btn-dark mb-2">Terms and Conditions - Y8</a>
                <br>
                <a href="<?= $this->Url->build('/student-register', ['fullBase' => true]) ?>" class="btn btn-primary">Register Now</a>
            </section>
        </div>
    </main>

    <?= $this->element('footer'); ?>

    <!-- Scroll Top & Vendor JS -->
    <a href="#" id="scroll-top" class="scroll-top d-flex align-items-center justify-content-center">
        <i class="bi bi-arrow-up-short"></i>
    </a>

<!-- JS  -->
<script src="<?= $this->Url->build('/assets/vendor/bootstrap/js/bootstrap.bundle.min.js') ?>"></script>
<script src="<?= $this->Url->build('/assets/vendor/php-email-form/validate.js') ?>"></script>
<script src="<?= $this->Url->build('/assets/vendor/aos/aos.js') ?>"></script>
<script src="<?= $this->Url->build('/assets/vendor/waypoints/noframework.waypoints.js') ?>"></script>
<script src="<?= $this->Url->build('/assets/vendor/glightbox/js/glightbox.min.js') ?>"></script>
<script src="<?= $this->Url->build('/assets/vendor/imagesloaded/imagesloaded.pkgd.min.js') ?>"></script>
<script src="<?= $this->Url->build('/assets/vendor/isotope-layout/isotope.pkgd.min.js') ?>"></script>
<script src="<?= $this->Url->build('/assets/vendor/swiper/swiper-bundle.min.js') ?>"></script>
<script src="<?= $this->Url->build('/assets/js/main.js') ?>"></script>


    </body>
    </html>
