<?php
?>

<div class="col-md-6">
    <div class="form-group mb-3">
        <label class="form-label" for="custom-text">Certificate Text</label>
        <?= $this->Form->control('custom_text', [
            'class' => 'form-control',
            'label' => false,
            'placeholder' => 'for helpful contributions in',
            'default' => 'for helpful contributions in',
            'id' => 'custom-text',
            'maxlength' => 50
        ]) ?>
        <div id="char-counter" style="margin-top: 5px; font-size: 0.9rem; color: #555;">Characters: 0/50</div>
    </div>
</div>

<script>
    // Character counter for custom_text
    document.addEventListener('DOMContentLoaded', function () {
        var input = document.getElementById('custom-text');
        var counter = document.getElementById('char-counter');

        function updateCounter() {
            var length = input.value.length;
            counter.textContent = 'Characters: ' + length + '/50';
        }

        input.addEventListener('input', updateCounter);

        // Initialize counter on page load
        updateCounter();
    });
</script>
