<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Faq $faq
 */
?>

<div class="container-xxl flex-grow-1 container-p-y">
    <div class="row">
        <!-- Main Card -->
        <div class="col-12">
            <div class="card shadow p-4">
                <div class="card-header bg-primary text-white rounded mb-3 d-flex justify-content-between align-items-center">
                    <h3 class="mb-0">FAQ Details</h3>
                    <div>
                        <?= $this->Html->link(
                            '<i class="bx bx-edit me-1"></i> Edit FAQ',
                            ['action' => 'edit', $faq->id],
                            ['class' => 'btn btn-light btn-sm me-2', 'escape' => false]
                        ) ?>
                        <?= $this->Form->postLink(
                            '<i class="bx bx-trash me-1"></i> Delete FAQ',
                            ['action' => 'delete', $faq->id],
                            [
                                'confirm' => __('Are you sure you want to delete # {0}?', $faq->id),
                                'class' => 'btn btn-danger btn-sm',
                                'escape' => false
                            ]
                        ) ?>
                    </div>
                </div>

                <div class="card-body">
                    <div class="table-responsive mb-4">
                        <table class="table table-striped">
                            <tbody>
                                <tr>
                                    <th>Question</th>
                                    <td><?= h($faq->question) ?></td>
                                </tr>
                                <tr>
                                    <th>Answer</th>
                                    <td><?= $this->Text->autoParagraph(h($faq->answer)); ?></td>
                                </tr>
                                <tr>
                                    <th>ID</th>
                                    <td><?= $this->Number->format($faq->id) ?></td>
                                </tr>
                                <tr>
                                    <th>Created</th>
                                    <td><?= h($faq->created) ?></td>
                                </tr>
                                <tr>
                                    <th>Modified</th>
                                    <td><?= h($faq->modified) ?></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                    <div class="d-flex justify-content-between">
                        <?= $this->Html->link(
                            '<i class="bx bx-arrow-back me-1"></i> Back to FAQ List',
                            ['action' => 'index'],
                            ['class' => 'btn btn-secondary', 'escape' => false]
                        ) ?>
                        <?= $this->Html->link(
                            '<i class="bx bx-plus me-1"></i> Add New FAQ',
                            ['action' => 'add'],
                            ['class' => 'btn btn-primary', 'escape' => false]
                        ) ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
