<?php
/**
 * CakePHP(tm) : Rapid Development Framework (https://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 * @link      https://cakephp.org CakePHP(tm) Project
 * @since     0.10.0
 * @license   https://opensource.org/licenses/mit-license.php MIT License
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Enquiry $enquiry
 */
use Cake\Cache\Cache;
use Cake\Core\Configure;
use Cake\Core\Plugin;
use Cake\Datasource\ConnectionManager;
use Cake\Error\Debugger;
use Cake\Http\Exception\NotFoundException;

$this->disableAutoLayout();

$checkConnection = function (string $name) {
    $error = null;
    $connected = false;
    try {
        ConnectionManager::get($name)->getDriver()->connect();
        // No exception means success
        $connected = true;
    } catch (Exception $connectionError) {
        $error = $connectionError->getMessage();
        if (method_exists($connectionError, 'getAttributes')) {
            $attributes = $connectionError->getAttributes();
            if (isset($attributes['message'])) {
                $error .= '<br />' . $attributes['message'];
            }
        }

    }

    return compact('connected', 'error');
};



?>
<!DOCTYPE html>
<html>

<head>
    <?= $this->Html->charset() ?>
    <?= $this->Html->meta('viewport', 'width=device-width, initial-scale=1.0') ?>
    <title><?= strip_tags($this->ContentBlock->text('website-name')); ?></title>
    <?= $this->Html->meta('description', '') ?>
    <?= $this->Html->meta('keywords', '') ?>

    <!-- Favicons -->
    <?= $this->Html->meta('icon', 'img/favicon.png', ['pathPrefix' => 'assets/']) ?>
    <?= $this->Html->meta('apple-touch-icon', 'img/apple-touch-icon.png', ['pathPrefix' => 'assets/']) ?>

    <!-- Fonts Preconnect -->
    <?= $this->Html->tag('link', null, ['rel' => 'preconnect', 'href' => 'https://fonts.googleapis.com']) ?>
    <?= $this->Html->tag('link', null, ['rel' => 'preconnect', 'href' => 'https://fonts.gstatic.com', 'crossorigin' => 'anonymous']) ?>
    <!-- Fonts CSS -->
    <?= $this->Html->css('https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&family=Noto+Sans:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Questrial:wght@400&display=swap') ?>

    <!-- Vendor CSS Files -->
    <?= $this->Html->css([
        'vendor/bootstrap/css/bootstrap.min.css',
        'vendor/bootstrap-icons/bootstrap-icons.css',
        'vendor/aos/aos.css',
        'vendor/glightbox/css/glightbox.min.css',
        'vendor/swiper/swiper-bundle.min.css'
    ], ['pathPrefix' => 'assets/']) ?>

    <!-- Main CSS File -->
    <?= $this->Html->css('main.css', ['pathPrefix' => 'assets/css/']) ?>

    <!-- Template Info Comment -->
    <?php
    echo '<!-- =======================================================
    * Template Name: EasyFolio
    * Template URL: https://bootstrapmade.com/easyfolio-bootstrap-portfolio-template/
    * Updated: Feb 21 2025 with Bootstrap v5.3.3
    * Author: BootstrapMade.com
    * License: https://bootstrapmade.com/license/
    ======================================================== -->';
    ?>
</head>

<body class="index-page">

<?= $this->Flash->render() ?>

    <?= $this->element('header'); ?>


<main class="main">

    <!-- Hero Section -->
    <section id="hero" class="hero section">

        <div class="container" data-aos="fade-up" data-aos-delay="100">

            <div class="row align-items-center content">
                <div class="col-lg-6" data-aos="fade-up" data-aos-delay="200">
                    <h2>Welcome to <?= strip_tags($this->ContentBlock->text('website-name')); ?></h2>
                    <p class="lead"><?= strip_tags($this->ContentBlock->html('landing-page-content-1')); ?></p>
                    <div class="cta-buttons" data-aos="fade-up" data-aos-delay="300">
                        <a href="#portfolio" class="btn btn-primary">View Our programs</a>
                        <a href="#contact" class="btn btn-outline">Let's Connect</a>
                    </div>
                    <div class="hero-stats" data-aos="fade-up" data-aos-delay="400">
                        <div class="stat-item">
                            <span class="stat-number">5+</span>
                            <span class="stat-label">Years Experience</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-number">100+</span>
                            <span class="stat-label">Projects Completed</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-number">50+</span>
                            <span class="stat-label">Happy volunteers</span>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="hero-image">
                        <img src="assets/img/profile/profile-1.webp" alt="Portfolio Hero Image" class="img-fluid" data-aos="zoom-out" data-aos-delay="300">
                        <div class="shape-1"></div>
                        <div class="shape-2"></div>
                    </div>
                </div>
            </div>

        </div>

    </section><!-- /Hero Section -->

    <!-- About Section -->
    <section id="about" class="about section light-background">

        <!-- Section Title -->
        <div class="container section-title" data-aos="fade-up">
            <h2>About</h2>
            <div class="title-shape">
                <svg viewBox="0 0 200 20" xmlns="http://www.w3.org/2000/svg">
                    <path d="M 0,10 C 40,0 60,20 100,10 C 140,0 160,20 200,10" fill="none" stroke="currentColor" stroke-width="2"></path>
                </svg>
            </div>
            <!-- <p>This is about us section</p> -->
        </div><!-- End Section Title -->

        <div class="container" data-aos="fade-up" data-aos-delay="100">

            <div class="row align-items-center">
                <div class="col-lg-6 position-relative" data-aos="fade-right" data-aos-delay="200">
                    <div class="about-image">
                    <?= $this->ContentBlock->image('picture-themselves', [
    'alt' => 'Portrait',
    'class' => 'img-fluid rounded-4',
    'style' => 'max-height: 400px; width: auto; display: block; margin-left: auto; margin-right: auto; object-fit: contain;'
]); ?>


                    </div>
                </div>

                <div class="col-lg-6" data-aos="fade-left" data-aos-delay="300">
                    <div class="about-content">
                        <span class="subtitle">About Me</span>

                        <h2><?= strip_tags($this->ContentBlock->html('about-me-title')); ?></h2>

                        <p class="lead mb-4"><?= strip_tags($this->ContentBlock->html('landing-page-content-1')); ?></p>

                        <p class="mb-4"></p>

                        <div class="personal-info">
                            <div class="row g-4">
                                <div class="col-6">
                                    <div class="info-item">
                                        <span class="label">Name</span>
                                        <span class="value"><?= strip_tags($this->ContentBlock->html('about-me-name')); ?></span>
                                    </div>
                                </div>

                                <div class="col-6">
                                    <div class="info-item">
                                        <span class="label">Phone</span>
                                        <span class="value"><?= strip_tags($this->ContentBlock->html('Phone')); ?></span>
                                    </div>
                                </div>

                                <div class="col-6">
                                    <div class="info-item">
                                        <span class="label">Age</span>
                                        <span class="value"><?= strip_tags($this->ContentBlock->text('about-me-age')); ?> Years</span>
                                    </div>
                                </div>

                                <div class="col-6">
                                    <div class="info-item">
                                        <span class="label">Email</span>
                                        <span class="value"><?= strip_tags($this->ContentBlock->html('email')); ?> </span>
                                    </div>
                                </div>

                                <div class="col-6">
                                    <div class="info-item">
                                        <span class="label">Occupation</span>
                                        <span class="value"><?= strip_tags($this->ContentBlock->html('occupation')); ?> </span>
                                    </div>
                                </div>

                                <div class="col-6">
                                    <div class="info-item">
                                        <span class="label">Nationality</span>
                                        <span class="value"><?= strip_tags($this->ContentBlock->text('nationality')); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="signature mt-4">
                            <div class="signature-image">
                            <?= $this->ContentBlock->image('signature', ['alt' => 'signature',  'width' => '10  0', 'height' => '100']) ?>
                            </div>
                            <div class="signature-info">
                                <h4><?= strip_tags($this->ContentBlock->html('about-me-name')); ?></h4>
                                <p><?= strip_tags($this->ContentBlock->html('occupation')); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>

    </section><!-- /About Section -->

    <!-- Skills Section -->
    <!-- <section id="skills" class="skills section">

        <div class="container" data-aos="fade-up" data-aos-delay="100">

            <div class="row g-4 skills-animation">

                <div class="col-md-6 col-lg-3" data-aos="fade-up" data-aos-delay="100">
                    <div class="skill-box">
                        <h3>HTML</h3>
                        <p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem.</p>
                        <span class="text-end d-block">90%</span>
                        <div class="progress">
                            <div class="progress-bar" role="progressbar" aria-valuenow="90" aria-valuemin="0" aria-valuemax="100"></div>
                        </div>
                    </div>
                </div>

                <div class="col-md-6 col-lg-3" data-aos="fade-up" data-aos-delay="200">
                    <div class="skill-box">
                        <h3>CSS</h3>
                        <p>Nemo enim ipsam voluptatem quia voluptas sit aspernatur.</p>
                        <span class="text-end d-block">90%</span>
                        <div class="progress">
                            <div class="progress-bar" role="progressbar" aria-valuenow="95" aria-valuemin="0" aria-valuemax="100"></div>
                        </div>
                    </div>
                </div>

                <div class="col-md-6 col-lg-3" data-aos="fade-up" data-aos-delay="300">
                    <div class="skill-box">
                        <h3>JavaScript</h3>
                        <p>Neque porro quisquam est qui dolorem ipsum quia dolor.</p>
                        <span class="text-end d-block">80%</span>
                        <div class="progress">
                            <div class="progress-bar" role="progressbar" aria-valuenow="80" aria-valuemin="0" aria-valuemax="100"></div>
                        </div>
                    </div>
                </div>

                <div class="col-md-6 col-lg-3" data-aos="fade-up" data-aos-delay="400">
                    <div class="skill-box">
                        <h3>Photoshop</h3>
                        <p>Quis autem vel eum iure reprehenderit qui in ea voluptate.</p>
                        <span class="text-end d-block">55%</span>
                        <div class="progress">
                            <div class="progress-bar" role="progressbar" aria-valuenow="55" aria-valuemin="0" aria-valuemax="100">
                            </div>
                        </div>
                    </div>
                </div>

            </div>

        </div>

    </section> -->
    <!-- /Skills Section -->
<!-- Resume Section -->
<section id="resume" class="resume section">

    <!-- Section Title -->
    <div class="container section-title" data-aos="fade-up">
        <h2>Resume</h2>
        <div class="title-shape">
            <svg viewBox="0 0 200 20" xmlns="http://www.w3.org/2000/svg">
                <path d="M 0,10 C 40,0 60,20 100,10 C 140,0 160,20 200,10" fill="none" stroke="currentColor" stroke-width="2"></path>
            </svg>
        </div>
        <p>Awards and contributions made in the field of STEM and community innovation.</p>
    </div><!-- End Section Title -->

    <!-- Achievements & Recognition -->
    <div class="container" data-aos="fade-up" data-aos-delay="100">
        <div class="row">
            <div class="col-12">
                <div class="resume-wrapper">
                    <div class="resume-block" data-aos="fade-up">
                        <h2>Achievements & Recognition</h2>

                        <div class="timeline">

                            <div class="timeline-item" data-aos="fade-up" data-aos-delay="100">
                                <div class="timeline-left">
                                    <h4 class="company">Telstra Change Maker Award</h4>
                                    <span class="period">2022</span>
                                </div>
                                <div class="timeline-dot"></div>
                                <div class="timeline-right">
                                    <h3 class="position">National Winner</h3>
                                    <p class="description">Recognised among 80+ NFPs across Australia for our STEM community impact.</p>
                                </div>
                            </div>

                            <div class="timeline-item" data-aos="fade-up" data-aos-delay="150">
                                <div class="timeline-left">
                                    <h4 class="company">Edstart Innovation Awards</h4>
                                    <span class="period">2022</span>
                                </div>
                                <div class="timeline-dot"></div>
                                <div class="timeline-right">
                                    <h3 class="position">Finalist – Technology & Innovation</h3>
                                    <p class="description">Recognised for innovation in STEM education and creative program delivery.</p>
                                </div>
                            </div>

                            <div class="timeline-item" data-aos="fade-up" data-aos-delay="200">
                                <div class="timeline-left">
                                    <h4 class="company">Kingston Council</h4>
                                    <span class="period">2021, 2023</span>
                                </div>
                                <div class="timeline-dot"></div>
                                <div class="timeline-right">
                                    <h3 class="position">Community Awards</h3>
                                    <p class="description">Nominee for Community Organisation (2021), Women of the Year (2023), and winner of Community Group of the Year (2023).</p>
                                </div>
                            </div>

                            <div class="timeline-item" data-aos="fade-up" data-aos-delay="250">
                                <div class="timeline-left">
                                    <h4 class="company">Selective School Success</h4>
                                    <span class="period">2021</span>
                                </div>
                                <div class="timeline-dot"></div>
                                <div class="timeline-right">
                                    <h3 class="position">Student Achievement</h3>
                                    <p class="description">76% of our students succeeded in entering Melbourne High and Nossal through volunteer-led coaching.</p>
                                </div>
                            </div>

                            <div class="timeline-item" data-aos="fade-up" data-aos-delay="300">
                                <div class="timeline-left">
                                    <h4 class="company">FIRST LEGO League</h4>
                                    <span class="period">2021, 2022</span>
                                </div>
                                <div class="timeline-dot"></div>
                                <div class="timeline-right">
                                    <h3 class="position">Regional Winners</h3>
                                    <p class="description">Won U10 and U14 regional categories for robotics and teamwork.</p>
                                </div>
                            </div>

                            <div class="timeline-item" data-aos="fade-up" data-aos-delay="350">
                                <div class="timeline-left">
                                    <h4 class="company">IBM / Australian Museum</h4>
                                    <span class="period">2021</span>
                                </div>
                                <div class="timeline-dot"></div>
                                <div class="timeline-right">
                                    <h3 class="position">Eureka Prize Finalist</h3>
                                    <p class="description">Finalist for creating a sustainable AI solution addressing environmental challenges.</p>
                                </div>
                            </div>

                            <div class="timeline-item" data-aos="fade-up" data-aos-delay="400">
                                <div class="timeline-left">
                                    <h4 class="company">YMCA Youth Parliament</h4>
                                    <span class="period">2024–2025</span>
                                </div>
                                <div class="timeline-dot"></div>
                                <div class="timeline-right">
                                    <h3 class="position">First Cohort Selected</h3>
                                    <p class="description">Students from our organisation selected for the Victorian Youth Parliament Program.</p>
                                </div>
                            </div>

                            <div class="timeline-item" data-aos="fade-up" data-aos-delay="450">
                                <div class="timeline-left">
                                    <h4 class="company">City of Kingston Hackathon</h4>
                                    <span class="period"></span>
                                </div>
                                <div class="timeline-dot"></div>
                                <div class="timeline-right">
                                    <h3 class="position">Hackathon Host</h3>
                                    <p class="description">Planned and delivered a STEM-focused youth hackathon in collaboration with the local council.</p>
                                </div>
                            </div>

                        </div><!-- /timeline -->
                    </div><!-- /resume-block -->
                </div>
            </div>
        </div>
    </div>

</section><!-- /Resume Section -->


    <!-- Portfolio Section -->
    <section id="portfolio" class="portfolio section">

        <!-- Section Title -->
        <div class="container section-title" data-aos="fade-up">
            <h2>Our programs</h2>
            <div class="title-shape">
                <svg viewBox="0 0 200 20" xmlns="http://www.w3.org/2000/svg">
                    <path d="M 0,10 C 40,0 60,20 100,10 C 140,0 160,20 200,10" fill="none" stroke="currentColor" stroke-width="2"></path>
                </svg>
            </div>
            <p>This is our volunteer programs</p>
        </div><!-- End Section Title -->

        <div class="container" data-aos="fade-up" data-aos-delay="100">

            <div class="isotope-layout" data-default-filter="*" data-layout="masonry" data-sort="original-order">

                <!-- <div class="portfolio-filters-container" data-aos="fade-up" data-aos-delay="200">
                    <ul class="portfolio-filters isotope-filters">
                        <li data-filter="*" class="filter-active">All Work</li>
                        <li data-filter=".filter-web">Web Design</li>
                        <li data-filter=".filter-graphics">Graphics</li>
                        <li data-filter=".filter-motion">Motion</li>
                        <li data-filter=".filter-brand">Branding</li>
                    </ul>
                </div> -->

                <div class="row g-4 isotope-container" data-aos="fade-up" data-aos-delay="300">
    <?php foreach ($programs as $program): ?>
        <div class="col-lg-6 col-md-6 portfolio-item isotope-item filter-web">
        <a href="<?= $this->Url->build([
                                        'controller' => 'Pages',
                                        'action' => 'programInfo',
                                        $program->id
                                    ]) ?>" class="portfolio-card-link">
                <div class="portfolio-card">
                    <div class="portfolio-image">
                        <?php if (!empty($program->programs_images)): ?>
                            <img src="/team118-app_fit3048/<?= h($program->programs_images[0]->image_name) ?>" alt="<?= h($program->name) ?>" width="100" height="100">
                            <?php endif; ?>
                        <div class="portfolio-overlay">
                            <!-- Overlay thingy might needed -->
                        </div>
                    </div>
                    <div class="portfolio-content">
                        <span class="category"><?= h($program->date) ?>  <?= h($program->time) ?></span>
                        <h3><?= h($program->name) ?></h3>
                    </div>
                </div>
            </a>
        </div>
    <?php endforeach; ?>
</div>


                <!-- End Portfolio Container -->

            </div>

        </div>

    </section><!-- /Portfolio Section -->

    <!-- Services Section -->
    <section id="services" class="services section">

        <!-- Section Title -->
        <div class="container section-title" data-aos="fade-up">
            <h2>Our Focus</h2>
            <div class="title-shape">
                <svg viewBox="0 0 200 20" xmlns="http://www.w3.org/2000/svg">
                    <path d="M 0,10 C 40,0 60,20 100,10 C 140,0 160,20 200,10" fill="none" stroke="currentColor" stroke-width="2"></path>
                </svg>
            </div>
            <!-- <p>This is what we focus</p> -->
        </div><!-- End Section Title -->

        <div class="container" data-aos="fade-up" data-aos-delay="100">

            <div class="row align-items-center">
                <div class="col-lg-4 mb-5 mb-lg-0">
                <h2 class="fw-bold mb-4 servies-title">Student Experience</h2>
                    <p class="mb-4">We provide enriching experiences for our students.</p>
                </div>
                <div class="col-lg-8">
                    <div class="row g-4">

                    <div class="col-md-6" data-aos="fade-up" data-aos-delay="200">
    <div class="service-item">
        <i class="bi bi-activity icon"></i>
        <h3>SCIENCE</h3>
        <p><?= strip_tags($this->ContentBlock->html('science-description')); ?></p>
    </div>
</div><!-- End Service Item -->

<div class="col-md-6" data-aos="fade-up" data-aos-delay="300">
    <div class="service-item">
        <i class="bi bi-easel icon"></i>
        <h3>TECHNOLOGY</h3>
        <p><?= strip_tags($this->ContentBlock->html('technology-description')); ?></p>
    </div>
</div><!-- End Service Item -->

<div class="col-md-6" data-aos="fade-up" data-aos-delay="400">
    <div class="service-item">
        <i class="bi bi-broadcast icon"></i>
        <h3>ENGINEERING</h3>
        <p><?= strip_tags($this->ContentBlock->html('engineering-description')); ?></p>
    </div>
</div><!-- End Service Item -->

<div class="col-md-6" data-aos="fade-up" data-aos-delay="500">
    <div class="service-item">
        <i class="bi bi-bounding-box-circles icon"></i>
        <h3>MATHEMATICS</h3>
        <p><?= strip_tags($this->ContentBlock->html('mathematics-description')); ?></p>
    </div>
</div><!-- End Service Item -->


                    </div>
                </div>
            </div>

        </div>

    </section><!-- /Services Section -->

  <!-- Faq Section -->
<section id="faq" class="faq section">

<!-- Section Title -->
<div class="container section-title" data-aos="fade-up">
    <h2>Frequently Asked Questions</h2>
    <div class="title-shape">
        <svg viewBox="0 0 200 20" xmlns="http://www.w3.org/2000/svg">
            <path d="M 0,10 C 40,0 60,20 100,10 C 140,0 160,20 200,10" fill="none" stroke="currentColor" stroke-width="2"></path>
        </svg>
    </div>
    <p>Here are some frequently asked questions.</p>
</div><!-- End Section Title -->

<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-10" data-aos="fade-up" data-aos-delay="100">

            <div class="faq-container">

                <?php foreach ($faqs as $faq): ?>
                    <div class="faq-item">
                        <h3><?= h($faq->question); ?></h3>
                        <div class="faq-content">
                            <p><?= h($faq->answer); ?></p>
                        </div>
                        <i class="faq-toggle bi bi-chevron-right"></i>
                    </div><!-- End Faq item-->
                <?php endforeach; ?>

            </div>

        </div><!-- End Faq Column -->
    </div>
</div>

</section><!-- /Faq Section -->

    <!-- Contact Section -->
    <section id="contact" class="contact section light-background">

        <div class="container" data-aos="fade-up" data-aos-delay="100">

            <div class="row g-5">
                <div class="col-lg-6">
                    <div class="content" data-aos="fade-up" data-aos-delay="200">
                        <div class="section-category mb-3">Contact</div>
                        <h2 class="display-5 mb-4">If you have further question please fill this form</h2>
                        <!-- <p class="lead mb-4">blah balh</p> -->

                        <div class="contact-info mt-5">
                            <div class="info-item d-flex mb-3">
                                <i class="bi bi-envelope-at me-3"></i>
                                <span><?= strip_tags($this->ContentBlock->html('email')); ?></span>
                            </div>

                            <div class="info-item d-flex mb-3">
                                <i class="bi bi-telephone me-3"></i>
                                <span><?= strip_tags($this->ContentBlock->html('Phone')); ?></span>
                            </div>

                            <div class="info-item d-flex mb-4">
                                <i class="bi bi-geo-alt me-3"></i>
                                <span><?= strip_tags($this->ContentBlock->html('address')); ?></span>
                            </div>

                            <a href="https://www.google.com/maps/search/<?= urlencode(strip_tags($this->ContentBlock->html('address'))); ?>" class="map-link d-inline-flex align-items-center" target="_blank" rel="noopener">
                                Open Map
                                <i class="bi bi-arrow-right ms-2"></i>
                            </a>
                        </div>
                    </div>
                </div>

                <div class="col-lg-6">
                    <div class="contact-form card" data-aos="fade-up" data-aos-delay="300">
                        <div class="card-body p-4 p-lg-5">

                            <?= $this->Form->create($enquiry) ?>
                            <div class="row gy-4">
                                <div class="col-12">
                                    <?= $this->Form->control('name', ['class' => 'form-control', 'placeholder' => 'Your Name', 'label' => false]) ?>
                                </div>
                                <div class="col-12">
                                    <?= $this->Form->control('email', ['type' => 'email', 'class' => 'form-control', 'placeholder' => 'Your Email', 'label' => false]) ?>
                                </div>
                                <div class="col-12">
                                    <?= $this->Form->control('subject', ['class' => 'form-control', 'placeholder' => 'Subject', 'label' => false]) ?>
                                </div>
                                <div class="col-12">
                                    <?= $this->Form->control('message', ['type' => 'textarea', 'class' => 'form-control', 'placeholder' => 'Message', 'label' => false]) ?>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <div class="g-recaptcha" data-sitekey="6Lc1kgArAAAAAH90xZl8S-zQYMya4H5ypHJBOrlR"></div>
                                        <div class="invalid-feedback" id="recaptchaError"></div>

                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="form-check d-flex align-items-center gap-2">
                                        <?= $this->Form->control('promotional_opt_in', [
                                            'type' => 'checkbox',
                                            'label' => false,
                                            'class' => 'form-check-input',
                                            'hiddenField' => false,
                                            'id' => 'promotional-opt-in',
                                            'style' => 'margin-top: 0.15rem;'
                                        ]) ?>
                                        <label class="form-check-label mb-0" for="promotional-opt-in" style="font-family: 'Roboto','Noto Sans','Questrial',sans-serif; font-size: 1rem;">
                                            I would like to receive promotional emails.
                                        </label>
                                    </div>
                                </div>
                                <div class="col-12 text-center mt-3">
                                    <?= $this->Form->button(__('Submit'), ['class' => 'btn btn-submit w-100']) ?>
                                </div>
                            </div>
                            <?= $this->Form->end() ?>


                        </div>
                    </div>
                </div>

            </div>

        </div>

    </section>
    <!-- /Contact Section -->

</main>

<?= $this->element('footer'); ?>

<!-- Scroll Top -->
<a href="#" id="scroll-top" class="scroll-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

<!-- Vendor JS Files -->
<script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="assets/vendor/php-email-form/validate.js"></script>
<script src="assets/vendor/aos/aos.js"></script>
<script src="assets/vendor/waypoints/noframework.waypoints.js"></script>
<script src="assets/vendor/glightbox/js/glightbox.min.js"></script>
<script src="assets/vendor/imagesloaded/imagesloaded.pkgd.min.js"></script>
<script src="assets/vendor/isotope-layout/isotope.pkgd.min.js"></script>
<script src="assets/vendor/swiper/swiper-bundle.min.js"></script>
<script src="https://www.google.com/recaptcha/api.js" async defer></script>

<!-- Main JS File -->
<script src="assets/js/main.js"></script>

</body>
</html>
