<?php
use Cake\Core\Configure;
use Cake\Http\Exception\NotFoundException;

$this->disableAutoLayout();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <?= $this->Html->charset() ?>
    <?= $this->Html->meta('viewport', 'width=device-width, initial-scale=1.0') ?>
    <link rel="icon" href="<?= $this->Url->image('favicon.ico') ?>" type="image/x-icon">

    <title><?= h($program->name) ?> | Program Info</title>

    <?= $this->Html->css([
        'https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;700&family=Poppins:wght@300;400;600;700;800&display=swap',
        'https://cdnjs.cloudflare.com/ajax/libs/normalize/8.0.1/normalize.min.css',
        'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css',
        'vendor/bootstrap/css/bootstrap.min.css',
        'vendor/bootstrap-icons/bootstrap-icons.css',
        'vendor/aos/aos.css',
        'vendor/glightbox/css/glightbox.min.css',
        'vendor/swiper/swiper-bundle.min.css'
    ], ['pathPrefix' => 'assets/']) ?>

    <?= $this->Html->css('main.css', ['pathPrefix' => 'assets/css/']) ?>
</head>

<style>
    :root {
        --orange: #E87533;
        --orange-light: #FFA563;
        --orange-dark: #D05F20;
        --blue: #3E88F2;
        --blue-light: #70A8FF;
        --green: #2EA876;
        --grey-light: #f5f5f5;
        --grey-lighter: #fafafa;
        --grey: #78716c;
        --grey-dark: #4B4945;
        --radius: 20px;
        --radius-sm: 12px;
        --spacing: 30px;
        --shadow: rgba(0,0,0,0.1);
        --shadow-hover: rgba(0,0,0,0.2);
        --transition: all 0.4s cubic-bezier(0.22, 1, 0.36, 1);
    }

    * { box-sizing: border-box; margin: 0; padding: 0; }

    body {
        font-family: "Inter", system-ui, sans-serif;
        background: var(--grey-lighter);
        color: #333;
        line-height: 1.6;
        overflow-x: hidden;
    }

    body::before {
        content: "";
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: radial-gradient(circle at 15% 25%, rgba(232, 117, 51, 0.06) 0%, transparent 50%),
        radial-gradient(circle at 85% 75%, rgba(62, 136, 242, 0.05) 0%, transparent 50%);
        z-index: -1;
    }

    .page-container {
        max-width: 1400px;
        margin: 0 auto;
        padding: var(--spacing);
    }

    .card {
        background: #fff;
        border-radius: var(--radius);
        box-shadow: 0 12px 40px var(--shadow);
        padding: calc(var(--spacing) * 2);
        margin-bottom: calc(var(--spacing) * 2.5);
    }

    .card-header {
        background: none;
        border-bottom: none;
        padding-bottom: 0;
    }

    .card-header h5 {
        font-family: "Poppins", sans-serif;
        font-size: 2rem;
        color: var(--orange);
        font-weight: 700;
    }

    .btn-primary {
        padding: 10px 25px;
        background: var(--orange);
        color: #fff;
        border: none;
        border-radius: var(--radius-sm);
        font-size: 1rem;
        font-weight: 600;
        text-decoration: none;
        transition: var(--transition);
        box-shadow: 0 4px 15px rgba(232, 117, 51, 0.3);
    }

    .btn-primary:hover {
        background: var(--orange-dark);
        transform: translateY(-5px);
        box-shadow: 0 6px 20px rgba(232, 117, 51, 0.4);
    }

    .btn-outline-secondary {
        padding: 10px 25px;
        background: var(--grey-light);
        color: var(--grey-dark);
        border: 1px solid var(--grey-light);
        border-radius: var(--radius-sm);
        font-size: 1rem;
        font-weight: 600;
        text-decoration: none;
        transition: var(--transition);
    }

    .btn-outline-secondary:hover {
        background: var(--grey);
        color: #fff;
        transform: translateY(-5px);
    }

    .image-slider-container {
        position: relative;
        width: 100%;
        height: 240px;
        overflow: hidden;
        border-top-left-radius: var(--radius);
        border-top-right-radius: var(--radius);
    }

    .image-slider {
        position: relative;
        width: 100%;
        height: 100%;
    }

    .image-slider img {
        width: 100%;
        height: 240px;
        object-fit: cover;
        opacity: 0;
        transition: opacity 0.5s ease;
        position: absolute;
    }

    .image-slider img.active {
        opacity: 1;
    }

    .image-slider .campaign-overlay {
        position: absolute;
        inset: 0;
        background: linear-gradient(to top, rgba(0,0,0,0.5) 0%, transparent 50%);
        opacity: 0.8;
        transition: opacity 0.4s ease;
    }

    .image-slider:hover .campaign-overlay {
        opacity: 0.6;
    }

    .slider-btn {
        position: absolute;
        top: 50%;
        transform: translateY(-50%);
        background: #fff;
        border: none;
        color: var(--orange);
        padding: 0.5rem 0.75rem;
        font-size: 1.5rem;
        cursor: pointer;
        z-index: 10;
        border-radius: var(--radius-sm);
        transition: var(--transition);
    }

    .slider-btn:hover {
        background: var(--orange-light);
        color: #fff;
        transform: translateY(-50%) scale(1.1);
    }

    .slider-btn.prev {
        left: 10px;
    }

    .slider-btn.next {
        right: 10px;
    }

    .program-header h1 {
        font-family: "Poppins", sans-serif;
        font-size: 2.5rem;
        font-weight: 800;
        color: var(--grey-dark);
        text-align: center;
        margin-bottom: calc(var(--spacing) * 1.5);
        position: relative;
    }

    .program-header h1::after {
        content: "";
        position: absolute;
        bottom: -12px;
        left: 50%;
        transform: translateX(-50%);
        width: 120px;
        height: 6px;
        background: linear-gradient(90deg, var(--orange-light), var(--blue));
        border-radius: 6px;
    }

    .program-header p {
        font-size: 1.2rem;
        color: var(--grey);
        text-align: center;
    }

    .info-section {
        font-size: 1.1rem;
        color: var(--grey-dark);
        margin-bottom: calc(var(--spacing) * 2);
        text-align: center;
    }

    .info-section ul,
    .info-section ol {
        text-align: left;
        margin-left: auto;
        margin-right: auto;
        line-height: 1.6;
        display: table;
    }

    .info-section li {
        text-align: left;
    }

    .info-section a {
        padding: 10px 25px;
        background: var(--orange);
        color: #fff;
        border: none;
        border-radius: var(--radius-sm);
        font-size: 1rem;
        font-weight: 600;
        text-decoration: none;
        transition: var(--transition);
        box-shadow: 0 4px 15px rgba(232, 117, 51, 0.3);
    }

    .info-section a:hover {
        background: var(--orange-dark);
        transform: translateY(-5px);
        box-shadow: 0 6px 20px rgba(232, 117, 51, 0.4);
    }

    .info-section table {
        width: 100%;
        border-collapse: collapse;
        margin: calc(var(--spacing) * 1.5) 0;
        font-size: 1.1rem;
    }

    .info-section th,
    .info-section td {
        padding: 0.75rem;
        border-bottom: 1px solid var(--grey-light);
        text-align: left;
        vertical-align: top;
    }

    .info-section thead {
        background-color: var(--grey-lighter);
    }

    .scroll-top {
        position: fixed;
        bottom: 40px;
        right: 40px;
        width: 60px;
        height: 60px;
        background: var(--orange);
        color: #fff;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 2rem;
        cursor: pointer;
        opacity: 0;
        transform: translateY(40px);
        transition: var(--transition);
        box-shadow: 0 8px 25px rgba(232, 117, 51, 0.3);
        z-index: 100;
    }

    .scroll-top.visible {
        opacity: 1;
        transform: translateY(0);
    }

    .scroll-top:hover {
        background: var(--orange-dark);
        transform: translateY(-8px);
        box-shadow: 0 10px 30px rgba(232, 117, 51, 0.4);
    }

    @media (max-width: 768px) {
        .page-container {
            padding: 15px;
        }

        .card {
            padding: 20px;
        }

        .program-header h1 {
            font-size: 1.8rem;
        }

        .program-header p {
            font-size: 1rem;
        }

        .image-slider-container {
            height: 180px;
        }

        .image-slider img {
            height: 180px;
        }

        .slider-btn {
            font-size: 1rem;
            padding: 0.3rem 0.5rem;
        }

        .info-section {
            font-size: 1rem;
        }

        .info-section table {
            font-size: 0.9rem;
        }

        .info-section a {
            font-size: 0.9rem;
            padding: 8px 20px;
        }

        .scroll-top {
            width: 50px;
            height: 50px;
            bottom: 20px;
            right: 20px;
            font-size: 1.5rem;
        }
    }
</style>

<body class="index-page">

<?= $this->element('header'); ?>

<main class="main section py-5">
    <div class="page-container">
        <div class="card shadow">

            <?php if (!empty($program->programs_images)): ?>
                <div class="image-slider-container">
                    <div class="image-slider">
                        <?php foreach ($program->programs_images as $index => $image): ?>
                            <img
                                src="/team118-app_fit3048/<?= h($image->image_name) ?>"
                                alt="<?= h($program->name) ?> Image <?= $index + 1 ?>"
                                class="<?= $index === 0 ? 'active' : '' ?>">
                        <?php endforeach; ?>
                        <div class="campaign-overlay"></div>
                    </div>

                    <?php if (count($program->programs_images) > 1): ?>
                        <button class="slider-btn prev">❮</button>
                        <button class="slider-btn next">❯</button>
                    <?php endif; ?>
                </div>
            <?php endif; ?>

            <!-- Program Header -->
            <div class="container py-5 program-header" data-aos="fade-up">
                <h1 class="text-center mb-4"><?= h($program->name) ?></h1>
                <p class="text-center text-muted mb-5"><?= $this->Date->formatDate($program->date) ?> -  <?= h($program->time) ?></p>

                <?php if (!empty($program->programs_sections)): ?>
                    <?php foreach ($program->programs_sections as $section): ?>
                        <div class="container py-5" data-aos="fade-up">
                            <h2 class="text-center mb-4"><?= h($section->title) ?></h2>
                            <div class="info-section">
                                <?= $section->body ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>

                <div class="text-center mb-5 info-section">
                    <a href="<?= $this->Url->build('/#contact', ['fullBase' => true]) ?>" class="btn btn-outline-secondary">
                        Send an Enquiry
                    </a>
                    <a href="<?= $this->Url->build('/student-register', ['fullBase' => true]) ?>" class="btn btn-primary">
                        Register Now
                    </a>
                </div>
            </div>
        </div>
    </div>
</main>

<!-- Scroll to Top -->
<a href="#" id="scroll-top" class="scroll-top d-flex align-items-center justify-content-center">
    <i class="bi bi-arrow-up-short"></i>
</a>

<!-- JavaScript Files -->
<?= $this->Html->script([
    'vendor/bootstrap/js/bootstrap.bundle.min',
    'vendor/php-email-form/validate',
    'vendor/aos/aos',
    'vendor/waypoints/noframework.waypoints',
    'vendor/glightbox/js/glightbox.min',
    'vendor/imagesloaded/imagesloaded.pkgd.min',
    'vendor/isotope-layout/isotope.pkgd.min',
    'vendor/swiper/swiper-bundle.min',
    'js/main'
], ['pathPrefix' => 'assets/']) ?>

<?= $this->element('footer'); ?>

<script>
    let currentIndex = 0;
    let slideInterval;

    function changeSlide(direction) {
        const slides = document.querySelectorAll('.image-slider img');
        const totalSlides = slides.length;

        currentIndex = (currentIndex + direction + totalSlides) % totalSlides;
        showSlide(currentIndex, slides);
    }

    function showSlide(index, slides) {
        slides.forEach((slide, i) => {
            slide.classList.toggle('active', i === index);
        });
        currentIndex = index;
    }

    function startAutoSlide() {
        slideInterval = setInterval(() => {
            changeSlide(1);
        }, 10000);
    }

    document.addEventListener('DOMContentLoaded', () => {
        const slides = document.querySelectorAll('.image-slider img');
        const prevBtn = document.querySelector('.slider-btn.prev');
        const nextBtn = document.querySelector('.slider-btn.next');

        // Init first slide
        showSlide(currentIndex, slides);
        startAutoSlide();

        // Add event listeners
        if (prevBtn && nextBtn) {
            prevBtn.addEventListener('click', () => {
                clearInterval(slideInterval);
                changeSlide(-1);
                startAutoSlide();
            });

            nextBtn.addEventListener('click', () => {
                clearInterval(slideInterval);
                changeSlide(1);
                startAutoSlide();
            });
        }

        // Scroll animations
        gsap.utils.toArray('.program-header, .info-section').forEach((el, i) => {
            gsap.from(el, {
                opacity: 0,
                y: 50,
                duration: 1,
                ease: 'power3.out',
                scrollTrigger: {
                    trigger: el,
                    start: 'top 85%',
                },
                delay: i * 0.1
            });
        });

        // Scroll to Top Button
        const scrollTopBtn = document.getElementById('scroll-top');
        window.addEventListener('scroll', () => {
            scrollTopBtn.classList.toggle('visible', window.scrollY > 500);
        });
        scrollTopBtn.addEventListener('click', () => window.scrollTo({ top: 0, behavior: 'smooth' }));
    });
</script>

</body>
</html>
