<?php
/**
 * @var \App\View\AppView $this
 * @var array $programs
 */
?>
<!DOCTYPE html>
<html>
<head>
    <?= $this->Html->charset() ?>
    <?= $this->Html->meta('viewport', 'width=device-width, initial-scale=1.0') ?>
    <title>Student Registration</title>
    <!-- Include Bootstrap CSS -->
    <?= $this->Html->css('vendor/bootstrap/css/bootstrap.min.css', ['pathPrefix' => 'assets/']) ?>
    <!-- Include Bootstrap Icons -->
    <?= $this->Html->css('vendor/bootstrap-icons/bootstrap-icons.css', ['pathPrefix' => 'assets/']) ?>
    <!-- Main CSS File -->
    <?= $this->Html->css('main.css', ['pathPrefix' => 'assets/css/']) ?>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <style>
        :root {
            --orange: #E87533;
            --blue: #3E88F2;
            --grey-light: #f5f5f5;
            --grey: #78716c;
            --radius: 20px;
            --shadow: rgba(0,0,0,0.1);
            --transition: all 0.4s cubic-bezier(0.22, 1, 0.36, 1);
        }

        body {
            font-family: "Inter", system-ui, sans-serif;
            background: var(--grey-light);
            color: #333;
            line-height: 1.6;
            position: relative;
        }

        body::before {
            content: "";
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: radial-gradient(circle at 15% 25%, rgba(232, 117, 51, 0.06) 0%, transparent 50%),
            radial-gradient(circle at 85% 75%, rgba(62, 136, 242, 0.05) 0%, transparent 50%);
            z-index: -1;
        }

        .container {
            padding: 2rem 1rem;
        }

        .card {
            border: none;
            border-radius: var(--radius);
            box-shadow: 0 12px 40px var(--shadow);
            background: #fff;
            position: relative;
            overflow: hidden;
        }

        .card::before {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 6px;
            background: linear-gradient(90deg, var(--orange), var(--blue));
        }

        .card-header {
            background: linear-gradient(90deg, var(--orange), var(--blue)) !important;
            border: none;
            border-radius: var(--radius) var(--radius) 0 0 !important;
            padding: 1.5rem;
        }

        .card-header h3 {
            color: #fff !important;
            font-weight: 700;
            margin: 0;
            font-size: 1.8rem;
            letter-spacing: 1px;
        }

        .card-body {
            padding: 2rem;
        }

        .form-label {
            font-weight: 600;
            color: var(--grey);
            font-size: 1rem;
        }

        .form-control {
            border-radius: 0.5rem;
            padding: 0.75rem 1rem;
            border: 1px solid #ccc;
            transition: var(--transition);
            font-size: 1rem;
        }

        .form-control:focus {
            border-color: var(--orange);
            box-shadow: 0 0 0 0.2rem rgba(232, 117, 50, 0.25);
            outline: none;
        }

        .btn-primary {
            background: linear-gradient(90deg, var(--orange), var(--blue));
            border: none;
            border-radius: 0.8rem;
            padding: 0.75rem 2rem;
            font-weight: 600;
            font-size: 1rem;
            transition: var(--transition);
            box-shadow: 0 4px 15px rgba(232, 117, 50, 0.25);
        }

        .btn-primary:hover,
        .btn-primary:focus {
            background: linear-gradient(90deg, var(--blue), var(--orange));
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(232, 117, 50, 0.35);
        }

        .btn-secondary {
            border-color: var(--grey);
            color: var(--grey);
            border-radius: 0.8rem;
            padding: 0.75rem 2rem;
            font-weight: 600;
            transition: var(--transition);
            background: transparent;
        }

        .btn-secondary:hover,
        .btn-secondary:focus {
            background: var(--grey-light);
            color: var(--orange);
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        }

        .student-form {
            background: #fafafa;
            border: 1px solid #eee;
            border-radius: 0.8rem;
            box-shadow: 0 4px 6px rgba(0,0,0,0.05);
        }

        .form-header {
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: space-between;
            font-size: 1.125rem;
            font-weight: 700;
            background-color: #f5f5f5;
            border-bottom: 1px solid #eee;
            padding: 0.75rem 1rem;
            border-top-left-radius: 0.8rem;
            border-top-right-radius: 0.8rem;
            transition: background-color 0.3s ease;
        }

        .form-header:hover {
            background-color: #ececec;
        }

        .icon-group {
            display: flex;
            gap: 0.625rem;
        }

        .icon-group i {
            font-size: 1.25rem;
            color: var(--orange);
            cursor: pointer;
            transition: color 0.3s ease, transform 0.3s ease;
        }

        .icon-group i:hover {
            color: var(--blue);
            transform: scale(1.1);
        }

        .arrow {
            color: var(--orange);
            font-size: 1.25rem;
            transition: transform 0.3s ease, color 0.3s ease;
            margin-right: 0.5rem;
        }

        .form-header:hover .arrow {
            color: var(--blue);
        }

        .form-content {
            padding: 1rem;
        }

        #programsTable {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
            font-size: 0.9rem;
            background: #fff;
            border-radius: 0.5rem;
            overflow: hidden;
            box-shadow: 0 4px 12px rgba(0,0,0,0.05);
        }

        #programsTable .program-row {
            cursor: pointer;
            transition: background-color 0.3s ease;
        }

        #programsTable .program-row:hover {
            background-color: var(--grey-light);
        }

        #programsTable .program-row.selected {
            background-color: var(--blue);
            color: #fff;
        }

        #programsTable .program-row.selected:hover {
            background-color: #2e6fd9;
        }

        #programsTable thead {
            background: linear-gradient(90deg, var(--orange), var(--blue));
            color: #fff;
        }

        #programsTable th {
            padding: 12px;
            text-align: left;
            font-weight: 600;
        }

        #programsTable td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #eee;
        }

        #programsTable-wrapper {
            max-height: 300px;
            overflow-y: auto;
            border: 1px solid #eee;
            border-radius: 0.5rem;
        }

        .is-valid {
            border-color: #198754;
            background-image: none;
        }

        .is-invalid {
            border-color: #dc3545;
            background-image: none;
        }

        .invalid-feedback {
            font-size: 0.85rem;
            color: #dc3545;
        }

        .text-danger {
            color: #dc3545 !important;
        }

        @media (max-width: 768px) {
            .container {
                padding: 1rem 0.5rem;
            }

            .card {
                margin: 0 0.5rem;
            }

            .card-header {
                padding: 1rem;
            }

            .card-header h3 {
                font-size: 1.5rem;
            }

            .card-body {
                padding: 1.5rem;
            }

            .form-label {
                font-size: 0.9rem;
            }

            .form-control {
                padding: 0.6rem 0.8rem;
                font-size: 0.9rem;
            }

            .btn-primary, .btn-secondary {
                padding: 0.6rem 1.5rem;
                font-size: 0.9rem;
                width: 100%;
                margin-bottom: 0.5rem;
            }

            .form-header {
                font-size: 1rem;
                padding: 0.5rem 0.75rem;
            }

            .icon-group i, .arrow {
                font-size: 1rem;
            }

            .form-content {
                padding: 0.75rem;
            }

            #programsTable {
                font-size: 0.8rem;
            }

            #programsTable th, #programsTable td {
                padding: 8px;
            }
        }
    </style>
</head>
<body class="index-page">

<section id="student-registration" class="py-5">
    <div class="container">
        <div class="card shadow">
            <div class="card-header">
                <h3 class="mb-0">Student Registration Form</h3>
            </div>
            <div class="card-body">
                <?= $this->Flash->render() ?>

                <?= $this->Form->create(null, [
                    'url' => ['controller' => 'Pages', 'action' => 'studentRegister'],
                    'id' => 'registration-form'
                ]) ?>

                <!-- Registrar Information -->
                <fieldset class="mb-4">
                    <legend class="h5">Registrar Information</legend>
                    <div class="mb-3">
                        <label class="form-label">Full Name <span class="text-danger">*</span></label>
                        <?= $this->Form->control('contact_name', [
                            'class' => 'form-control',
                            'placeholder' => 'Enter your full name',
                            'label' => false,
                            'required' => true,
                            'pattern' => '^[A-Za-z\s]+$',
                            'title' => 'Only letters and spaces are allowed',
                            'maxlength' => '100'
                        ]) ?>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Email <span class="text-danger">*</span></label>
                        <?= $this->Form->control('contact_email', [
                            'class' => 'form-control',
                            'placeholder' => 'Enter your email',
                            'label' => false,
                            'required' => true,
                            'type' => 'email',
                            'pattern' => '[^@ \t\r\n]+@[^@ \t\r\n]+\.[^@ \t\r\n]+',
                            'title' => 'Enter a valid email address',
                            'maxlength' => '80'
                        ]) ?>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Phone <span class="text-danger">*</span></label>
                        <?= $this->Form->control('contact_phone', [
                            'class' => 'form-control',
                            'placeholder' => 'Enter your phone number',
                            'label' => false,
                            'required' => true,
                            'pattern' => '^[0-9]{10}$',
                            'title' => 'Phone number must be exactly 10 digits',
                            'maxlength' => '100'
                        ]) ?>
                    </div>
                </fieldset>

                <!-- Student Details -->
                <fieldset class="mb-4">
                    <legend class="h5">Student Details</legend>
                    <div id="studentFormsContainer">
                        <!-- A student detail form is appended here by JavaScript -->
                    </div>
                </fieldset>

                <!-- reCAPTCHA moved here -->
                <div class="col-md-6">
                    <div class="form-group">
                        <div class="g-recaptcha" data-sitekey="6Lc1kgArAAAAAH90xZl8S-zQYMya4H5ypHJBOrlR"></div>
                        <div class="invalid-feedback" id="recaptchaError"></div>
                    </div>
                </div>

                <div class="text-end d-flex justify-content-between">
                    <?= $this->Html->link(__('Cancel'), ['action' => 'index'], ['class' => 'btn btn-secondary']) ?>
                    <?= $this->Form->button('Submit', ['class' => 'btn btn-primary']) ?>
                </div>
                <?= $this->Form->end() ?>
            </div>
        </div>
    </div>
</section>

<!-- Hidden Student Form Template -->
<div id="studentFormTemplate" style="display: none;">
    <div class="student-form mb-3">
        <div class="form-header" onclick="toggleForm(this)">
            <div class="d-flex align-items-center">
                <strong>
                    <span class="arrow">▼</span> Student Details
                </strong>
            </div>
            <div class="icon-group">
                <i class="bi bi-plus plus-icon" onclick="event.stopPropagation(); addStudentForm();"></i>
                <i class="bi bi-trash delete-icon" onclick="event.stopPropagation(); deleteStudentForm(this);"></i>
            </div>
        </div>
        <div class="form-content mt-3 px-3">
            <div class="mb-3">
                <label class="form-label">Full Name <span class="text-danger">*</span></label>
                <input type="text" name="name[]" class="form-control" placeholder="Enter full name"
                       required pattern="^[A-Za-z\s]+$" title="Only letters and spaces are allowed" maxlength="100">
            </div>
            <div class="row mb-3">
                <div class="col-md-6">
                    <label class="form-label">Year Level <span class="text-danger">*</span></label>
                    <input type="text" name="year[]" class="form-control" placeholder="Enter year level"
                           required pattern="^[7-9]$" title="Only a single digit from 7 to 9 is allowed" maxlength="1">
                </div>
                <div class="col-md-6">
                    <label class="form-label">School <span class="text-danger">*</span></label>
                    <input type="text" name="school[]" class="form-control" placeholder="Enter School"
                           required pattern="^[A-Za-z\s]+$" title="Only letters and spaces are allowed" maxlength="100">
                </div>
            </div>
                <div class="mb-3">
                    <label class="form-label">Programs <span class="text-danger">*</span></label>
                    <div id="programsTable-wrapper">
                        <table id="programsTable">
                            <thead>
                            <tr>
                                <th>Program</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php foreach ($programs as $program_id => $program_name): ?>
                                <tr data-program-id="<?= h($program_id) ?>" class="program-row">
                                    <td>
                                        <input type="checkbox" name="programs" value="<?= h($program_id) ?>" class="program-checkbox">
                                        <?= h($program_name) ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <!-- Hidden input for storing selected programs -->
                    <input type="hidden" name="programsData[]" class="programs-data">
                </div>
        </div>
    </div>
</div>

<!-- JavaScript -->
<script>
    const container = document.getElementById('studentFormsContainer');
    const template = document.getElementById('studentFormTemplate').firstElementChild;
    let studentIndex = 0;

    function addStudentForm() {
        const clone = template.cloneNode(true);
        clone.style.display = 'block';

        // Hide content of all other student forms
        document.querySelectorAll('.form-content').forEach(c => c.style.display = 'none');

        // Show the new form's content
        clone.querySelector('.form-content').style.display = 'block';

        // Create a unique hidden input for each student’s selected programs
        const hiddenInput = clone.querySelector('.programs-data');
        hiddenInput.name = `programsData[${studentIndex}][]`;

        container.appendChild(clone);

        studentIndex++;

        updateProgramsData(clone);
        applyRealTimeValidation(clone);
    }

    function deleteStudentForm(icon) {
        const studentForm = icon.closest('.student-form');
        const forms = document.querySelectorAll('#studentFormsContainer .student-form');
        if (forms.length === 1) {
            alert("At least one student detail must remain.");
            return;
        }
        studentForm.remove();
    }

    function toggleForm(header) {
        const content = header.nextElementSibling;
        const arrow = header.querySelector('.arrow');
        document.querySelectorAll('.form-content').forEach(c => {
            if (c !== content) c.style.display = 'none';
        });
        content.style.display = (content.style.display === 'block') ? 'none' : 'block';
        arrow.textContent = (content.style.display === 'block') ? '▲' : '▼';
    }

    window.onload = function () {
        addStudentForm();
    }

    function updateProgramsData(studentForm) {
        const checkboxes = studentForm.querySelectorAll('.program-checkbox');
        const hiddenField = studentForm.querySelector('.programs-data');

        checkboxes.forEach(checkbox => {
            checkbox.addEventListener('change', function () {
                const selectedPrograms = [];
                checkboxes.forEach(cbox => {
                    if (cbox.checked) {
                        selectedPrograms.push(parseInt(cbox.value, 10));
                    }
                });
                hiddenField.value = JSON.stringify(selectedPrograms);
            });
        });
    }

    // Real-time validation for registrar and student forms
    document.addEventListener('DOMContentLoaded', function () {
        const form = document.getElementById('registration-form');
        const fields = form.querySelectorAll('input');
        fields.forEach(field => attachValidation(field));
    });

    function attachValidation(field) {
        if (!field.nextElementSibling || !field.nextElementSibling.classList.contains('invalid-feedback')) {
            const feedback = document.createElement('div');
            feedback.className = 'invalid-feedback';
            feedback.style.display = 'none';
            field.parentNode.appendChild(feedback);
        }
        field.addEventListener('input', () => validateField(field));
    }

    function applyRealTimeValidation(container) {
        const fields = container.querySelectorAll('input');
        fields.forEach(field => attachValidation(field));
    }

    function validateField(field) {
        const pattern = field.getAttribute('pattern');
        const title = field.getAttribute('title');
        const feedback = field.parentNode.querySelector('.invalid-feedback');

        if ((field.required && field.value.trim() === '') ||
            (pattern && field.value.trim() !== '' && !(new RegExp(pattern)).test(field.value))) {
            field.classList.add('is-invalid');
            field.classList.remove('is-valid');
            if (feedback) {
                feedback.textContent = title || 'Invalid input';
                feedback.style.display = 'block';
            }
        } else {
            field.classList.remove('is-invalid');
            field.classList.add('is-valid');
            if (feedback) {
                feedback.textContent = '';
                feedback.style.display = 'none';
            }
        }
    }
</script>

<!-- Include Bootstrap JS -->
<?= $this->Html->script('vendor/bootstrap/js/bootstrap.bundle.min.js', ['pathPrefix' => 'assets/']) ?>
<script src="https://www.google.com/recaptcha/api.js" async defer></script>

</body>
</html>
