<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Volunteer $volunteer
 */
?>

<head>
    <?= $this->Html->charset() ?>
    <?= $this->Html->meta('viewport', 'width=device-width, initial-scale=1.0') ?>
    <title>Add Volunteer</title>
    <!-- Include Bootstrap CSS -->
    <?= $this->Html->css('vendor/bootstrap/css/bootstrap.min.css', ['pathPrefix' => 'assets/']) ?>
    <!-- Include Bootstrap Icons -->
    <?= $this->Html->css('vendor/bootstrap-icons/bootstrap-icons.css', ['pathPrefix' => 'assets/']) ?>
    <!-- Main CSS File -->
    <?= $this->Html->css('main.css', ['pathPrefix' => 'assets/css/']) ?>

    <style>
        :root {
            --orange: #E87533;
            --blue: #3E88F2;
            --grey-light: #f5f5f5;
            --grey: #78716c;
            --radius: 20px;
            --shadow: rgba(0,0,0,0.1);
            --transition: all 0.4s cubic-bezier(0.22, 1, 0.36, 1);
        }

        body {
            font-family: "Inter", system-ui, sans-serif;
            background: var(--grey-light);
            color: #333;
            line-height: 1.6;
            position: relative;
        }

        body::before {
            content: "";
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: radial-gradient(circle at 15% 25%, rgba(232, 117, 51, 0.06) 0%, transparent 50%),
            radial-gradient(circle at 85% 75%, rgba(62, 136, 242, 0.05) 0%, transparent 50%);
            z-index: -1;
        }

        .container-p-y {
            padding: 2rem 1rem;
        }

        .card {
            border: none;
            border-radius: var(--radius);
            box-shadow: 0 12px 40px var(--shadow);
            background: #fff;
            position: relative;
            overflow: hidden;
        }

        .card::before {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 6px;
            background: linear-gradient(90deg, var(--orange), var(--blue));
        }

        .card-header {
            background: linear-gradient(90deg, var(--orange), var(--blue)) !important;
            border: none;
            border-radius: var(--radius) var(--radius) 0 0;
            padding: 1.5rem;
        }

        .card-header h3 {
            color: #fff !important;
            font-weight: 700;
            margin: 0;
            font-size: 1.8rem;
        }

        .card-body {
            padding: 2rem;
        }

        .form-group {
            margin-bottom: 1.5rem;
        }

        .form-label {
            font-weight: 600;
            margin-bottom: 0.5rem;
            color: var(--grey);
            font-size: 1rem;
        }

        .form-control {
            border-radius: 0.5rem;
            padding: 0.75rem 1rem;
            border: 1px solid #ccc;
            transition: var(--transition);
            font-size: 1rem;
        }

        .form-control:focus {
            border-color: var(--orange);
            box-shadow: 0 0 0 0.2rem rgba(232, 117, 50, 0.25);
            outline: none;
        }

        .btn-primary {
            background: linear-gradient(90deg, var(--orange), var(--blue));
            border: none;
            border-radius: 0.8rem;
            padding: 0.75rem 2rem;
            font-weight: 600;
            font-size: 1rem;
            transition: var(--transition);
            box-shadow: 0 4px 15px rgba(232, 117, 50, 0.25);
        }

        .btn-primary:hover,
        .btn-primary:focus {
            background: linear-gradient(90deg, var(--blue), var(--orange));
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(232, 117, 50, 0.35);
        }

        .btn-outline-secondary {
            border-color: var(--grey);
            color: var(--grey);
            border-radius: 0.8rem;
            padding: 0.75rem 2rem;
            font-weight: 600;
            transition: var(--transition);
        }

        .btn-outline-secondary:hover {
            background: var(--grey-light);
            color: var(--orange);
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        }

        .is-valid {
            border-color: #198754;
            background-image: none;
        }

        .is-invalid {
            border-color: #dc3545;
            background-image: none;
        }

        .invalid-feedback {
            font-size: 0.85rem;
            color: #dc3545;
        }

        .alert-danger {
            border-radius: 0.5rem;
            background: #f8d7da;
            color: #721c24;
            padding: 1rem;
        }

        hr.my-4 {
            border-color: var(--grey-light);
            margin: 2rem 0;
        }

        @media (max-width: 768px) {
            .container-p-y {
                padding: 1rem 0.5rem;
            }

            .card {
                margin: 0 0.5rem;
            }

            .card-header {
                padding: 1rem;
            }

            .card-header h3 {
                font-size: 1.5rem;
            }

            .card-body {
                padding: 1.5rem;
            }

            .form-group {
                margin-bottom: 1rem;
            }

            .form-label {
                font-size: 0.9rem;
            }

            .form-control {
                padding: 0.6rem 0.8rem;
                font-size: 0.9rem;
            }

            .btn-primary, .btn-outline-secondary {
                padding: 0.6rem 1.5rem;
                font-size: 0.9rem;
                width: 100%;
                margin-bottom: 0.5rem;
            }

            .alert-danger {
                padding: 0.8rem;
                font-size: 0.9rem;
            }
        }
    </style>
</head>
<body class="index-page">

<div class="container-xxl flex-grow-1 container-p-y">
    <div class="row">
        <div class="col-12">
            <div class="card mb-4">
                <div class="card-header">
                    <h3 class="mb-0">Volunteer Registration Form</h3>
                </div>
                <div class="card-body">
                    <?= $this->Flash->render() ?>
                    <?php if ($volunteer->getErrors()): ?>
                        <div class="alert alert-danger">
                            <ul>
                                <?php foreach ($volunteer->getErrors() as $field => $errors): ?>
                                    <?php foreach ($errors as $error): ?>
                                        <li><?= h($error) ?></li>
                                    <?php endforeach; ?>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    <?php endif; ?>

                    <?= $this->Form->create(null, [
                        'url' => ['controller' => 'Pages', 'action' => 'volunteerRegister'],
                        'id' => 'registration-form', 'class' => 'row g-3'
                    ]) ?>

                    <!-- First Name -->
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="form-label">First Name</label>
                            <?= $this->Form->control('first_name', [
                                'required' => true,
                                'class' => 'form-control',
                                'placeholder' => 'Enter your first name',
                                'label' => false,
                                'pattern' => "^[A-Za-z\s'-]+$",
                                'title' => "Only letters, spaces, apostrophes and dashes are allowed",
                                'maxlength' => '100'
                            ]) ?>
                        </div>
                    </div>

                    <!-- Last Name -->
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="form-label">Last Name</label>
                            <?= $this->Form->control('last_name', [
                                'required' => true,
                                'class' => 'form-control',
                                'placeholder' => 'Enter your last name',
                                'label' => false,
                               'pattern' => "^[A-Za-z\s'-]+$",
                                'title' => "Only letters, spaces, apostrophes and dashes are allowed",
                                'maxlength' => '100'
                            ]) ?>
                        </div>
                    </div>

                    <!-- Email Address -->
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="form-label">Email Address</label>
                            <?= $this->Form->control('email', [
                                'required' => true,
                                'type' => 'email',
                                'class' => 'form-control',
                                'placeholder' => 'Enter email address',
                                'label' => false,
                                'pattern' => '[^@ \t\r\n]+@[^@ \t\r\n]+\.[^@ \t\r\n]+',
                                'title' => 'Enter a valid email address',
                                'maxlength' => '50'
                            ]) ?>
                        </div>
                    </div>

                    <!-- Phone Number -->
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="form-label">Phone Number</label>
                            <?= $this->Form->control('phone', [
                                'required' => true,
                                'type' => 'text',
                                'class' => 'form-control',
                                'placeholder' => 'Enter phone number',
                                'label' => false,
                                'pattern' => '^[0-9]{10}$',
                                'title' => 'Phone number must be exactly 10 digits'
                            ]) ?>
                        </div>
                    </div>


                  <!-- Postcode -->
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="form-label">Postcode</label>
                            <?= $this->Form->control('postcode', [
                                'required' => true,
                                'type' => 'text',
                                'class' => 'form-control',
                                'placeholder' => 'Enter postcode',
                                'label' => false,
                                'pattern' => '^[0-9]{4,}$',
                                'title' => 'Postcode must be at least 4 digits',
                                'maxlength' => '10'
                            ]) ?>
                        </div>
                    </div>
                    <!-- Occupation -->
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="form-label">Occupation</label>
                            <?= $this->Form->control('occupation', [
                                'required' => true,
                                'type' => 'text',
                                'class' => 'form-control',
                                'placeholder' => 'Enter occupation',
                                'label' => false,
                                'pattern' => "^[A-Za-z\s'-]+$",
                                'title' => "Only letters, spaces, apostrophes and dashes are allowed",
                                'maxlength' => '100'
                            ]) ?>
                        </div>
                    </div>

                    <div class="col-12 mt-3">
                        <div class="g-recaptcha" data-sitekey="6Lc1kgArAAAAAH90xZl8S-zQYMya4H5ypHJBOrlR"></div>
                        <div class="invalid-feedback" id="recaptchaError"></div>
                    </div>



                    <!-- Hidden Description -->
                    <?= $this->Form->control('description', [
                        'class' => 'form-control',
                        'label' => false,
                        'id' => 'description',
                        'type' => 'hidden'
                    ]) ?>

                    <!-- Submit Buttons -->
                    <div class="col-12">
                        <hr class="my-4">
                        <?= $this->Form->button(__('Submit'), ['class' => 'btn btn-primary me-2']) ?>
                        <?= $this->Html->link(__('Cancel'), '/', ['class' => 'btn btn-outline-secondary']) ?>


                    </div>

                    <?= $this->Form->end() ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Bootstrap JS -->
<?= $this->Html->script('vendor/bootstrap/js/bootstrap.bundle.min.js', ['pathPrefix' => 'assets/']) ?>

<!-- Real-time validation script -->
<?= $this->Html->scriptBlock("
document.addEventListener('DOMContentLoaded', function () {
    const form = document.getElementById('registration-form');
    const fields = form.querySelectorAll('input');

    fields.forEach(field => {
        // Add an invalid-feedback element if it doesn't exist
        if (!field.nextElementSibling || !field.nextElementSibling.classList.contains('invalid-feedback')) {
            const feedback = document.createElement('div');
            feedback.className = 'invalid-feedback';
            feedback.style.display = 'none';
            field.parentNode.appendChild(feedback);
        }

        field.addEventListener('input', () => validateField(field));
    });

    function validateField(field) {
        const pattern = field.getAttribute('pattern');
        const title = field.getAttribute('title');
        const feedback = field.parentNode.querySelector('.invalid-feedback');

        if (pattern && field.value !== '') {
            const regex = new RegExp(pattern);
            if (!regex.test(field.value)) {
                field.setCustomValidity(title);
                field.classList.add('is-invalid');
                field.classList.remove('is-valid');
                if (feedback) {
                    feedback.textContent = title;
                    feedback.style.display = 'block';
                }
            } else {
                field.setCustomValidity('');
                field.classList.remove('is-invalid');
                field.classList.add('is-valid');
                if (feedback) {
                    feedback.textContent = '';
                    feedback.style.display = 'none';
                }
            }
        } else {
            field.setCustomValidity('');
            field.classList.remove('is-invalid');
            field.classList.remove('is-valid');
            if (feedback) {
                feedback.textContent = '';
                feedback.style.display = 'none';
            }
        }
    }
});
") ?>
</body>

<script src="https://www.google.com/recaptcha/api.js" async defer></script>
