<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\ProgramStatus $programStatus
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Program Status'), ['action' => 'edit', $programStatus->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Program Status'), ['action' => 'delete', $programStatus->id], ['confirm' => __('Are you sure you want to delete # {0}?', $programStatus->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Program Statuses'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Program Status'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="programStatuses view content">
            <h3><?= h($programStatus->name) ?></h3>
            <table>
                <tr>
                    <th><?= __('Name') ?></th>
                    <td><?= h($programStatus->name) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($programStatus->id) ?></td>
                </tr>
            </table>
            <div class="related">
                <h4><?= __('Related Programs') ?></h4>
                <?php if (!empty($programStatus->programs)) : ?>
                <div class="table-responsive">
                    <table>
                        <tr>
                            <th><?= __('Id') ?></th>
                            <th><?= __('Name') ?></th>
                            <th><?= __('Date') ?></th>
                            <th><?= __('Time') ?></th>
                            <th><?= __('Program Status Id') ?></th>
                            <th class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($programStatus->programs as $program) : ?>
                        <tr>
                            <td><?= h($program->id) ?></td>
                            <td><?= h($program->name) ?></td>
                            <td><?= h($program->date) ?></td>
                            <td><?= h($program->time) ?></td>
                            <td><?= h($program->program_status_id) ?></td>
                            <td class="actions">
                                <?= $this->Html->link(__('View'), ['controller' => 'Programs', 'action' => 'view', $program->id]) ?>
                                <?= $this->Html->link(__('Edit'), ['controller' => 'Programs', 'action' => 'edit', $program->id]) ?>
                                <?= $this->Form->postLink(__('Delete'), ['controller' => 'Programs', 'action' => 'delete', $program->id], ['confirm' => __('Are you sure you want to delete # {0}?', $program->id)]) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>