<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Program $program
 * @var \Cake\Collection\CollectionInterface|string[] $programStatuses
 * @var \Cake\Collection\CollectionInterface|string[] $students
 * @var \Cake\Collection\CollectionInterface|string[] $volunteers
 */
?>
<style>
    .validation-message {
        margin-top: 5px;
        font-size: 0.9rem;
        color: #555;
    }
    .validation-message.error {
        color: red;
    }
</style>
<div class="content-wrapper">
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="row">
            <!-- Form Card -->
            <div class="col-12">
                <div class="card mb-4">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">Add Program</h5>
                        <?= $this->Html->link(
                            '<i class="bx bx-arrow-back me-1"></i> Back to Programs',
                            ['action' => 'index'],
                            ['class' => 'btn btn-secondary btn-sm', 'escape' => false]
                        ) ?>
                    </div>
                    <div class="card-body">
                        <?= $this->Form->create($program, ['class' => 'row g-3', 'type' => 'post', 'enctype' => 'multipart/form-data']) ?>

                        <!-- Program Name -->
                        <div class="col-md-12">
                            <div class="form-group mb-3">
                                <label class="form-label" for="name">Program Name <span class="text-danger">*</span></label>
                                <?= $this->Form->control('name', [
                                    'class' => 'form-control',
                                    'label' => false,
                                    'placeholder' => 'Enter program name',
                                    'id' => 'name',
                                    'required' => true,
                                    'maxlength' => 50
                                ]) ?>
                                <div id="name-counter" style="margin-top: 5px; font-size: 0.9rem; color: #555;">Characters: 0/255</div>
                            </div>
                        </div>

                        <!-- Program Date -->
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label class="form-label" for="date">Date <span class="text-danger">*</span></label>
                                <?= $this->Form->control('date', [
                                    'class' => 'form-control',
                                    'label' => false,
                                    'type' => 'date',
                                    'id' => 'date',
                                    'required' => true
                                ]) ?>
                                <div id="date-message" class="validation-message"></div>
                            </div>
                        </div>

                        <!-- Program Time -->
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label class="form-label" for="time">Time <span class="text-danger">*</span></label>
                                <?= $this->Form->control('time', [
                                    'class' => 'form-control',
                                    'label' => false,
                                    'type' => 'time',
                                    'id' => 'time',
                                    'step' => '60',
                                    'required' => true
                                ]) ?>
                                <div id="time-message" class="validation-message"></div>
                            </div>
                        </div>

                        <!-- Program Status -->
                        <div class="col-md-12">
                            <div class="form-group mb-3">
                                <label class="form-label" for="program-status-id">Program Status <span class="text-danger">*</span></label>
                                <?= $this->Form->control('program_status_id', [
                                    'options' => $programStatuses,
                                    'empty' => 'Select Program Status',
                                    'class' => 'form-control',
                                    'label' => false,
                                    'id' => 'program-status-id',
                                    'required' => true
                                ]) ?>
                                <div id="program-status-message" class="validation-message"></div>
                            </div>
                        </div>

                        <!-- Students Section -->
                        <div class="col-md-12">
                            <div class="form-group mb-3">
                                <label class="form-label">Students</label>
                                <div id="students-container">
                                    <div class="student-entry d-flex align-items-center"></div>
                                </div>
                                <button type="button" id="add-student" class="btn mt-2" style="background-color: #e87532; color: white;">+ Add Student</button>
                                <div id="students-message" class="validation-message"></div>
                            </div>
                        </div>

                        <!-- Volunteers Section -->
                        <div class="col-md-12">
                            <div class="form-group mb-3">
                                <label class="form-label">Volunteers</label>
                                <div id="volunteers-container">
                                    <div class="volunteer-entry d-flex align-items-center"></div>
                                </div>
                                <button type="button" id="add-volunteer" class="btn mt-2" style="background-color: #e87532; color: white;">+ Add Volunteer</button>
                                <div id="volunteers-message" class="validation-message"></div>
                            </div>
                        </div>

                        <!-- Program Images -->
                        <div class="col-md-12">
                            <div class="form-group mb-3">
                                <label class="form-label" for="image-files">Program Images</label>
                                <div class="custom-file-upload">
                                    <?= $this->Form->control('image_files[]', [
                                        'type' => 'file',
                                        'label' => false,
                                        'id' => 'image-files',
                                        'class' => 'form-control custom-file-input',
                                        'accept' => 'image/jpeg, image/png',
                                        'multiple' => true,
                                        'data-preview-container' => '#images-container',
                                        'hidden' => true
                                    ]) ?>
                                </div>
                                <div id="images-container" class="mt-3"></div>
                                <div id="error-message-container" style="color: red; display: none;"></div>
                                <button type="button" id="add-image" class="btn mt-2" style="background-color: #e87532; color: white;">+ Add Image</button>
                                <br>
                                <small>Supported formats: JPG, PNG (Max 5MB per file)</small>
                            </div>
                        </div>

                        <!-- Submit Buttons -->
                        <div class="col-12">
                            <hr class="my-4">
                            <?= $this->Form->button(__('Create Program'), [
                                'class' => 'btn btn-primary me-2'
                            ]) ?>
                            <?= $this->Html->link(
                                __('Cancel'),
                                ['action' => 'index'],
                                ['class' => 'btn btn-outline-secondary']
                            ) ?>
                        </div>
                        <?= $this->Form->end() ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Get references to form fields and feedback elements
        const nameInput = document.getElementById('name');
        const dateInput = document.getElementById('date');
        const timeInput = document.getElementById('time');
        const programStatusInput = document.getElementById('program-status-id');
        const studentsContainer = document.getElementById('students-container');
        const addStudentBtn = document.getElementById('add-student');
        const volunteersContainer = document.getElementById('volunteers-container');
        const addVolunteerBtn = document.getElementById('add-volunteer');
        const addImageButton = document.getElementById('add-image');
        const fileInput = document.getElementById('image-files');
        const imagesContainer = document.getElementById('images-container');
        const errorMessageContainer = document.getElementById('error-message-container');
        const nameCounter = document.getElementById('name-counter');
        const dateMessage = document.getElementById('date-message');
        const timeMessage = document.getElementById('time-message');
        const programStatusMessage = document.getElementById('program-status-message');
        const studentsMessage = document.getElementById('students-message');
        const volunteersMessage = document.getElementById('volunteers-message');
        const maxFileSize = 5 * 1024 * 1024; // 5MB limit
        let files = []; // Array to keep track of selected files
        let studentCounter = 0;
        let volunteerCounter = 0;
        let formSubmitted = false;

        // Validation functions
        function validateText(input, maxLength) {
            let sanitized = input.replace(/[^a-zA-Z0-9 .,\'"-]/g, '');
            if (sanitized.length > maxLength) {
                sanitized = sanitized.substring(0, maxLength);
            }
            return sanitized;
        }

        function validateDate(dateStr) {
            const selectedDate = new Date(dateStr);
            if (isNaN(selectedDate)) {
                return { valid: false, message: 'Please select a valid date' };
            }
            return { valid: true, message: '' };
        }

        function validateTime(timeStr) {
            if (!timeStr) {
                return { valid: false, message: 'Please select a valid time' };
            }
            return { valid: true, message: '' };
        }

        function validateProgramStatus(value) {
            if (!value) {
                return { valid: false, message: 'Please select a program status' };
            }
            return { valid: true, message: '' };
        }

        function validateStudents() {
            return { valid: true, message: '' };
        }

        function validateVolunteers() {
            return { valid: true, message: '' };
        }

        function validateImageFile() {
            errorMessageContainer.style.display = 'none';
            if (fileInput.files.length > 0) {
                const selectedFiles = Array.from(fileInput.files);
                const validFiles = [];
                selectedFiles.forEach(file => {
                    if (file.size > maxFileSize) {
                        errorMessageContainer.textContent = `File ${file.name} is too large. Max size is 5MB.`;
                        errorMessageContainer.style.display = 'block';
                    } else if (!['image/jpeg', 'image/png'].includes(file.type)) {
                        errorMessageContainer.textContent = `File ${file.name} is not a valid format. Only JPG and PNG are allowed.`;
                        errorMessageContainer.style.display = 'block';
                    } else {
                        validFiles.push(file);
                    }
                });
                return validFiles.length === selectedFiles.length;
            }
            return true;
        }

        // Update counter and feedback functions
        function updateNameCounter() {
            nameInput.value = validateText(nameInput.value, 50);
            const charCount = nameInput.value.length;
            nameCounter.textContent = `Characters: ${charCount}/50${charCount === 50 ? ' (Maximum reached)' : ''}`;
            nameCounter.style.color = charCount === 50 ? 'red' : '#555';
        }

        function updateDateFeedback() {
            const result = validateDate(dateInput.value);
            dateMessage.textContent = result.message;
            dateMessage.className = 'validation-message' + (formSubmitted && !result.valid ? ' error' : '');
            dateInput.setCustomValidity(result.valid ? '' : result.message);
        }

        function updateTimeFeedback() {
            const result = validateTime(timeInput.value);
            timeMessage.textContent = result.message;
            timeMessage.className = 'validation-message' + (formSubmitted && !result.valid ? ' error' : '');
            timeInput.setCustomValidity(result.valid ? '' : result.message);
        }

        function updateProgramStatusFeedback() {
            const result = validateProgramStatus(programStatusInput.value);
            programStatusMessage.textContent = result.message;
            programStatusMessage.className = 'validation-message' + (formSubmitted && !result.valid ? ' error' : '');
            programStatusInput.setCustomValidity(result.valid ? '' : result.message);
        }

        function updateStudentsFeedback() {
            const result = validateStudents();
            studentsMessage.textContent = result.message;
            studentsMessage.className = 'validation-message' + (formSubmitted && !result.valid ? ' error' : '');
        }

        function updateVolunteersFeedback() {
            const result = validateVolunteers();
            volunteersMessage.textContent = result.message;
            volunteersMessage.className = 'validation-message' + (formSubmitted && !result.valid ? ' error' : '');
        }

        // Function to update remove buttons visibility
        function updateRemoveButtons(container, type) {
            const entries = container.querySelectorAll(`.${type}-entry`);
            const removeButtons = container.querySelectorAll(`.remove-${type}`);
            removeButtons.forEach(btn => btn.style.display = entries.length > 1 ? 'inline-block' : 'none');
            if (type === 'student') updateStudentsFeedback();
            if (type === 'volunteer') updateVolunteersFeedback();
        }

        // Function to add a new student entry
        function addStudentEntry() {
            studentCounter++;
            const newEntry = document.createElement('div');
            newEntry.className = 'student-entry d-flex align-items-center mt-2';
            const selectWrapper = document.createElement('div');
            selectWrapper.className = 'input select';
            selectWrapper.style.flex = '1';

            const newSelect = document.createElement('select');
            newSelect.name = `students[_ids][${studentCounter}]`;
            newSelect.className = 'form-control student-select';

            const studentOptions = <?= json_encode($students) ?>;
            let emptyOption = document.createElement('option');
            emptyOption.value = '';
            emptyOption.text = '';
            newSelect.appendChild(emptyOption);
            for (let id in studentOptions) {
                let option = document.createElement('option');
                option.value = id;
                option.text = studentOptions[id];
                newSelect.appendChild(option);
            }

            selectWrapper.appendChild(newSelect);
            const removeBtn = document.createElement('button');
            removeBtn.type = 'button';
            removeBtn.className = 'btn btn-danger remove-student ms-2';
            removeBtn.textContent = 'Remove';
            removeBtn.addEventListener('click', function() {
                newEntry.remove();
                updateRemoveButtons(studentsContainer, 'student');
            });

            newEntry.appendChild(selectWrapper);
            newEntry.appendChild(removeBtn);
            studentsContainer.appendChild(newEntry);
            updateRemoveButtons(studentsContainer, 'student');
        }

        // Function to add a new volunteer entry
        function addVolunteerEntry() {
            volunteerCounter++;
            const newEntry = document.createElement('div');
            newEntry.className = 'volunteer-entry d-flex align-items-center mt-2';
            const selectWrapper = document.createElement('div');
            selectWrapper.className = 'input select';
            selectWrapper.style.flex = '1';

            const newSelect = document.createElement('select');
            newSelect.name = `volunteers[_ids][${volunteerCounter}]`;
            newSelect.className = 'form-control volunteer-select';

            const volunteerOptions = <?= json_encode($volunteers) ?>;
            let emptyOption = document.createElement('option');
            emptyOption.value = '';
            emptyOption.text = '';
            newSelect.appendChild(emptyOption);
            for (let id in volunteerOptions) {
                let option = document.createElement('option');
                option.value = id;
                option.text = volunteerOptions[id];
                newSelect.appendChild(option);
            }

            selectWrapper.appendChild(newSelect);
            const removeBtn = document.createElement('button');
            removeBtn.type = 'button';
            removeBtn.className = 'btn btn-danger remove-volunteer ms-2';
            removeBtn.textContent = 'Remove';
            removeBtn.addEventListener('click', function() {
                newEntry.remove();
                updateRemoveButtons(volunteersContainer, 'volunteer');
            });

            newEntry.appendChild(selectWrapper);
            newEntry.appendChild(removeBtn);
            volunteersContainer.appendChild(newEntry);
            updateRemoveButtons(volunteersContainer, 'volunteer');
        }

        // Image upload handling
        addImageButton.addEventListener('click', () => {
            fileInput.click();
        });

        fileInput.addEventListener('change', function(event) {
            if (event.target.files.length === 0) {
                imagesContainer.innerHTML = '';
                files = [];
                return;
            }

            const selectedFiles = Array.from(event.target.files);
            errorMessageContainer.style.display = 'none';
            const validFiles = [];

            selectedFiles.forEach(file => {
                if (file.size > maxFileSize) {
                    errorMessageContainer.textContent = `File ${file.name} is too large. Max size is 5MB.`;
                    errorMessageContainer.style.display = 'block';
                } else if (!['image/jpeg', 'image/png'].includes(file.type)) {
                    errorMessageContainer.textContent = `File ${file.name} is not a valid format. Only JPG and PNG are allowed.`;
                    errorMessageContainer.style.display = 'block';
                } else {
                    validFiles.push(file);
                }
            });

            if (validFiles.length > 0) {
                files = files.concat(validFiles);
                validFiles.forEach(file => {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        const previewContainer = document.createElement('div');
                        previewContainer.classList.add('preview-container');
                        const imagePreview = document.createElement('img');
                        imagePreview.src = e.target.result;
                        imagePreview.classList.add('img-thumbnail');
                        imagePreview.style.maxWidth = '100px';
                        previewContainer.appendChild(imagePreview);
                        const removeButton = document.createElement('button');
                        removeButton.textContent = 'Remove';
                        removeButton.classList.add('btn', 'btn-danger', 'mt-2');
                        previewContainer.appendChild(removeButton);
                        imagesContainer.appendChild(previewContainer);
                        removeButton.addEventListener('click', function() {
                            previewContainer.remove();
                            files.splice(files.indexOf(file), 1);
                            updateFileInput();
                        });
                    };
                    reader.readAsDataURL(file);
                });
                updateFileInput();
            } else {
                fileInput.value = '';
            }
        });

        function updateFileInput() {
            const dataTransfer = new DataTransfer();
            files.forEach(file => {
                dataTransfer.items.add(file);
            });
            fileInput.files = dataTransfer.files;
        }

        // Initialize validation on page load
        updateNameCounter();
        updateDateFeedback();
        updateTimeFeedback();
        updateProgramStatusFeedback();
        updateStudentsFeedback();
        updateVolunteersFeedback();

        // Attach event listeners for real-time updates
        nameInput.addEventListener('input', updateNameCounter);
        dateInput.addEventListener('input', updateDateFeedback);
        timeInput.addEventListener('input', updateTimeFeedback);
        programStatusInput.addEventListener('change', updateProgramStatusFeedback);
        addStudentBtn.addEventListener('click', addStudentEntry);
        addVolunteerBtn.addEventListener('click', addVolunteerEntry);
        studentsContainer.addEventListener('change', updateStudentsFeedback);
        volunteersContainer.addEventListener('change', updateVolunteersFeedback);

        // Prevent form submission if validation fails
        const form = document.querySelector('form');
        form.addEventListener('submit', function(e) {
            formSubmitted = true;
            updateDateFeedback();
            updateTimeFeedback();
            updateProgramStatusFeedback();
            updateStudentsFeedback();
            updateVolunteersFeedback();
            if (!validateImageFile() ||
                !validateDate(dateInput.value).valid ||
                !validateTime(timeInput.value).valid ||
                !validateProgramStatus(programStatusInput.value).valid) {
                e.preventDefault();
                dateInput.reportValidity();
                timeInput.reportValidity();
                programStatusInput.reportValidity();
            }
        });
    });
</script>
