<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Program $program
 * @var string[]|\Cake\Collection\CollectionInterface $programStatuses
 * @var string[]|\Cake\Collection\CollectionInterface $students
 * @var string[]|\Cake\Collection\CollectionInterface $volunteers
 */
?>
<div class="content-wrapper">
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="row">
            <!-- Form Card -->
            <div class="col-12">
                <div class="card mb-4">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">Edit Program</h5>
                        <div>
                            <?= $this->Html->link(
                                '<i class="bx bx-arrow-back me-1"></i> Back to Programs',
                                ['action' => 'index'],
                                ['class' => 'btn btn-secondary btn-sm', 'escape' => false]
                            ) ?>
                            <?= $this->Form->postLink(
                                '<i class="bx bx-trash me-1"></i> Delete Program',
                                ['action' => 'delete', $program->id],
                                [
                                    'confirm' => __('Are you sure you want to delete # {0}?', $program->id),
                                    'class' => 'btn btn-danger btn-sm ms-2',
                                    'escape' => false
                                ]
                            ) ?>
                        </div>
                    </div>
                    <div class="card-body">
                        <?= $this->Form->create($program, ['class' => 'row g-3', 'enctype' => 'multipart/form-data']) ?>

                        <!-- Program Name -->
                        <div class="col-md-12">
                            <div class="form-group mb-3">
                                <label class="form-label" for="name">Program Name *</label>
                                <?= $this->Form->control('name', [
                                    'class' => 'form-control',
                                    'label' => false,
                                    'placeholder' => 'Enter program name',
                                    'id' => 'name',
                                    'required' => true,
                                    'maxlength' => 50 // Enforce max length on client side
                                ]) ?>
                                <div id="name-counter" style="margin-top: 5px; font-size: 0.9rem; color: #555;">Characters: 0/50</div>
                            </div>
                        </div>

                        <!-- Program Date -->
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label class="form-label" for="date">Date</label>
                                <?= $this->Form->control('date', [
                                    'class' => 'form-control',
                                    'label' => false,
                                    'type' => 'date',
                                    'id' => 'date'
                                ]) ?>
                            </div>
                        </div>

                        <!-- Program Time -->
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label class="form-label" for="time">Time</label>
                                <?= $this->Form->control('time', [
                                    'class' => 'form-control',
                                    'label' => false,
                                    'type' => 'time',
                                    'id' => 'time',
                                    'step' => '60' // Ensures only hours and minutes are allowed
                                ]) ?>
                            </div>
                        </div>

                        <!-- Program Status -->
                        <div class="col-md-12">
                            <div class="form-group mb-3">
                                <label class="form-label" for="program-status-id">Program Status</label>
                                <?= $this->Form->control('program_status_id', [
                                    'options' => $programStatuses,
                                    'empty' => true,
                                    'class' => 'form-control',
                                    'label' => false,
                                    'id' => 'program-status-id'
                                ]) ?>
                            </div>
                        </div>

                        <!-- Students Section -->
                        <div class="col-md-12">
                            <div class="form-group mb-3">
                                <label class="form-label">Students</label>
                                <div id="students-container">
                                    <?php
                                    $studentIds = $program->students ? array_column($program->students, 'id') : [];
                                    foreach ($studentIds as $index => $studentId): ?>
                                        <div class="student-entry d-flex align-items-center">
                                            <?= $this->Form->control("students._ids.{$index}", [
                                                'options' => $students,
                                                'class' => 'form-control student-select',
                                                'label' => false,
                                                'value' => $studentId
                                            ]) ?>
                                            <button type="button" class="btn btn-danger remove-student ms-2" style="display:none;">Remove</button>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                                <button type="button" id="add-student" class="btn mt-2" style="background-color: #e87532; color: white;">+ Add Student</button>
                            </div>
                        </div>

                        <!-- Volunteers Section -->
                        <div class="col-md-12">
                            <div class="form-group mb-3">
                                <label class="form-label">Volunteers</label>
                                <div id="volunteers-container">
                                    <?php
                                    $volunteerIds = $program->volunteers ? array_column($program->volunteers, 'id') : [];
                                    foreach ($volunteerIds as $index => $volunteerId): ?>
                                        <div class="volunteer-entry d-flex align-items-center">
                                            <?= $this->Form->control("volunteers._ids.{$index}", [
                                                'options' => $volunteers,
                                                'class' => 'form-control volunteer-select',
                                                'label' => false,
                                                'value' => $volunteerId
                                            ]) ?>
                                            <button type="button" class="btn btn-danger remove-volunteer ms-2" style="display:none;">Remove</button>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                                <button type="button" id="add-volunteer" class="btn mt-2" style="background-color: #e87532; color: white;">+ Add Volunteer</button>
                            </div>
                        </div>

                        <!-- Related Images Section -->
                        <div class="col-md-12">
                            <div class="form-group mb-3">
                                <label class="form-label" for="image-files">Program Images</label>

                        <?php if (!empty($program->programs_images)): ?>
                            <!-- Existing Images (Separate List) -->
                            <div id="existing-images-container" class="mt-3">
                            <?php foreach ($program->programs_images as $image): ?>
                                <div class="preview-container" id="image-<?= $image->id ?>" style="margin-bottom: 10px;">
                                    <!-- Flexbox container for image and remove button -->
                                    <div style="display: flex; align-items: center;">
                                        <img src="<?= $this->Url->build('/' . $image->image_name, ['fullBase' => true]) ?>" class="img-thumbnail" style="max-width: 100px;">
                                        <button type="button" class="btn btn-danger remove-image mt-2" data-image-id="<?= $image->id ?>" style="margin-left: 10px;">Remove</button>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                                <?php endif; ?>
                                        <!-- Hidden container to store the image IDs to be removed -->
                                        <div id="remove-images-inputs" style="display: none;"></div> <!-- Hidden section for removed images -->

                                        </div>

                                        <!-- File Upload Section for New Images -->
                                        <div class="file-upload-placeholder"></div>
                                        <div class="custom-file-upload">
                                            <br>
                                            <?= $this->Form->control('image_files[]', [
                                                'type' => 'file',
                                                'label' => false,
                                                'id' => 'image-files',
                                                'class' => 'form-control custom-file-input',
                                                'accept' => 'image/jpeg, image/png',
                                                'multiple' => true,
                                                'data-preview-container' => '#images-container',
                                                'hidden' => true,
                                            ]) ?>
                                        </div>

                                        <!-- Preview Container for New Images -->
                                        <div id="images-container" class="mt-3">
                                            <!-- Dynamically added image previews will appear here -->
                                        </div>

                                        <div id="error-message-container" style="color: red; display: none;"></div>

                                        <button type="button" id="add-image" class="btn mt-2" style="background-color: #e87532; color: white;">+ Add Image</button>
                                        <br>
                                        <small>Supported formats: JPG, PNG (Max 5MB per file)</small>
                                    </div>




                            <!-- Submit Buttons -->
                            <div class="col-12 d-flex justify-content-between align-items-center">
                                <div>
                                    <br>
                                    <br>
                                    <?= $this->Form->button(__('Save Changes'), [
                                        'class' => 'btn btn-primary me-2'
                                    ]) ?>
                                    <?= $this->Html->link(__('Cancel'), [
                                        'action' => 'index'
                                    ], [
                                        'class' => 'btn btn-outline

-secondary'
                                    ]) ?>
                                </div>
                                <?= $this->Html->link('Edit Info Page', [
                                    'controller' => 'Programs',
                                    'action' => 'editSection',
                                    $program->id
                                ], [
                                    'class' => 'btn btn-outline-primary'
                                ]) ?>
                            </div>

                            <?= $this->Form->end() ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Existing code for students and volunteers
            const studentsContainer = document.getElementById('students-container');
            const addStudentBtn = document.getElementById('add-student');
            const volunteersContainer = document.getElementById('volunteers-container');
            const addVolunteerBtn = document.getElementById('add-volunteer');

            let studentCounter = studentsContainer.querySelectorAll('.student-entry').length;
            let volunteerCounter = volunteersContainer.querySelectorAll('.volunteer-entry').length;

            function updateRemoveButtons(container, type) {
                const entries = container.querySelectorAll(`.${type}-entry`);
                const removeButtons = container.querySelectorAll(`.remove-${type}`);
                removeButtons.forEach(btn => btn.style.display = entries.length > 1 ? 'inline-block' : 'none');
            }

            function addStudentEntry() {
                studentCounter++;
                const newEntry = document.createElement('div');
                newEntry.className = 'student-entry d-flex align-items-center mt-2';
                const selectWrapper = document.createElement('div');
                selectWrapper.className = 'input select';
                selectWrapper.style.flex = '1';

                const newSelect = document.createElement('select');
                newSelect.name = `students[_ids][${studentCounter}]`;
                newSelect.className = 'form-control student-select';

                const existingSelect = studentsContainer.querySelector('.student-select');
                if (existingSelect) {
                    newSelect.innerHTML = existingSelect.innerHTML;
                } else {
                    const studentOptions = <?= json_encode($students) ?>;
                    let emptyOption = document.createElement('option');
                    emptyOption.value = '';
                    emptyOption.text = '';
                    newSelect.appendChild(emptyOption);
                    for (let id in studentOptions) {
                        let option = document.createElement('option');
                        option.value = id;
                        option.text = studentOptions[id];
                        newSelect.appendChild(option);
                    }
                }

                selectWrapper.appendChild(newSelect);
                const removeBtn = document.createElement('button');
                removeBtn.type = 'button';
                removeBtn.className = 'btn btn-danger remove-student ms-2';
                removeBtn.textContent = 'Remove';
                removeBtn.addEventListener('click', function() {
                    newEntry.remove();
                    updateRemoveButtons(studentsContainer, 'student');
                });

                newEntry.appendChild(selectWrapper);
                newEntry.appendChild(removeBtn);
                studentsContainer.appendChild(newEntry);
                updateRemoveButtons(studentsContainer, 'student');
            }

            function addVolunteerEntry() {
                volunteerCounter++;
                const newEntry = document.createElement('div');
                newEntry.className = 'volunteer-entry d-flex align-items-center mt-2';
                const selectWrapper = document.createElement('div');
                selectWrapper.className = 'input select';
                selectWrapper.style.flex = '1';

                const newSelect = document.createElement('select');
                newSelect.name = `volunteers[_ids][${volunteerCounter}]`;
                newSelect.className = 'form-control volunteer-select';

                const existingSelect = volunteersContainer.querySelector('.volunteer-select');
                if (existingSelect) {
                    newSelect.innerHTML = existingSelect.innerHTML;
                } else {
                    const volunteerOptions = <?= json_encode($volunteers) ?>;
                    let emptyOption = document.createElement('option');
                    emptyOption.value = '';
                    emptyOption.text = '';
                    newSelect.appendChild(emptyOption);
                    for (let id in volunteerOptions) {
                        let option = document.createElement('option');
                        option.value = id;
                        option.text = volunteerOptions[id];
                        newSelect.appendChild(option);
                    }
                }

                selectWrapper.appendChild(newSelect);
                const removeBtn = document.createElement('button');
                removeBtn.type = 'button';
                removeBtn.className = 'btn btn-danger remove-volunteer ms-2';
                removeBtn.textContent = 'Remove';
                removeBtn.addEventListener('click', function() {
                    newEntry.remove();
                    updateRemoveButtons(volunteersContainer, 'volunteer');
                });

                newEntry.appendChild(selectWrapper);
                newEntry.appendChild(removeBtn);
                volunteersContainer.appendChild(newEntry);
                updateRemoveButtons(volunteersContainer, 'volunteer');
            }

            const existingStudentEntries = studentsContainer.querySelectorAll('.student-entry');
            existingStudentEntries.forEach(entry => {
                entry.classList.add('d-flex', 'align-items-center');
                const selectContainer = entry.querySelector('.student-select').parentNode;
                selectContainer.style.flex = '1';
            });

            const existingVolunteerEntries = volunteersContainer.querySelectorAll('.volunteer-entry');
            existingVolunteerEntries.forEach(entry => {
                entry.classList.add('d-flex', 'align-items-center');
                const selectContainer = entry.querySelector('.volunteer-select').parentNode;
                selectContainer.style.flex = '1';
            });

            addStudentBtn.addEventListener('click', addStudentEntry);
            addVolunteerBtn.addEventListener('click', addVolunteerEntry);

            const initialStudentRemoveBtns = studentsContainer.querySelectorAll('.remove-student');
            initialStudentRemoveBtns.forEach(btn => {
                btn.addEventListener('click', function() {
                    btn.closest('.student-entry').remove();
                    updateRemoveButtons(studentsContainer, 'student');
                });
            });

            const initialVolunteerRemoveBtns = volunteersContainer.querySelectorAll('.remove-volunteer');
            initialVolunteerRemoveBtns.forEach(btn => {
                btn.addEventListener('click', function() {
                    btn.closest('.volunteer-entry').remove();
                    updateRemoveButtons(volunteersContainer, 'volunteer');
                });
            });

            updateRemoveButtons(studentsContainer, 'student');
            updateRemoveButtons(volunteersContainer, 'volunteer');

            if (studentCounter === 0) {
                addStudentEntry();
            }
            if (volunteerCounter === 0) {
                addVolunteerEntry();
            }

            // Existing code for image handling
            const addImageButton = document.getElementById('add-image');
            const fileInput = document.getElementById('image-files');
            const imagesContainer = document.getElementById('images-container');
            const existingImagesContainer = document.getElementById('existing-images-container');
            const errorMessageContainer = document.getElementById('error-message-container');
            const maxFileSize = 5 * 1024 * 1024;
            let files = [];

            addImageButton.addEventListener('click', () => {
                fileInput.click();
            });

            fileInput.addEventListener('change', function(event) {
                if (event.target.files.length === 0) {
                    imagesContainer.innerHTML = '';
                    files = [];
                    return;
                }

                const selectedFiles = Array.from(event.target.files);
                errorMessageContainer.style.display = 'none';
                const validFiles = [];

                selectedFiles.forEach(file => {
                    if (file.size > maxFileSize) {
                        errorMessageContainer.textContent = `File ${file.name} is too large. Max size is 5MB.`;
                        errorMessageContainer.style.display = 'block';
                        return;
                    } else if (!['image/jpeg', 'image/png'].includes(file.type)) {
                        errorMessageContainer.textContent = `File ${file.name} is not a valid format. Only JPG and PNG are allowed.`;
                        errorMessageContainer.style.display = 'block';
                        return;
                    } else {
                        validFiles.push(file);
                    }
                });

                if (validFiles.length > 0) {
                    files = files.concat(validFiles);
                    validFiles.forEach(file => {
                        const reader = new FileReader();
                        reader.onload = function(e) {
                            const previewContainer = document.createElement('div');
                            previewContainer.classList.add('preview-container');
                            previewContainer.style.marginBottom = '10px';

                            const imagePreview = document.createElement('img');
                            imagePreview.src = e.target.result;
                            imagePreview.classList.add('img-thumbnail');
                            imagePreview.style.maxWidth = '100px';
                            imagePreview.style.display = 'inline-block';
                            previewContainer.appendChild(imagePreview);

                            const removeButton = document.createElement('button');
                            removeButton.textContent = 'Remove';
                            removeButton.classList.add('btn', 'btn-danger', 'mt-2');
                            removeButton.style.display = 'inline-block';
                            removeButton.style.marginLeft = '10px';
                            previewContainer.appendChild(removeButton);

                            imagesContainer.appendChild(previewContainer);
                            removeButton.addEventListener('click', function() {
                                previewContainer.remove();
                                files.splice(files.indexOf(file), 1);
                                updateFileInput();
                            });
                        };
                        reader.readAsDataURL(file);
                    });
                    updateFileInput();
                } else {
                    fileInput.value = '';
                }
            });

            function updateFileInput() {
                const dataTransfer = new DataTransfer();
                files.forEach(file => {
                    dataTransfer.items.add(file);
                });
                fileInput.files = dataTransfer.files;
            }

            const removeButtons = document.querySelectorAll('.remove-image');
            removeButtons.forEach(button => {
                button.addEventListener('click', function() {
                    const imageId = button.getAttribute('data-image-id');
                    if (!imageId) return;

                    const removeImagesContainer = document.getElementById('remove-images-inputs');
                    const hiddenInput = document.createElement('input');
                    hiddenInput.type = 'hidden';
                    hiddenInput.name = 'remove_images[]';
                    hiddenInput.value = imageId;
                    removeImagesContainer.appendChild(hiddenInput);

                    button.closest('.preview-container').remove();
                });
            });

            // New code for program name validation
            const nameInput = document.getElementById('name');
            const nameCounter = document.getElementById('name-counter');

            function validateAndTrim(input, maxLength) {
                // Remove disallowed characters (same as certificate custom text)
                let sanitized = input.replace(/[^a-zA-Z0-9 .,\'"-]/g, '');
                if (sanitized.length > maxLength) {
                    sanitized = sanitized.substring(0, maxLength);
                }
                return sanitized;
            }

            function updateNameCounter() {
                nameInput.value = validateAndTrim(nameInput.value, 50);
                const charCount = nameInput.value.length;
                nameCounter.textContent = `Characters: ${charCount}/50${charCount === 50 ? ' (Maximum reached)' : ''}`;
                nameCounter.style.color = charCount === 50 ? 'red' : '#555';
            }

            updateNameCounter();
            nameInput.addEventListener('input', updateNameCounter);

            // Existing form submission logging
            document.querySelector('form').addEventListener('submit', function(event) {
                const form = event.target;
                console.log('Form data before submission:', new FormData(form));
            });
        });
    </script>
