<?php
/**
 * @var \App\View\AppView $this
 */
?>

<!-- ✅ Toast UI Editor CSS/JS -->
<link rel="stylesheet" href="https://uicdn.toast.com/editor/latest/toastui-editor.min.css">
<script src="https://uicdn.toast.com/editor/latest/toastui-editor-all.min.js"></script>

<div class="container-xxl flex-grow-1 container-p-y">
    <div class="row">
        <div class="col-xl-12">
            <div class="card mb-4">
                <?= $this->Form->create(null, ['id' => 'program-form', 'novalidate']) ?>

                <div class="table-responsive">
                    <table class="table table-striped borderless mb-0">
                        <thead>
                            <tr>
                            <th>
                                <div class="d-flex justify-content-between align-items-start p-3">
                                    <div>
                                        <h4 class="mb-1" style="text-transform: none;"><?= h($program->name) ?></h4>
                                        <h6 class="mb-0" style="text-transform: none;"><?= $this->Date->formatDate($program->date) ?></h6>
                                    </div>
                                    <div>
                                        <?= $this->Html->link(
                                            '← Back to Program',
                                            ['controller' => 'Programs', 'action' => 'edit', $program->id],
                                            ['class' => 'btn btn-outline-secondary',
                                            'style' => 'text-transform: none;']
                                        ) ?>
                                    </div>
                                </div>
                            </th>
                            </tr>
                        </thead>
                        <tbody id="sections-table">
                            <?php foreach ($program->programs_sections as $index => $section): ?>
                                <tr id="section-<?= $index ?>">
                                    <td class="section-cell">
                                        <div class="mb-2 d-flex justify-content-between">
                                            <div class="w-75">
                                                <br>
                                                <label for="section-title-<?= $index ?>" class="form-label">
                                                    Section Title <span class="text-danger">*</span>
                                                </label>
                                                <input type="text"
                                                       name="sections[<?= $index ?>][title]"
                                                       class="form-control section-title"
                                                       id="section-title-<?= $index ?>"
                                                       value="<?= h($section->title) ?>"
                                                       placeholder="Enter section title"
                                                       maxlength="100"
                                                       required>
                                                <div class="invalid-feedback">Section title is required.</div>
                                            </div>
                                            <button type="button" class="btn btn-danger btn-sm remove-section"
                                                    id="remove-section-<?= $index ?>"
                                                    onclick="removeSection(<?= $index ?>)">Remove</button>
                                        </div>

                                        <input type="hidden" name="sections[<?= $index ?>][content]" id="editor-content-<?= $index ?>">
                                        <div id="toast-editor-<?= $index ?>" class="toast-editor" style="min-height: 300px;"></div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>

                <!-- ✅ Add Section Button -->
                    <div class="text-center my-3">
                        <button type="button" id="add-section" class="btn btn-primary">
                            + Add Section
                        </button>
                    </div>

                    <!-- ✅ Back and Save Buttons -->
                    <div class="p-3 d-flex justify-content-between">
                        <?= $this->Html->link(
                            '← Back to Program',
                            ['controller' => 'Programs', 'action' => 'edit', $program->id],
                            ['class' => 'btn btn-outline-secondary']
                        ) ?>

                        <?= $this->Form->button('Save All Sections', ['class' => 'btn btn-dark-green']) ?>
                    </div>


                <?= $this->Form->end() ?>
            </div>
        </div>
    </div>
</div>

<style>
    .section-cell {
        padding: 15px 20px;
    }

    .toast-editor {
        border: 1px solid #ccc;
        border-radius: 4px;
        margin-top: 10px;
    }

    .remove-section {
        height: 38px;
        padding: 0.5rem;
    }

    .toast-editor.border-danger {
        border: 2px solid #dc3545 !important;
    }

    .btn-dark-green {
        background-color:rgb(22, 154, 52);
        color: #fff;
        border: none;
    }

    .btn-dark-green:hover {
        background-color:rgb(24, 115, 45);
        color: #fff;
    }
</style>

<script>
document.addEventListener('DOMContentLoaded', function () {
    let editorCount = <?= count($program->programs_sections) ?>;
    const editorInstances = [];

    // ✅ Initialize existing editors
    <?php foreach ($program->programs_sections as $index => $section): ?>
        const editor<?= $index ?> = new toastui.Editor({
            el: document.querySelector('#toast-editor-<?= $index ?>'),
            height: '300px',
            initialEditType: 'wysiwyg',
            previewStyle: 'vertical',
            toolbarItems: [
                ['heading', 'bold', 'italic', 'strike'],
                ['hr', 'table'],     
                ['ul'],
                ['link'],
                ['indent', 'outdent']
            ],
            initialValue: <?= json_encode($section->body) ?>
        });
        editorInstances.push(editor<?= $index ?>);
    <?php endforeach; ?>

    function toggleRemoveButtons() {
        const removeButtons = document.querySelectorAll('.remove-section');
        const rows = document.querySelectorAll('#sections-table tr');
        removeButtons.forEach(btn => {
            btn.style.visibility = rows.length > 1 ? 'visible' : 'hidden';
        });
    }

    document.getElementById('add-section').addEventListener('click', function () {
        const tableBody = document.getElementById('sections-table');
        const row = document.createElement('tr');
        row.id = `section-${editorCount}`;

        const cell = document.createElement('td');
        const editorId = `toast-editor-${editorCount}`;
        const contentId = `editor-content-${editorCount}`;
        const titleId = `section-title-${editorCount}`;
        const removeButtonId = `remove-section-${editorCount}`;

        cell.innerHTML = `
            <div class="mb-2 d-flex justify-content-between">
                <div class="w-75">
                    <br>
                    <label for="${titleId}" class="form-label">Section Title <span class="text-danger">*</span></label>
                    <input type="text" name="sections[${editorCount}][title]" 
                        class="form-control section-title" 
                        id="${titleId}" 
                        placeholder="Enter section title" 
                        maxlength="100"
                        required>
                    <div class="invalid-feedback">Section title is required.</div>
                </div>
                <br>
                <button type="button" class="btn btn-danger btn-sm remove-section" 
                        id="${removeButtonId}" 
                        onclick="removeSection(${editorCount})">Remove</button>
            </div>
            <input type="hidden" name="sections[${editorCount}][content]" id="${contentId}">
            <div id="${editorId}" class="toast-editor" style="min-height: 300px;"></div>
        `;

        row.appendChild(cell);
        tableBody.appendChild(row);

        const newEditor = new toastui.Editor({
            el: document.querySelector(`#${editorId}`),
            height: '300px',
            initialEditType: 'wysiwyg',
            previewStyle: 'vertical',
            toolbarItems: [
                ['heading', 'bold', 'italic', 'strike'],
                ['hr', 'table'],     
                ['ul'],
                ['link'],
                ['indent', 'outdent']
            ]
        });

        editorInstances.push(newEditor);
        editorCount++;
        toggleRemoveButtons();
    });

    window.removeSection = function (index) {
        const row = document.getElementById(`section-${index}`);
        if (row) {
            row.remove();
            editorInstances[index] = null;
            toggleRemoveButtons();
        }
    };

    toggleRemoveButtons();

    // ✅ Form submission validation
    document.getElementById('program-form').addEventListener('submit', function (e) {
        let isValid = true;

        // Section title validation
        document.querySelectorAll('.section-title').forEach((input) => {
            if (!input.value.trim()) {
                input.classList.add('is-invalid');
                isValid = false;
            } else {
                input.classList.remove('is-invalid');
            }
        });

        // Editor body validation
        editorInstances.forEach((editor, i) => {
            if (editor) {
                const content = editor.getHTML().trim();
                const input = document.getElementById(`editor-content-${i}`);
                if (input) {
                    input.value = content;
                }

                const editorEl = document.querySelector(`#toast-editor-${i}`);
                if (!content || content === '<p><br></p>') {
                    editorEl.classList.add('border-danger');
                    isValid = false;
                } else {
                    editorEl.classList.remove('border-danger');
                }
            }
        });

        if (!isValid) {
            e.preventDefault();
            window.scrollTo({ top: 0, behavior: 'smooth' });
        }
    });
});
</script>
