<div class="container">
    <div class="header-container">
        <h3 class="program-header">Program Title: <?= h($program->name) ?></h3>
<!--        <button class="download-btn">Download <i class="bx bx-download me-1"></i></button>-->
        <?= $this->Html->link(
            'Download <i class="bx bx-download me-1"></i>',
            ['action' => 'downloadPdf', $program->id],
            ['class' => 'download-btn', 'escape' => false]
        ) ?>
    </div>

    <table class="info-table">
        <tr>
            <th>Name</th>
            <td><?= h($program->name) ?></td>
        </tr>
        <tr>
            <th>Program Status</th>
            <td><?= $program->hasValue('program_status') ? $this->Html->link($program->program_status->name, ['controller' => 'ProgramStatuses', 'action' => 'view', $program->program_status->id]) : '' ?></td>
        </tr>
        <tr>
            <th>ID</th>
            <td><?= $this->Number->format($program->id) ?></td>
        </tr>
        <tr>
            <th>Date</th>
            <td><?= h($program->date) ?></td>
        </tr>
        <tr>
            <th>Time</th>
            <td><?= h($program->time) ?></td>
        </tr>
    </table>

    <!-- Related Students -->
    <div class="related-section">
        <h4>Related Students</h4>
        <?php if (!empty($program->students)) : ?>
            <div class="responsive-table">
                <table class="data-table">
                    <thead>
                    <tr>
                        <!--                        <th>ID</th>-->
                        <th>Name</th>
                        <th>Year Level</th>
                        <th>School</th>

                        <th>Phone</th>
                        <th>Actions</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($program->students as $student) : ?>
                        <tr>
                            <!--                            <td>--><?php //= h($student->id) ?><!--</td>-->
                            <td><?= h($student->name) ?></td>

                            <td><?= h($student->year_level) ?></td>
                            <td><?= h($student->school) ?></td>
                            <td>
                                <a href="tel:<?= h($student->contact_phone) ?>", style="text-decoration: underline;">
                                    <?= h($student->contact_phone) ?>
                                </a>
                            </td>
                            <td class="actions">
                                <?= $this->Html->link('View', ['controller' => 'Students', 'action' => 'view', $student->id]) ?>
<!--                                --><?php //= $this->Html->link('Edit', ['controller' => 'Students', 'action' => 'edit', $student->id]) ?>
                                <?= $this->Form->postLink('Delete', ['controller' => 'Students', 'action' => 'delete', $student->id], ['confirm' => __('Are you sure you want to delete # {0}?', $student->id)]) ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>

    <!-- Related Volunteers -->
    <div class="related-section">
        <h4>Related Volunteers</h4>
        <?php if (!empty($program->volunteers)) : ?>
            <div class="responsive-table">
                <table class="data-table">
                    <thead>
                    <tr>
                        <th>Name</th>
<!--                        <th>Last Name</th>-->
                        <th>Email</th>
                        <th>Phone</th>
                        <th>Postcode</th>
                        <th>Occupation</th>
<!--                        <th>Description</th>-->
<!--                        <th>Status ID</th>-->
                        <th>Actions</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($program->volunteers as $volunteer) : ?>
                        <tr>
                            <td><?= h($volunteer->first_name . ' ' . $volunteer->last_name) ?></td>

                            <td>
                                <a href="mailto:<?= h($volunteer->email) ?>", style="text-decoration: underline;">
                                    <?= h($volunteer->email) ?>
                                </a>
                            </td>
                            <td>
                                <a href="tel:<?= h($volunteer->phone) ?>", style="text-decoration: underline;">
                                    <?= h($volunteer->phone) ?>
                                </a>
                            </td>
                            <td><?= h($volunteer->postcode) ?></td>
                            <td><?= h($volunteer->occupation) ?></td>
                            <td class="actions">
                                <?= $this->Html->link('View', ['controller' => 'Volunteers', 'action' => 'view', $volunteer->id]) ?>


                                <?= $this->Form->postLink('Remove',
                                    [
                                        'controller' => 'Programs',
                                        'action' => 'remove',
                                        $program->id,  // Pass the programId
                                        $volunteer->id  // Pass the volunteerId
                                    ],
                                    [
                                        'confirm' => __('Are you sure you want to remove this volunteer from the program?')
                                    ])
                                ?>

                            </td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>

    <!-- Related Images -->
    <div class="related-section">
        <h4>Related Programs Images</h4>
        <?php if (!empty($program->programs_images)) : ?>
            <div class="responsive-table">
                <table class="data-table">
                    <thead>
                    <tr>
                        <th>Image</th>
                        <th>Actions</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($program->programs_images as $programsImage) : ?>
                        <tr>
                            <td>
                                <img
                                    src="<?= $this->Url->build('/' . $programsImage->image_name, ['fullBase' => true]) ?>"
                                    alt="Program Image"
                                    width="100" height="100">
                            </td>
                            <td class="actions">
<!--                                --><?php //= $this->Html->link('Edit', ['controller' => 'ProgramsImages', 'action' => 'edit', $programsImage->id]) ?>
                                <?= $this->Form->postLink('Delete', ['controller' => 'Programs', 'action' => 'deleteimg', $programsImage->id], ['confirm' => __('Are you sure you want to delete # {0}?', $programsImage->id)]) ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>

<style>
    * {
        box-sizing: border-box;
        font-family: Arial, sans-serif;
    }

    .container {
        max-width: 1200px;
        margin: 0 auto;
        padding: 20px;
    }

    .header-container {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 20px;
    }

    .program-header {
        color: #333;
        margin: 0;
    }

    .download-btn {
        background-color: #e87532;
        color: white;
        padding: 8px 16px;
        border: none;
        border-radius: 20px;
        cursor: pointer;
        font-size: 14px;
        transition: background-color 0.3s;
    }

    .download-btn:hover {
        background-color: #9f3e02;
    }

    .info-table {
        width: 100%;
        border-collapse: collapse;
        margin-bottom: 30px;
        background: #fff;
        box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
    }

    .info-table th,
    .info-table td {
        padding: 15px;
        text-align: left;
        border-bottom: 1px solid #eee;
    }

    .info-table th {
        background: #f5f5f5;
        width: 30%;
    }

    .related-section {
        margin: 30px 0;
    }

    .related-section h4 {
        color: #2c3e50;
        margin-bottom: 15px;
        border-bottom: 2px solid #e87532;
        padding-bottom: 5px;
    }

    .responsive-table {
        overflow-x: auto;
        margin-bottom: 20px;
    }

    .data-table {
        width: 100%;
        border-collapse: collapse;
        background: #fff;
        box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
    }

    .data-table th,
    .data-table td {
        padding: 12px;
        border-bottom: 1px solid #eee;
    }

    .data-table th {
        background: #e87532;
        color: white;
        white-space: nowrap;
    }

    .actions a {
        text-decoration: none;
        padding: 5px 10px;
        margin: 0 2px;
        border-radius: 3px;
        color: #fff;
        display: inline-block;
    }

    .actions a:first-child {
        background: #2ecc71;
    }

    .actions a:nth-child(2) {
        background: #e67e22;
    }

    .actions a:last-child {
        background: #e74c3c;
    }

    @media (max-width: 768px) {
        .header-container {
            flex-direction: column;
            align-items: flex-start;
            gap: 10px;
        }

        .download-btn {
            width: 100%;
        }

        .info-table th,
        .info-table td {
            display: block;
            width: 100%;
        }

        .info-table th {
            background: #f0f0f0;
        }

        .data-table {
            display: block;
            overflow-x: auto;
            white-space: nowrap;
        }

        .actions {
            display: flex;
            flex-wrap: wrap;
            gap: 5px;
        }
    }
</style>
