<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\ProgramsImage $programsImage
 * @var \Cake\Collection\CollectionInterface|string[] $programs
 */
?>
<div class="container-xxl flex-grow-1 container-p-y">


    <div class="row">
        <!-- Form Card -->
        <div class="col-12">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Add Programs Image</h5>
                    <?= $this->Html->link(
                        '<i class="bx bx-arrow-back me-1"></i> Back to Programs Images',
                        ['action' => 'index'],
                        ['class' => 'btn btn-secondary btn-sm', 'escape' => false]
                    ) ?>
                </div>
                <div class="card-body">
                    <?= $this->Form->create($programsImage, [
                                'type' => 'file', 'class' => 'row g-3']) ?>
        <!-- Image Name -->
        <div class="col-md-12">
            <div class="form-group mb-3">
                <label class="form-label" for="image-name">Upload Image</label>
                
                <?= $this->Form->control('image_file', [
                    'class' => 'form-control',
                    'label' => false,
                    'type' => 'file',
                    'accept' => 'image/jpeg,image/jpg', // Restrict to JPEG/JPG files
                    'placeholder' => 'Choose an image file',
                    'id' => 'image-name'
                ]) ?>
                
                <small class="form-text text-muted">Please upload an image file.</small>
                <small class="form-text text-muted">Only JPEG/JPG files are allowed (max size: 2MB).</small>
            </div>
        </div>


        <?= $this->Form->control('program_id', [
            'options' => $programs,
            'empty' => true,
            'class' => 'form-control',
            'label' => false,
            'id' => 'program-id',
            'required' => true
        ]) ?>


                    <!-- Submit Buttons -->
                    <div class="col-12">
                        <hr class="my-4">
                        <?= $this->Form->button(__('Add Image'), [
                            'class' => 'btn btn-primary me-2'
                        ]) ?>

                        <?= $this->Html->link(
                            __('Cancel'),
                            ['action' => 'index'],
                            ['class' => 'btn btn-outline-secondary']
                        ) ?>
                    </div>
                    <?= $this->Form->end() ?>
                </div>
            </div>
        </div>
    </div>
</div>
