<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\ProgramsImage $programsImage
 * @var string[]|\Cake\Collection\CollectionInterface $programs
 */
?>
<div class="container-xxl flex-grow-1 container-p-y">


    <div class="row">
        <!-- Form Card -->
        <div class="col-12">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Edit Programs Image</h5>
                    <div>
                        <?= $this->Html->link(
                            '<i class="bx bx-arrow-back me-1"></i> Back to Programs Images',
                            ['action' => 'index'],
                            ['class' => 'btn btn-secondary btn-sm', 'escape' => false]
                        ) ?>
                        <?= $this->Form->postLink(
                            '<i class="bx bx-trash me-1"></i> Delete Programs Image',
                            ['action' => 'delete', $programsImage->id],
                            [
                                'confirm' => __('Are you sure you want to delete # {0}?', $programsImage->id),
                                'class' => 'btn btn-danger btn-sm ms-2',
                                'escape' => false
                            ]
                        ) ?>
                    </div>
                </div>
                <div class="card-body">
                    <?= $this->Form->create($programsImage, [
                        'type' => 'file', 'class' => 'row g-3']) ?>

                    <!-- Image Name -->
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="image_name">Image Name</label>
                            <?= $this->Form->control('image_name', [
                                'class' => 'form-control',
                                'label' => false,
                                'type' => 'file',
                                'accept' => 'image/*',
                                'placeholder' => 'Enter image name'
                            ]) ?>
                        </div>
                    </div>

                    <!-- Program ID -->
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="program-id">Program</label>
                            <?= $this->Form->control('program_id', [
                                'options' => $programs,
                                'empty' => '-- Select Program --',
                                'class' => 'form-select',
                                'label' => false
                            ]) ?>
                        </div>
                    </div>

                    <div class="col-12">
                        <hr class="my-4">
                        <?= $this->Form->button(__('Save Changes'), [
                            'class' => 'btn btn-primary me-2'
                        ]) ?>

                        <?= $this->Html->link(
                            __('Cancel'),
                            ['action' => 'index'],
                            ['class' => 'btn btn-outline-secondary']
                        ) ?>
                    </div>
                    <?= $this->Form->end() ?>
                </div>
            </div>
        </div>
    </div>
</div>
