<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\ProgramsSection> $programsSections
 */
?>
<div class="programsSections index content">
    <?= $this->Html->link(__('New Programs Section'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Programs Sections') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('title') ?></th>
                    <th><?= $this->Paginator->sort('body') ?></th>
                    <th><?= $this->Paginator->sort('program_id') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($programsSections as $programsSection): ?>
                <tr>
                    <td><?= $this->Number->format($programsSection->id) ?></td>
                    <td><?= h($programsSection->title) ?></td>
                    <td><?= h($programsSection->body) ?></td>
                    <td><?= $programsSection->hasValue('program') ? $this->Html->link($programsSection->program->name, ['controller' => 'Programs', 'action' => 'view', $programsSection->program->id]) : '' ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $programsSection->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $programsSection->id]) ?>
                        <?= $this->Form->postLink(
                            __('Delete'),
                            ['action' => 'delete', $programsSection->id],
                            [
                                'method' => 'delete',
                                'confirm' => __('Are you sure you want to delete # {0}?', $programsSection->id),
                            ]
                        ) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>