<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\ProgramsVolunteer $programsVolunteer
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Programs Volunteer'), ['action' => 'edit', $programsVolunteer->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Programs Volunteer'), ['action' => 'delete', $programsVolunteer->id], ['confirm' => __('Are you sure you want to delete # {0}?', $programsVolunteer->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Programs Volunteers'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Programs Volunteer'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="programsVolunteers view content">
            <h3><?= h($programsVolunteer->id) ?></h3>
            <table>
                <tr>
                    <th><?= __('Program') ?></th>
                    <td><?= $programsVolunteer->hasValue('program') ? $this->Html->link($programsVolunteer->program->name, ['controller' => 'Programs', 'action' => 'view', $programsVolunteer->program->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Volunteer') ?></th>
                    <td><?= $programsVolunteer->hasValue('volunteer') ? $this->Html->link($programsVolunteer->volunteer->first_name, ['controller' => 'Volunteers', 'action' => 'view', $programsVolunteer->volunteer->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($programsVolunteer->id) ?></td>
                </tr>
            </table>
        </div>
    </div>
</div>