<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Student $student
 * @var string[]|\Cake\Collection\CollectionInterface $programs
 */
?>

<style>
    .switch {
        position: relative;
        display: inline-block;
        width: 50px;
        height: 30px;
    }

    .switch input {
        opacity: 0;
        width: 0;
        height: 0;
    }

    .slider {
        position: absolute;
        cursor: pointer;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background-color: #ccc;
        transition: .4s;
        border-radius: 30px;
    }

    .slider:before {
        position: absolute;
        content: "";
        height: 22px;
        width: 22px;
        border-radius: 50%;
        left: 4px;
        bottom: 4px;
        background-color: white;
        transition: .4s;
    }

    input:checked + .slider {
        background-color: #4CAF50;
    }

    input:checked + .slider:before {
        transform: translateX(20px);
    }

    input:disabled + .slider {
        background-color: #ccc;
    }

    input:disabled + .slider:before {
        background-color: #f1f1f1;
    }

    .program-checkbox {
        position: absolute;
        opacity: 0;
        width: 0;
        height: 0;
    }

    .program-checkbox + label {
        position: relative;
        padding-left: 35px;
        font-size: 16px;
        cursor: pointer;
        line-height: 1.5;
        color: #333;
        transition: color 0.3s ease;
    }

    .program-checkbox + label::before {
        content: "";
        position: absolute;
        left: 0;
        top: 0;
        width: 25px;
        height: 25px;
        border: 2px solid #ccc;
        border-radius: 4px;
        background-color: #fff;
        transition: all 0.3s ease;
    }

    .program-checkbox:checked + label::before {
        background-color: #28a745;
        border-color: #28a745;
    }

    .program-checkbox:checked + label::after {
        content: '\2713';
        position: absolute;
        left: 4px;
        top: 0px;
        font-size: 18px;
        color: white;
    }

    .program-checkbox + label:hover {
        color: #28a745;
    }

    .program-checkbox:focus + label {
        outline: none;
        box-shadow: 0 0 2px 2px rgba(40, 167, 69, 0.5);
    }
</style>

<div class="container-xxl flex-grow-1 container-p-y">
    <div class="row">
        <!-- Form Card -->
        <div class="col-12">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Edit Student</h5>
                    <div>
                        <?= $this->Html->link(
                            '<i class="bx bx-arrow-back me-1"></i> Back to Students',
                            ['action' => 'index'],
                            ['class' => 'btn btn-secondary btn-sm', 'escape' => false]
                        ) ?>
                        <?= $this->Form->postLink(
                            '<i class="bx bx-trash me-1"></i> Delete Student',
                            ['action' => 'delete', $student->id],
                            [
                                'confirm' => __('Are you sure you want to delete # {0}?', $student->id),
                                'class' => 'btn btn-danger btn-sm ms-2',
                                'escape' => false
                            ]
                        ) ?>
                    </div>
                </div>
                <div class="card-body">
                    <?= $this->Flash->render() ?>
                    <?php if ($student->getErrors()): ?>
                        <div class="alert alert-danger">
                            <ul>
                                <?php foreach ($student->getErrors() as $field => $errors): ?>
                                    <?php foreach ($errors as $error): ?>
                                        <li><?= h($error) ?></li>
                                    <?php endforeach; ?>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                    <?= $this->Form->create($student, ['class' => 'row g-3']) ?>

                    <!-- Personal Information -->
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="name">Student Name *</label>
                            <?= $this->Form->control('name', [
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter student name',
                                'required' => true,
                                'maxlength' => 50,
                                'id' => 'name'
                            ]) ?>
                            <div id="name-counter" style="margin-top: 5px; font-size: 0.9rem; color: #555;">Characters: 0/50</div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="year-level">Year Level *</label>
                            <?= $this->Form->control('year_level', [
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter year level (e.g., 1-12)',
                                'required' => true,
                                'maxlength' => 10,
                                'id' => 'year-level'
                            ]) ?>
                            <div id="year-level-counter" style="margin-top: 5px; font-size: 0.9rem; color: #555;">Characters: 0/10</div>
                        </div>
                    </div>

                    <div class="col-12">
                        <div class="form-group mb-3">
                            <label class="form-label" for="school">School *</label>
                            <?= $this->Form->control('school', [
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter school name',
                                'required' => true,
                                'maxlength' => 100,
                                'id' => 'school'
                            ]) ?>
                            <div id="school-counter" style="margin-top: 5px; font-size: 0.9rem; color: #555;">Characters: 0/100</div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="contact-name">Registrar Name *</label>
                            <?= $this->Form->control('contact_name', [
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter registrar name',
                                'required' => true,
                                'maxlength' => 50,
                                'id' => 'contact-name'
                            ]) ?>
                            <div id="contact-name-counter" style="margin-top: 5px; font-size: 0.9rem; color: #555;">Characters: 0/50</div>
                        </div>
                    </div>

                    <!-- Contact Information -->
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="contact-email">Registrar Email *</label>
                            <?= $this->Form->control('contact_email', [
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'example@example.com',
                                'type' => 'email',
                                'required' => true,
                                'maxlength' => 50,
                                'id' => 'contact-email'
                            ]) ?>
                            <div id="contact-email-counter" style="margin-top: 5px; font-size: 0.9rem; color: #555;">Characters: 0/50</div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="contact-phone">Registrar Phone *</label>
                            <?= $this->Form->control('contact_phone', [
                                'class' => 'form-control',
                                'placeholder' => 'Enter phone number (10 digits)',
                                'label' => false,
                                'required' => true,
                                'pattern' => '^[0-9]{10}$',
                                'title' => 'Phone number must be exactly 10 digits',
                                'maxlength' => 15,
                                'id' => 'contact-phone'
                            ]) ?>
                            <div id="contact-phone-counter" style="margin-top: 5px; font-size: 0.9rem; color: #555;">Characters: 0/15</div>
                        </div>
                    </div>

                    <!-- Programs -->
                    <div class="col-12">
                        <div class="form-group mb-3">
                            <table id="programsTable" class="table">
                                <thead>
                                <tr>
                                    <th>Interested Programs</th>
                                    <th>Registered</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php foreach ($programs as $program_id => $program_name): ?>
                                    <tr data-program-id="<?= h($program_id) ?>" class="program-row">
                                        <td>
                                            <input type="checkbox" id="program-<?= h($program_id) ?>" name="programs[]" value="<?= h($program_id) ?>"
                                                   class="program-checkbox"
                                                <?= in_array($program_id, array_column($student->programs, 'id')) ? 'checked' : '' ?>
                                            >
                                            <label for="program-<?= h($program_id) ?>"><?= h($program_name) ?></label>
                                        </td>
                                        <td>
                                            <label class="switch">
                                                <input type="checkbox" name="program_status[<?= h($program_id) ?>]"
                                                       class="toggle-checkbox program-status-toggle"
                                                    <?php
                                                    if (isset($programStatuses[$program_id]) && $programStatuses[$program_id] == 1) {
                                                        echo 'checked';
                                                    }
                                                    ?>
                                                       disabled
                                                       data-program-id="<?= h($program_id) ?>"
                                                >
                                                <span class="slider round"></span>
                                            </label>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="col-12">
                        <hr class="my-4">
                        <?= $this->Form->button(__('Save Changes'), [
                            'class' => 'btn btn-primary me-2'
                        ]) ?>
                        <?= $this->Html->link(
                            __('Cancel'),
                            ['action' => 'index'],
                            ['class' => 'btn btn-outline-secondary']
                        ) ?>
                    </div>
                    <?= $this->Form->end() ?>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener("DOMContentLoaded", function () {
        // Existing code for program checkboxes and toggles
        const programCheckboxes = document.querySelectorAll('.program-checkbox');
        const statusCheckboxes = document.querySelectorAll('.program-status-toggle');

        programCheckboxes.forEach(function (checkbox) {
            checkbox.addEventListener('change', function () {
                const row = this.closest('tr');
                const toggle = row.querySelector('.program-status-toggle');

                if (this.checked) {
                    toggle.disabled = false;
                    toggle.closest('td').style.display = 'table-cell';
                } else {
                    toggle.disabled = true;
                    toggle.closest('td').style.display = 'none';
                }
            });

            if (checkbox.checked) {
                const row = checkbox.closest('tr');
                const toggle = row.querySelector('.program-status-toggle');
                toggle.disabled = false;
                toggle.closest('td').style.display = 'table-cell';
            } else {
                const row = checkbox.closest('tr');
                const toggle = row.querySelector('.program-status-toggle');
                toggle.disabled = true;
                toggle.closest('td').style.display = 'none';
            }
        });

        statusCheckboxes.forEach(function (toggle) {
            toggle.addEventListener('change', function () {
                if (this.checked) {
                    this.parentElement.querySelector('.slider').style.backgroundColor = "#4CAF50";
                } else {
                    this.parentElement.querySelector('.slider').style.backgroundColor = "#ccc";
                }
            });
        });

        // New code for input validation
        const nameInput = document.getElementById('name');
        const yearLevelInput = document.getElementById('year-level');
        const schoolInput = document.getElementById('school');
        const contactNameInput = document.getElementById('contact-name');
        const contactEmailInput = document.getElementById('contact-email');
        const contactPhoneInput = document.getElementById('contact-phone');

        const nameCounter = document.getElementById('name-counter');
        const yearLevelCounter = document.getElementById('year-level-counter');
        const schoolCounter = document.getElementById('school-counter');
        const contactNameCounter = document.getElementById('contact-name-counter');
        const contactEmailCounter = document.getElementById('contact-email-counter');
        const contactPhoneCounter = document.getElementById('contact-phone-counter');

        // Validation functions
        function validateName(input, maxLength) {
            // Allow letters, spaces, periods, commas, quotes, hyphens (same as certificate recipient name)
            let sanitized = input.replace(/[^a-zA-Z .,\'"-]/g, '');
            if (sanitized.length > maxLength) {
                sanitized = sanitized.substring(0, maxLength);
            }
            return sanitized;
        }

        function validateYearLevel(input, maxLength) {
            // Allow numbers only
            let sanitized = input.replace(/[^0-9]/g, '');
            if (sanitized.length > maxLength) {
                sanitized = sanitized.substring(0, maxLength);
            }
            return sanitized;
        }

        function validateText(input, maxLength) {
            // Allow letters, numbers, spaces, periods, commas, quotes, hyphens (same as certificate custom text)
            let sanitized = input.replace(/[^a-zA-Z0-9 .,\'"-]/g, '');
            if (sanitized.length > maxLength) {
                sanitized = sanitized.substring(0, maxLength);
            }
            return sanitized;
        }

        function validateEmail(input, maxLength) {
            // Allow standard email characters (letters, numbers, @, dots, etc.)
            let sanitized = input.replace(/[^a-zA-Z0-9@._-]/g, '');
            if (sanitized.length > maxLength) {
                sanitized = sanitized.substring(0, maxLength);
            }
            return sanitized;
        }

        function validatePhone(input, maxLength) {
            // Allow numbers only (to match the pattern ^[0-9]{10}$)
            let sanitized = input.replace(/[^0-9]/g, '');
            if (sanitized.length > maxLength) {
                sanitized = sanitized.substring(0, maxLength);
            }
            return sanitized;
        }

        // Update counter functions
        function updateNameCounter() {
            nameInput.value = validateName(nameInput.value, 50);
            const charCount = nameInput.value.length;
            nameCounter.textContent = `Characters: ${charCount}/50${charCount === 50 ? ' (Maximum reached)' : ''}`;
            nameCounter.style.color = charCount === 50 ? 'red' : '#555';
        }

        function updateYearLevelCounter() {
            yearLevelInput.value = validateYearLevel(yearLevelInput.value, 10);
            const charCount = yearLevelInput.value.length;
            yearLevelCounter.textContent = `Characters: ${charCount}/10${charCount === 10 ? ' (Maximum reached)' : ''}`;
            yearLevelCounter.style.color = charCount === 10 ? 'red' : '#555';
        }

        function updateSchoolCounter() {
            schoolInput.value = validateText(schoolInput.value, 100);
            const charCount = schoolInput.value.length;
            schoolCounter.textContent = `Characters: ${charCount}/100${charCount === 100 ? ' (Maximum reached)' : ''}`;
            schoolCounter.style.color = charCount === 100 ? 'red' : '#555';
        }

        function updateContactNameCounter() {
            contactNameInput.value = validateName(contactNameInput.value, 50);
            const charCount = contactNameInput.value.length;
            contactNameCounter.textContent = `Characters: ${charCount}/50${charCount === 50 ? ' (Maximum reached)' : ''}`;
            contactNameCounter.style.color = charCount === 50 ? 'red' : '#555';
        }

        function updateContactEmailCounter() {
            contactEmailInput.value = validateEmail(contactEmailInput.value, 50);
            const charCount = contactEmailInput.value.length;
            contactEmailCounter.textContent = `Characters: ${charCount}/50${charCount === 50 ? ' (Maximum reached)' : ''}`;
            contactEmailCounter.style.color = charCount === 50 ? 'red' : '#555';
        }

        function updateContactPhoneCounter() {
            contactPhoneInput.value = validatePhone(contactPhoneInput.value, 15);
            const charCount = contactPhoneInput.value.length;
            contactPhoneCounter.textContent = `Characters: ${charCount}/15${charCount === 15 ? ' (Maximum reached)' : ''}`;
            contactPhoneCounter.style.color = charCount === 15 ? 'red' : '#555';
        }

        // Initialize counters on page load
        updateNameCounter();
        updateYearLevelCounter();
        updateSchoolCounter();
        updateContactNameCounter();
        updateContactEmailCounter();
        updateContactPhoneCounter();

        // Attach event listeners for real-time updates
        nameInput.addEventListener('input', updateNameCounter);
        yearLevelInput.addEventListener('input', updateYearLevelCounter);
        schoolInput.addEventListener('input', updateSchoolCounter);
        contactNameInput.addEventListener('input', updateContactNameCounter);
        contactEmailInput.addEventListener('input', updateContactEmailCounter);
        contactPhoneInput.addEventListener('input', updateContactPhoneCounter);
    });
</script>
