<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width,initial-scale=1.0" />
    <title>Create Email Template</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --font-main: 'Inter', sans-serif;
            --bg-body: #f5f5f5;
            --bg-main: #fff;
            --border: #eee;
            --radius: 8px;
            --gap: 24px;
        }
        * { box-sizing: border-box; }
        body {
            margin: 0;
            padding: 0;
            font-family: var(--font-main);
            background: var(--bg-body);
        }
        .editor-container {
            max-width: 1700px;
            margin: 30px auto;
            background: var(--bg-main);
            border-radius: var(--radius);
            overflow: hidden;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            padding: var(--gap);
            min-height: calc(100vh - 60px);
        }
        .editor-panel {
            width: 100%;
            min-width: 0;
        }
        h2 {
            margin-top: 0;
            font-size: 28px;
            font-weight: 700;
        }
        .form-label {
            display: block;
            font-weight: 600;
            font-size: 16px;
            margin: 16px 0 8px;
        }
        iframe#email-builder-frame {
            width: 100%;
            height: 600px;
            border: 1px solid var(--border);
            border-radius: var(--radius);
        }
        .form-control {
            width: 100%;
            padding: 10px;
            font-size: 15px;
            border-radius: 4px;
            border: 1px solid #ccc;
        }
        .form-actions {
            margin-top: var(--gap);
            display: flex;
            gap: 12px;
        }
        .btn-primary,
        .btn-secondary {
            padding: 12px 24px;
            font-size: 15px;
            border-radius: 5px;
            cursor: pointer;
            text-decoration: none;
            border: none;
            display: inline-block;
        }
        .btn-primary { background: #ff7043; color: #fff; }
        .btn-secondary { background: #e0e0e0; color: #333; }
    </style>
</head>
<body>
<main class="editor-container">
    <section class="editor-panel">
        <h2>Create Email Template</h2>

        <?= $this->Form->create($template) ?>

        <label class="form-label">Email Subject</label>
        <?= $this->Form->control('name', [
            'label' => false,
            'class' => 'form-control',
            'placeholder' => 'Enter subject here...',
            'required' => true
        ]) ?>

        <label class="form-label">Email Content Builder</label>
        <iframe src="http://localhost:5173/email-builder-js/"
                id="email-builder-frame"></iframe>

        <?= $this->Form->control('content', [
            'type' => 'hidden',
            'id'   => 'content-input',
            'value'=> $template->content
        ]) ?>

        <div class="form-actions">
            <?= $this->Html->link('Cancel',
                ['action' => 'index'],
                ['class' => 'btn-secondary']) ?>
            <?= $this->Form->button('Save', [
                'type' => 'button',
                'class'=> 'btn-primary',
                'id'   => 'save-button'
            ]) ?>
        </div>

        <?= $this->Form->end() ?>
    </section>
</main>

<script>
    // Listen for the builder iframe's SAVE_HTML message
    window.addEventListener('message', event => {
        if (event.data?.type === 'SAVE_HTML') {
            document.getElementById('content-input').value = event.data.html;
            document.querySelector('form').submit();
        }
    });

    // Trigger the builder iframe to send its HTML when "Save" is clicked
    document.getElementById('save-button').addEventListener('click', e => {
        e.preventDefault();
        document.getElementById('email-builder-frame')
            .contentWindow
            .postMessage({ type: 'TRIGGER_SAVE' }, '*');
    });
</script>
</body>
</html>
