<div class="email-templates form-container">
    <h2>Edit Email Template</h2>
    <!-- Back button -->
    <button type="button" class="btn btn-secondary" onclick="window.history.back();">
        ← Back
    </button>

    <?= $this->Html->script('/js/tinymce/tinymce.min.js', ['block' => true]) ?>
    <?= $this->Html->scriptStart(['block' => true]) ?>
    tinymce.init({
    selector: '#content',
    height: 400,
    plugins: 'lists link image preview code',
    toolbar: 'undo redo | formatselect | bold italic underline | alignleft aligncenter alignright | bullist numlist | link image | preview code',
    menubar: false,
    branding: false
    });
    <?= $this->Html->scriptEnd() ?>

    <?= $this->Form->create($template) ?>

    <div class="form-group">
        <?= $this->Form->control('name', [
            'label' => 'Email Subject',
            'placeholder' => 'Subject line of your email',
            'class' => 'form-control',
            'id'    => 'subject'
        ]) ?>
    </div>

    <div class="form-group">
        <?= $this->Form->control('content', [
            'label' => 'Email Content',
            'type' => 'textarea',
            'id' => 'content',
            'rows' => 15,
            'class' => 'form-control'
        ]) ?>
    </div>

    <div class="form-actions">
        <?= $this->Html->link('Cancel', ['action' => 'index'], ['class' => 'btn btn-secondary']) ?>
        <?= $this->Form->button(__('Save Changes'), ['class' => 'btn btn-primary']) ?>
    </div>

    <?= $this->Form->end() ?>
</div>

<style>
    .email-templates.form-container {
        max-width: 850px;
        margin: auto;
        padding: 30px;
        background: #ffffff;
        border-radius: 8px;
        border: 1px solid #eee;
        font-family: 'Arial', sans-serif;
    }
    h2 {
        margin-bottom: 1rem;
    }
    .btn {
        padding: 10px 20px;
        font-size: 16px;
        cursor: pointer;
        text-decoration: none;
    }
    .btn-secondary {
        background-color: #e0e0e0;
        color: #333;
        border: none;
        border-radius: 4px;
        margin-bottom: 1.5rem;
    }
    .form-group {
        margin-bottom: 20px;
    }
    .form-control {
        width: 100%;
        padding: 10px;
        font-size: 16px;
        margin-top: 5px;
        border-radius: 4px;
        border: 1px solid #ccc;
    }
    .btn-primary {
        background-color: #ff7043;
        color: #fff;
        border: none;
        border-radius: 4px;
    }
    .form-actions .btn-secondary {
        margin: 0 10px 0 0;
    }
</style>
