<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width,initial-scale=1.0" />
    <title>Email Preview & Advanced Filters</title>

    <!-- Inter UI -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <!-- Tagify CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@yaireo/tagify/dist/tagify.css">
    <!-- Flatpickr CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">

    <style>
        :root {
            --radius: 0.5rem;
            --gap: 1rem;
            --shadow: 0 4px 12px rgba(0,0,0,0.05);
            --primary: #E87532;
            --bg: #ffffff;
            --fg: #333333;
            --border: #dddddd;
            --focus: rgba(232,117,50,0.4);
        }
        *, *::before, *::after { box-sizing: border-box; }
        body {
            margin: 0;
            padding: 0;
            font-family: 'Inter', sans-serif;
            background: #f5f5f5;
            color: var(--fg);
            line-height: 1.5;
            font-size: 1rem;
        }
        a, button { font-family: inherit; }

        /* === Layout === */
        .container {
            width: 100%;
            max-width: none; /* Or increase this to, say, 1600px */
            gap: var(--gap);
            padding: 0 var(--gap);
        }
        .preview-panel {
            background: var(--bg);
            border-radius: var(--radius);
            box-shadow: var(--shadow);
            padding: var(--gap);
        }

        /* === Buttons === */
        .btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            padding: 0.5rem 1rem;
            background: var(--primary);
            color: #fff;
            border: none;
            border-radius: var(--radius);
            cursor: pointer;
            text-decoration: none;
            transition: background 0.2s, box-shadow 0.2s;
        }
        .btn:hover { background: #d26729; }
        .btn:focus {
            outline: 2px solid var(--focus);
            outline-offset: 2px;
        }

        /* === Preview Panel === */
        .preview-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: var(--gap);
        }
        .template-title {
            font-size: 1.5rem;
            margin: 0;
            font-weight: 600;
        }
        .header-actions {
            display: flex;
            gap: 0.5rem;
        }
        .action-toolbar {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            margin-bottom: var(--gap);
        }
        .action-toolbar button {
            background: #eeeeee;
            color: var(--fg);
            padding: 0.5rem;
            border-radius: var(--radius);
            cursor: pointer;
        }
        .action-toolbar button:hover { background: #dddddd; }
        .action-desc {
            font-size: 0.9rem;
            color: #666;
            margin-right: var(--gap);
            white-space: nowrap;
        }
        .view-icon {
            width: 20px;
            height: 20px;
            display: none;
            fill: var(--fg);
        }
        .view-icon.active { display: inline-block; }

        .template-preview-box {
            background: #f9f9f9;
            padding: var(--gap);
            border-radius: var(--radius);
            margin-bottom: var(--gap);
        }
        .preview-subject {
            font-weight: 600;
            font-size: 1.1rem;
            margin-bottom: 0.5rem;
        }
        .preview-content {
            padding: 0.75rem;
            background: var(--bg);
            border: 1px solid var(--border);
            border-radius: var(--radius);
            min-height: 150px;
            overflow: auto;
        }

        .template-send-panel {
            border-top: 1px solid var(--border);
            padding-top: var(--gap);
        }
        .form-group { margin-bottom: var(--gap); }
        .form-label {
            display: block;
            font-weight: 600;
            margin-bottom: 0.25rem;
        }
        .form-control {
            width: 100%;
            padding: 0.5rem;
            font-size: 1rem;
            border: 1px solid var(--border);
            border-radius: var(--radius);
            transition: border-color 0.2s, box-shadow 0.2s;
        }
        .form-control:focus {
            border-color: var(--primary);
            outline: none;
            box-shadow: 0 0 0 2px var(--focus);
        }

        /* === Filter Panel === */
        .filter-title {
            font-size: 1.2rem;
            font-weight: 600;
            margin-bottom: 0.75rem;
        }
        .checkbox-label {
            display: flex;
            align-items: center;
            margin-bottom: 0.75rem;
            color: #555;
        }
        .checkbox-label input {
            margin-right: 0.5rem;
            width: 16px; height:16px;
            accent-color: var(--primary);
            cursor: pointer;
        }
        /* Schedule plugin */
        .schedule-group {
            margin-top: 1.5rem;
            margin-bottom: 1.5rem;
        }
        .schedule-toggle {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            margin-bottom: 1.5rem;
            cursor: pointer;
        }
        .schedule-toggle input {
            width: 40px; height: 20px;
            position: relative;
            appearance: none;
            background: #ccc;
            border-radius: 10px;
            outline: none;
            cursor: pointer;
            transition: background 0.2s;
        }
        .schedule-toggle input:checked { background: var(--primary); }
        .schedule-toggle input::before {
            content: '';
            position: absolute;
            width: 16px; height:16px;
            top: 2px; left: 2px;
            background: #fff;
            border-radius: 50%;
            transition: transform 0.2s;
        }
        .schedule-toggle input:checked::before {
            transform: translateX(20px);
        }
        #schedule-options {
            display: none;
            margin: 1.5rem;;
        }

        .input-with-button {
            position: relative;
        }

        .input-with-button input {
            padding-right: 2.5rem; /* Space for button */
        }

        .toggle-table-btn {
            position: absolute;
            top: 50%;
            right: 0.5rem;
            transform: translateY(-50%);
            background: none;
            border: none;
            font-size: 1.2rem;
            cursor: pointer;
            color: #666;
            padding: 0;
        }

        .toggle-table-btn:hover {
            color: var(--primary);
        }

        #recipient-tables {
            padding-left: 1rem;
        }

        #recipient-tables summary {
            font-weight: bold;
            font-size: 1.1rem;
            margin-bottom: 0.25rem;
        }

        #recipient-tables table {
            width: 100%;
            margin-top: 0.5rem;
            border-collapse: collapse;
        }

        #recipient-tables td {
            padding: 0.5rem 0.5rem 0.5rem 1rem; /* Left indent */
        }

        #recipient-tables td:last-child {
            text-align: right;
        }

        /* Compact and subtle table header */
        .recipient-thead th {
            font-size: 0.8rem;
            font-weight: bold;
            padding: 0.25rem 0.5rem;
            color: #666;
            text-align: left;
            border-bottom: 1px solid #eee;
        }

        /* Hide <thead> unless <details> is open */
        details:not([open]) .recipient-thead {
            display: none;
        }

        table tbody tr {
            border-bottom: 1px solid #eee;
        }

        /* Optional: remove border from last row */
        table tbody tr:last-child {
            border-bottom: none;
        }

        /* Style the summary triangle */
        details summary {
            list-style: none; /* Remove default triangle */
            position: relative;
            padding-left: 1.2rem;
            cursor: pointer;
        }

        details summary::before {
            content: '';
            position: absolute;
            left: 0;
            top: 0.4rem;
            width: 0.6rem;
            height: 0.6rem;
            border: solid #888;
            border-width: 0 2px 2px 0;
            transform: rotate(45deg);
            border-radius: 2px;
            transition: transform 0.2s;
        }

        /* Rotate the triangle when open */
        details[open] summary::before {
            transform: rotate(135deg);
        }

        button {
            border: none;
            border-radius: 6px;
            background: #f0f0f0;
            padding: 0.3rem 0.6rem;
            cursor: pointer;
            transition: background 0.2s;
            font-size: 1rem;
        }

        button:hover {
            background: #e0e0e0;
        }

        button:focus {
            outline: none;
            box-shadow: 0 0 0 2px rgba(200, 200, 200, 0.4);
        }

        .recipient-group .add-all-btn {
            float: right;
            margin: 0.25rem 0;
            padding: 0.25rem 0.5rem;
            border: none;
            border-radius: 6px;
            background: #f0f0f0;
            cursor: pointer;
            font-size: 0.9rem;
            display: none;
        }

        .recipient-group[open] .add-all-btn {
            display: inline-block;
        }

        .spinner {
            border: 3px solid #f3f3f3;
            border-top: 3px solid #3498db;
            border-radius: 50%;
            width: 16px;
            height: 16px;
            animation: spin 1s linear infinite;
            display: inline-block;
            vertical-align: middle;
            margin-right: 8px;
        }

        .d-none {
            display: none !important;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }




        @media (max-width: 900px) {
            .container { flex-direction: column; }
            .preview-panel, .filter-panel { flex: 1 1 auto; position: static; top: auto; }
        }

    </style>
</head>


<body>

<div class="container">
    <!-- Left: Preview & Send -->
    <section class="preview-panel" aria-label="Email preview and send form">
        <div class="preview-header">
            <h1 class="template-title"><?= h($template->name) ?></h1>
            <div class="header-actions">
                <button type="button" class="btn" onclick="history.back()">Back</button>
                <?= $this->Html->link('Edit Template', ['action'=>'edit',$template->id], ['class'=>'btn']) ?>
            </div>
        </div>

        <div class="action-toolbar" aria-label="Preview actions">
            <button type="button" onclick="copyHTML()" title="Copy HTML to clipboard">📋 Copy HTML</button>


            <button type="button" id="toggle-view-btn" title="Toggle desktop/mobile view">
                <svg id="icon-desktop" class="view-icon active" viewBox="0 0 24 24">
                    <path d="M3 4h18v12H3z"/><path d="M0 18h24v2H0z"/>
                </svg>
                <svg id="icon-mobile" class="view-icon" viewBox="0 0 24 24">
                    <rect x="7" y="2" width="10" height="20" rx="2"/><circle cx="12" cy="18" r="1"/>
                </svg>
            Screen Size</button>
        </div>

        <section class="template-preview-box">
            <div class="preview-subject"><?= h($template->name ?: 'No Subject') ?></div>
            <div class="preview-content" id="preview-content"><?= $this->Text->autoParagraph($template->content) ?></div>
        </section>

        <section class="template-send-panel" aria-labelledby="send-label">
            <h2 id="send-label" class="visually-hidden">Send Email</h2>
            <?= $this->Form->create(null, ['url'=>['action'=>'send'], 'class'=>'email-form']) ?>
            <?= $this->Form->hidden('template_ids[]',['value'=>$template->id]) ?>

            <div class="form-group">
                <label for="recipient_emails" class="form-label">Recipients</label>
                <div class="input-with-button">
                    <input id="recipient_emails" name="recipient_emails" class="form-control" placeholder="Add email addresses"/>
                    <button id="show-recipients-btn" type="button" class="toggle-table-btn" onclick="toggleRecipientTables()" title="Show recipients">📂</button>
                </div>
            </div>

            <div id="recipient-tables" style="display: none; margin-top: 1rem;">
                
                <!-- Filter Dropdown -->
                <div id="program-filter-container" class="form-group" style="margin-bottom: 1rem;">
                    <label for="program-filter" class="form-label" style="font-weight: 500;">Filter by Program</label>
                    <select id="program-filter" class="form-control">
                        <option value="all" <?= $programId === 'all' || !$programId ? 'selected' : '' ?>>All Contacts</option>
                        <?php foreach ($programs as $program): ?>
                            <option value="<?= h($program->id) ?>" <?= (string)$program->id === (string)$programId ? 'selected' : '' ?>>
                                <?= h($program->name) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <!-- Tables -->
                <?php foreach (['students' => $students, 'volunteers' => $volunteers, 'visitors' => $visitors] as $group => $data): ?>
                    <details class="recipient-group" style="margin-bottom: 1rem;">
                        <summary style="font-weight: bold; font-size: 1.1rem;">
                            <?= ucfirst($group) ?>
                        </summary>
                        <table data-group="<?= $group ?>" style="width: 100%; margin-top: 0.5rem;">
                            <thead class="recipient-thead">
                                <tr>
                                    <?php if ($group === 'students'): ?>
                                        <th>Student Name</th>
                                        <th>Contact Name</th>
                                        <th>Contact Email</th>
                                    <?php else: ?>
                                        <th>Name</th>
                                        <th>Email</th>
                                        <th></th>
                                    <?php endif; ?>
                                    <th style="text-align: right;">
                                        <button type="button" class="add-all-btn" onclick="addAllFromGroup('<?= $group ?>')" title="Add all">➕ Add All</button>
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php foreach ($data as $person): ?>
                                <?php
                                    $name = match($group) {
                                        'students' => $person->contact_name,
                                        'volunteers' => $person->first_name . ' ' . $person->last_name,
                                        'visitors' => $person->name,
                                    };
                                    $email = match($group) {
                                        'students' => $person->contact_email,
                                        default => $person->email,
                                    };
                                ?>
                                <?php
                                    $programIds = is_iterable($person->programs) ? collection($person->programs)->extract('id')->toList() : [];
                                ?>
                                <tr data-program-id="<?= h(implode(',', $programIds)) ?>">
                                    <?php if ($group === 'students'): ?>
                                        <td><?= h($person->name) ?></td>
                                        <td><?= h($person->contact_name) ?></td>
                                        <td><?= h($person->contact_email) ?></td>
                                        <td style="text-align: right;">
                                            <button type="button" onclick="addEmail('<?= h($person->contact_email) ?>')" title="Add email">➕</button>
                                        </td>
                                    <?php else: ?>
                                        <td><?= h($name) ?></td>
                                        <td><?= h($email) ?></td>
                                        <td style="text-align: right;">
                                            <button type="button" onclick="addEmail('<?= h($email) ?>')" title="Add email">➕</button>
                                        </td>
                                    <?php endif; ?>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                    </details>
                <?php endforeach; ?>
            </div>


            <!-- I want to delete this but apparently the 'phone view' button breaks if I do -->
            <div class="schedule-group">
                <label class="schedule-toggle">
                    <input type="checkbox" id="schedule_send" name="schedule_send" style="display: none;"/>
                </label>
            </div>

            <button type="submit" class="btn btn-send" id="send-email-button">
                <span class="spinner d-none" id="spinner" style="margin-right: 8px;"></span>
                Send Email
            </button>
            <?= $this->Form->end() ?>
        </section>
    </section>

   
</div>

<!-- Tagify, Flatpickr & Scripts -->
<script src="https://cdn.jsdelivr.net/npm/@yaireo/tagify"></script>
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script>
    // === Enhanced Tagify for recipient_emails ===
    const input = document.querySelector('#recipient_emails');
    const tagify = new Tagify(input, {
        pattern: /^[^\s@]+@[^\s@]+\.[^\s@]+$/,  // Email validation
        delimiters: ",| ",                      // Split on comma or space
        keepInvalidTags: false,                 // Prevent invalid emails
        editTags: false,                        // Disable editing on click
        dropdown: { enabled: 0 }                // No suggestion dropdown
    });

    tagify.on('invalid', (e) => {
        alert(`"${e.detail.data.value}" is not a valid email address.`);
    });

    // === Flatpickr initialization for scheduled send ===
    flatpickr("#schedule_datetime", {
        enableTime: true,
        dateFormat: "Y-m-d H:i",
        minDate: "today"
    });

    // === Schedule checkbox toggle logic ===
    const schedToggle = document.getElementById('schedule_send');
    const schedOpts = document.getElementById('schedule-options');
    schedToggle?.addEventListener('change', () => {
        schedOpts.style.display = schedToggle.checked ? 'block' : 'none';
    });

    // === Copy HTML button logic ===
    function copyHTML() {
        navigator.clipboard.writeText(
            document.getElementById('preview-content').innerHTML
        );
        alert('Copied to clipboard');
    }

    // === Toggle mobile/desktop preview view ===
    let mobile = false;
    const btnView = document.getElementById('toggle-view-btn');
    const iconD = document.getElementById('icon-desktop');
    const iconM = document.getElementById('icon-mobile');
    const preview = document.getElementById('preview-content');

    btnView.addEventListener('click', () => {
        mobile = !mobile;
        iconD.classList.toggle('active', !mobile);
        iconM.classList.toggle('active', mobile);
        preview.style.maxWidth = mobile ? '375px' : '';
        preview.style.margin = mobile ? '0 auto' : '';
    });

    function toggleRecipientTables() {
        const container = document.getElementById('recipient-tables');
        container.style.display = container.style.display === 'none' ? 'block' : 'none';
    }

    function addEmail(email) {
        const existing = tagify.value.map(tag => tag.value.toLowerCase());
        if (!existing.includes(email.toLowerCase())) {
            tagify.addTags([email]);
        }
    }

    function addAllFromGroup(group) {
        const table = document.querySelector(`table[data-group="${group}"]`);
        const rows = table.querySelectorAll("tbody tr");
        rows.forEach(row => {
            const cells = row.cells;
            const email = cells[cells.length - 2].innerText.trim(); // second-to-last cell
            if (email) addEmail(email);
        });
    }

    document.getElementById('program-filter').addEventListener('change', function () {
        const selected = this.value;
        // Filtering logic to be added based on selected program
        console.log("Selected Program ID:", selected);
    });

    // === Program Filtering ===
    const filterSelect = document.getElementById('program-filter');
    const programFilterContainer = document.getElementById('program-filter-container');
    const recipientTables = document.getElementById('recipient-tables');

    function filterRecipients() {
        const selected = filterSelect.value;

        // Always hide visitors unless 'all' is selected
        const visitorSection = document.querySelector('table[data-group="visitors"]')?.closest('details');
        if (visitorSection) {
            visitorSection.style.display = selected === 'all' ? '' : 'none';
        }

        ['students', 'volunteers'].forEach(group => {
            const table = document.querySelector(`table[data-group="${group}"]`);
            const wrapper = table?.closest('details');
            let visibleRowCount = 0;

            if (table && wrapper) {
                const rows = table.querySelectorAll('tbody tr');
                rows.forEach(row => {
                    const rowProgramIds = row.getAttribute('data-program-id')?.split(',') || [];
                    const match = selected === 'all' || rowProgramIds.includes(selected);
                    row.style.display = match ? '' : 'none';
                    if (match) visibleRowCount++;
                });

                wrapper.style.display = visibleRowCount > 0 ? '' : 'none';
            }
        });
    }

    filterSelect.addEventListener('change', filterRecipients);

    const showRecipientsBtn = document.getElementById('show-recipients-btn');
    showRecipientsBtn.addEventListener('click', () => {
        setTimeout(() => {
            programFilterContainer.style.display = recipientTables.style.display === 'none' ? 'none' : '';
        }, 0);
    });

    // === Spinner + Delayed Submit ===
    document.addEventListener('DOMContentLoaded', function () {
        const form = document.querySelector('form');
        const spinner = document.getElementById('spinner');
        const button = document.getElementById('send-email-button');

        if (form && spinner && button) {
            form.addEventListener('submit', function (e) {
                e.preventDefault(); // delay submit to allow blur/cleanup

                spinner.classList.remove('d-none');
                button.setAttribute('disabled', 'disabled');

                setTimeout(() => {
                    form.submit();
                }, 100); // 100ms delay
            });
        }
    });
</script>





</body>
</html>
