<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Visitor $visitor
 */
?>
<div class="container">
    <div class="header-container">
        <h3 class="program-header"><?= h($visitor->email) ?></h3>
    </div>

    <table class="info-table">
        <tr>
            <th><?= __('Email') ?></th>
            <td><?= h($visitor->email) ?></td>
        </tr>
        <tr>
            <th><?= __('Name') ?></th>
            <td><?= h($visitor->name) ?></td>
        </tr>
        <tr>
            <th><?= __('Id') ?></th>
            <td><?= $this->Number->format($visitor->id) ?></td>
        </tr>
        <tr>
            <th><?= __('Created At') ?></th>
            <td><?= h($visitor->created_at) ?></td>
        </tr>
        <tr>
            <th><?= __('Updated At') ?></th>
            <td><?= h($visitor->updated_at) ?></td>
        </tr>
    </table>

    <div class="text-end mt-4">
        <?= $this->Html->link(
            '<i class="bx bx-arrow-back me-1"></i> Back to Visitors',
            ['action' => 'index'],
            ['class' => 'btn btn-secondary btn-sm me-2', 'escape' => false]
        ) ?>
        <?= $this->Html->link(
            '<i class="bx bx-edit-alt me-1"></i> Edit Visitor',
            ['action' => 'edit', $visitor->id],
            ['class' => 'btn btn-warning btn-sm me-2', 'escape' => false]
        ) ?>
        <?= $this->Form->postLink(
            '<i class="bx bx-trash me-1"></i> Delete Visitor',
            ['action' => 'delete', $visitor->id],
            [
                'confirm' => __('Are you sure you want to delete # {0}?', $visitor->id),
                'class' => 'btn btn-danger btn-sm',
                'escape' => false
            ]
        ) ?>
    </div>
</div>

<style>
    .container {
        max-width: 900px;
        margin: 0 auto;
        padding: 20px;
    }

    .header-container {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 20px;
    }

    .program-header {
        color: #333;
        margin: 0;
    }

    .info-table {
        width: 100%;
        border-collapse: collapse;
        background: #fff;
        box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
    }

    .info-table th,
    .info-table td {
        padding: 15px;
        text-align: left;
        border-bottom: 1px solid #eee;
    }

    .info-table th {
        background: #f5f5f5;
        width: 30%;
    }

    .btn {
        padding: 6px 12px;
        font-size: 14px;
        border-radius: 4px;
        text-decoration: none;
    }

    .btn-warning {
        background-color: #f0ad4e;
        color: white;
        border: none;
    }

    .btn-danger {
        background-color: #d9534f;
        color: white;
        border: none;
    }

    .btn-warning:hover {
        background-color: #ec971f;
    }

    .btn-danger:hover {
        background-color: #c9302c;
    }
</style>