<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\VolunteerStatus $volunteerStatus
 */
?>
<div class="container">
    <div class="header-container">
        <h3 class="program-header"><?= h($volunteerStatus->name) ?></h3>
    </div>

    <table class="info-table">
        <tr>
            <th>Status Name</th>
            <td><?= h($volunteerStatus->name) ?></td>
        </tr>
        <tr>
            <th>ID</th>
            <td><?= $this->Number->format($volunteerStatus->id) ?></td>
        </tr>
    </table>

    <!-- Related Volunteers Section -->
    <div class="related-section">
        <h4>Related Volunteers</h4>
        <?php if (!empty($volunteerStatus->volunteers)) : ?>
            <div class="responsive-table">
                <table class="data-table">
                    <thead>
                    <tr>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Phone</th>
                        <th>Postcode</th>
                        <th>Occupation</th>
                        <th>Actions</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($volunteerStatus->volunteers as $volunteer) : ?>
                        <tr>
                            <td><?= h($volunteer->first_name . ' ' . $volunteer->last_name) ?></td>

                            <td>
                                <a href="mailto:<?= h($volunteer->email) ?>" style="text-decoration: underline;">
                                    <?= h($volunteer->email) ?>
                                </a>
                            </td>
                            <td>
                                <a href="tel:<?= h($volunteer->phone) ?>" style="text-decoration: underline;">
                                    <?= h($volunteer->phone) ?>
                                </a>
                            </td>
                            <td><?= h($volunteer->postcode) ?></td>
                            <td><?= h($volunteer->occupation) ?></td>
                            <td class="actions">
                                <?= $this->Html->link('View', ['controller' => 'Volunteers', 'action' => 'view', $volunteer->id]) ?>
                                <?= $this->Html->link('Edit', ['controller' => 'Volunteers', 'action' => 'edit', $volunteer->id]) ?>
                                <?= $this->Form->postLink('Delete', ['controller' => 'Volunteers', 'action' => 'delete', $volunteer->id], ['confirm' => __('Are you sure you want to delete # {0}?', $volunteer->id)]) ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else : ?>
            <p>No volunteers found for this status.</p>
        <?php endif; ?>
    </div>
</div>

<style>
    * {
        box-sizing: border-box;
        font-family: Arial, sans-serif;
    }

    .container {
        max-width: 1200px;
        margin: 0 auto;
        padding: 20px;
    }

    .header-container {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 20px;
    }

    .program-header {
        color: #333;
        margin: 0;
    }

    .info-table {
        width: 100%;
        border-collapse: collapse;
        margin-bottom: 30px;
        background: #fff;
        box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
    }

    .info-table th,
    .info-table td {
        padding: 15px;
        text-align: left;
        border-bottom: 1px solid #eee;
    }

    .info-table th {
        background: #f5f5f5;
        width: 30%;
    }

    .related-section {
        margin: 30px 0;
    }

    .related-section h4 {
        color: #2c3e50;
        margin-bottom: 15px;
        border-bottom: 2px solid #e87532;
        padding-bottom: 5px;
    }

    .responsive-table {
        overflow-x: auto;
        margin-bottom: 20px;
    }

    .data-table {
        width: 100%;
        border-collapse: collapse;
        background: #fff;
        box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
    }

    .data-table th,
    .data-table td {
        padding: 12px;
        border-bottom: 1px solid #eee;
    }

    .data-table th {
        background: #e87532;
        color: white;
        white-space: nowrap;
    }

    .actions a {
        text-decoration: none;
        padding: 5px 10px;
        margin: 0 2px;
        border-radius: 3px;
        color: #fff;
        display: inline-block;
    }

    .actions a:first-child {
        background: #2ecc71;
    }

    .actions a:nth-child(2) {
        background: #e67e22;
    }

    .actions a:last-child {
        background: #e74c3c;
    }

    @media (max-width: 768px) {
        .header-container {
            flex-direction: column;
            align-items: flex-start;
            gap: 10px;
        }

        .info-table th,
        .info-table td {
            display: block;
            width: 100%;
        }

        .info-table th {
            background: #f0f0f0;
        }

        .data-table {
            display: block;
            overflow-x: auto;
            white-space: nowrap;
        }

        .actions {
            display: flex;
            flex-wrap: wrap;
            gap: 5px;
        }
    }
</style>
