<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Volunteer $volunteer
 * @var string[]|\Cake\Collection\CollectionInterface $volunteerStatuses
 * @var string[]|\Cake\Collection\CollectionInterface $programs
 */
?>
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="row">
        <!-- Form Card -->
        <div class="col-12">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Edit Volunteer</h5>
                    <div>
                        <?= $this->Html->link(
                            '<i class="bx bx-arrow-back me-1"></i> Back to Volunteers',
                            ['action' => 'index'],
                            ['class' => 'btn btn-secondary btn-sm', 'escape' => false]
                        ) ?>
                        <?= $this->Form->postLink(
                            '<i class="bx bx-trash me-1"></i> Delete Volunteer',
                            ['action' => 'delete', $volunteer->id],
                            [
                                'confirm' => __('Are you sure you want to delete # {0}?', $volunteer->id),
                                'class' => 'btn btn-danger btn-sm ms-2',
                                'escape' => false
                            ]
                        ) ?>
                    </div>
                </div>
                <div class="card-body">
                    <?= $this->Form->create($volunteer, ['class' => 'row g-3']) ?>

                    <!-- Personal Information -->
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="first-name">First Name *</label>
                            <?= $this->Form->control('first_name', [
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter first name',
                                'required' => true,
                                'maxlength' => 50,
                                'id' => 'first-name'
                            ]) ?>
                            <div id="first-name-counter" style="margin-top: 5px; font-size: 0.9rem; color: #555;">Characters: 0/50</div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="last-name">Last Name *</label>
                            <?= $this->Form->control('last_name', [
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter last name',
                                'required' => true,
                                'maxlength' => 50,
                                'id' => 'last-name'
                            ]) ?>
                            <div id="last-name-counter" style="margin-top: 5px; font-size: 0.9rem; color: #555;">Characters: 0/50</div>
                        </div>
                    </div>

                    <!-- Contact Information -->
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="email">Email *</label>
                            <?= $this->Form->control('email', [
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter email address',
                                'type' => 'email',
                                'required' => true,
                                'maxlength' => 100,
                                'id' => 'email'
                            ]) ?>
                            <div id="email-counter" style="margin-top: 5px; font-size: 0.9rem; color: #555;">Characters: 0/100</div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="phone">Phone</label>
                            <?= $this->Form->control('phone', [
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter phone number',
                                'maxlength' => 15,
                                'id' => 'phone'
                            ]) ?>
                            <div id="phone-counter" style="margin-top: 5px; font-size: 0.9rem; color: #555;">Characters: 0/15</div>
                        </div>
                    </div>

                    <!-- Additional Information -->
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="postcode">Postcode</label>
                            <?= $this->Form->control('postcode', [
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter postcode',
                                'maxlength' => 10,
                                'id' => 'postcode'
                            ]) ?>
                            <div id="postcode-counter" style="margin-top: 5px; font-size: 0.9rem; color: #555;">Characters: 0/10</div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="occupation">Occupation</label>
                            <?= $this->Form->control('occupation', [
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter occupation',
                                'maxlength' => 100,
                                'id' => 'occupation'
                            ]) ?>
                            <div id="occupation-counter" style="margin-top: 5px; font-size: 0.9rem; color: #555;">Characters: 0/100</div>
                        </div>
                    </div>

                    <div class="col-12">
                        <div class="form-group mb-3">
                            <label class="form-label" for="description">Description</label>
                            <?= $this->Form->control('description', [
                                'class' => 'form-control',
                                'label' => false,
                                'placeholder' => 'Enter description',
                                'rows' => 3,
                                'maxlength' => 500,
                                'id' => 'description'
                            ]) ?>
                            <div id="description-counter" style="margin-top: 5px; font-size: 0.9rem; color: #555;">Characters: 0/500</div>
                        </div>
                    </div>

                    <!-- Status -->
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label class="form-label" for="volunteer-status-id">Volunteer Status *</label>
                            <?= $this->Form->control('volunteer_status_id', [
                                'options' => $volunteerStatuses,
                                'empty' => '-- Select Status --',
                                'class' => 'form-select',
                                'label' => false,
                                'required' => true
                            ]) ?>
                        </div>
                    </div>

                    <div class="col-12">
                        <hr class="my-4">
                        <?= $this->Form->button(__('Save Changes'), [
                            'class' => 'btn btn-primary me-2'
                        ]) ?>
                        <?= $this->Html->link(
                            __('Cancel'),
                            ['action' => 'index'],
                            ['class' => 'btn btn-outline-secondary']
                        ) ?>
                    </div>
                    <?= $this->Form->end() ?>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Get references to input fields and counters
        const firstNameInput = document.getElementById('first-name');
        const lastNameInput = document.getElementById('last-name');
        const emailInput = document.getElementById('email');
        const phoneInput = document.getElementById('phone');
        const postcodeInput = document.getElementById('postcode');
        const occupationInput = document.getElementById('occupation');
        const descriptionInput = document.getElementById('description');

        const firstNameCounter = document.getElementById('first-name-counter');
        const lastNameCounter = document.getElementById('last-name-counter');
        const emailCounter = document.getElementById('email-counter');
        const phoneCounter = document.getElementById('phone-counter');
        const postcodeCounter = document.getElementById('postcode-counter');
        const occupationCounter = document.getElementById('occupation-counter');
        const descriptionCounter = document.getElementById('description-counter');

        // Validation functions for each field
        function validateName(input, maxLength) {
            // Allow letters, spaces, periods, commas, quotes, hyphens (same as certificate recipient name)
            let sanitized = input.replace(/[^a-zA-Z .,\'"-]/g, '');
            if (sanitized.length > maxLength) {
                sanitized = sanitized.substring(0, maxLength);
            }
            return sanitized;
        }

        function validateEmail(input, maxLength) {
            // Allow standard email characters (letters, numbers, @, dots, etc.)
            let sanitized = input.replace(/[^a-zA-Z0-9@._-]/g, '');
            if (sanitized.length > maxLength) {
                sanitized = sanitized.substring(0, maxLength);
            }
            return sanitized;
        }

        function validatePhone(input, maxLength) {
            // Allow numbers, spaces, hyphens, parentheses
            let sanitized = input.replace(/[^0-9 ()-]/g, '');
            if (sanitized.length > maxLength) {
                sanitized = sanitized.substring(0, maxLength);
            }
            return sanitized;
        }

        function validatePostcode(input, maxLength) {
            // Allow letters, numbers, spaces, hyphens
            let sanitized = input.replace(/[^a-zA-Z0-9 -]/g, '');
            if (sanitized.length > maxLength) {
                sanitized = sanitized.substring(0, maxLength);
            }
            return sanitized;
        }

        function validateText(input, maxLength) {
            // Allow letters, numbers, spaces, periods, commas, quotes, hyphens (same as certificate custom text)
            let sanitized = input.replace(/[^a-zA-Z0-9 .,\'"-]/g, '');
            if (sanitized.length > maxLength) {
                sanitized = sanitized.substring(0, maxLength);
            }
            return sanitized;
        }

        // Update counter functions
        function updateFirstNameCounter() {
            firstNameInput.value = validateName(firstNameInput.value, 50);
            const charCount = firstNameInput.value.length;
            firstNameCounter.textContent = `Characters: ${charCount}/50${charCount === 50 ? ' (Maximum reached)' : ''}`;
            firstNameCounter.style.color = charCount === 50 ? 'red' : '#555';
        }

        function updateLastNameCounter() {
            lastNameInput.value = validateName(lastNameInput.value, 50);
            const charCount = lastNameInput.value.length;
            lastNameCounter.textContent = `Characters: ${charCount}/50${charCount === 50 ? ' (Maximum reached)' : ''}`;
            lastNameCounter.style.color = charCount === 50 ? 'red' : '#555';
        }

        function updateEmailCounter() {
            emailInput.value = validateEmail(emailInput.value, 100);
            const charCount = emailInput.value.length;
            emailCounter.textContent = `Characters: ${charCount}/100${charCount === 100 ? ' (Maximum reached)' : ''}`;
            emailCounter.style.color = charCount === 100 ? 'red' : '#555';
        }

        function updatePhoneCounter() {
            phoneInput.value = validatePhone(phoneInput.value, 15);
            const charCount = phoneInput.value.length;
            phoneCounter.textContent = `Characters: ${charCount}/15${charCount === 15 ? ' (Maximum reached)' : ''}`;
            phoneCounter.style.color = charCount === 15 ? 'red' : '#555';
        }

        function updatePostcodeCounter() {
            postcodeInput.value = validatePostcode(postcodeInput.value, 10);
            const charCount = postcodeInput.value.length;
            postcodeCounter.textContent = `Characters: ${charCount}/10${charCount === 10 ? ' (Maximum reached)' : ''}`;
            postcodeCounter.style.color = charCount === 10 ? 'red' : '#555';
        }

        function updateOccupationCounter() {
            occupationInput.value = validateText(occupationInput.value, 100);
            const charCount = occupationInput.value.length;
            occupationCounter.textContent = `Characters: ${charCount}/100${charCount === 100 ? ' (Maximum reached)' : ''}`;
            occupationCounter.style.color = charCount === 100 ? 'red' : '#555';
        }

        function updateDescriptionCounter() {
            descriptionInput.value = validateText(descriptionInput.value, 500);
            const charCount = descriptionInput.value.length;
            descriptionCounter.textContent = `Characters: ${charCount}/500${charCount === 500 ? ' (Maximum reached)' : ''}`;
            descriptionCounter.style.color = charCount === 500 ? 'red' : '#555';
        }

        // Initialize counters on page load
        updateFirstNameCounter();
        updateLastNameCounter();
        updateEmailCounter();
        updatePhoneCounter();
        updatePostcodeCounter();
        updateOccupationCounter();
        updateDescriptionCounter();

        // Attach event listeners for real-time updates
        firstNameInput.addEventListener('input', updateFirstNameCounter);
        lastNameInput.addEventListener('input', updateLastNameCounter);
        emailInput.addEventListener('input', updateEmailCounter);
        phoneInput.addEventListener('input', updatePhoneCounter);
        postcodeInput.addEventListener('input', updatePostcodeCounter);
        occupationInput.addEventListener('input', updateOccupationCounter);
        descriptionInput.addEventListener('input', updateDescriptionCounter);
    });
</script>
