<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Volunteer> $volunteers
 */
?>
<!-- Content -->
<div class="container-xxl flex-grow-2 container-p-y">
    <!-- Render flash messages -->
    <?= $this->Flash->render() ?>

    <!-- Upload Modal -->
    <div class="modal fade" id="uploadModal" tabindex="-1" aria-labelledby="uploadModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content" style="border-radius: var(--radius); box-shadow: 0 12px 40px var(--shadow);">
                <div class="modal-header" style="border-bottom: 1px solid var(--grey-light);">
                    <h5 class="modal-title" id="uploadModalLabel" style="color: var(--orange-dark); font-weight: 700;">Upload File</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <?= $this->Form->create(null, ['type' => 'file', 'url' => ['action' => 'upload'], 'id' => 'uploadForm']) ?>
                    <div class="mb-3">
                        <label for="fileInput" class="form-label" style="color: var(--grey-dark);">Select Excel File</label>
                        <?= $this->Form->file('uploaded_file', [
                            'class' => 'form-control',
                            'id' => 'fileInput',
                            'required' => true,
                            'accept' => '.csv',
                            'style' => 'border: 1px solid var(--grey-light); border-radius: var(--radius-sm);'
                        ]) ?>
                        <small class="form-text text-muted">Accepted formats: <span style="color: var(--orange);">.csv</span> only</small>
                    </div>
                    <div class="mb-3">
                        <label class="form-label" style="color: var(--grey-dark);">Sample Data Format</label>
                        <div class="image-container">
                            <img src="<?= $this->Url->build('/img/volunteerdample.png') ?>" alt="Volunteer Image" class="img-fluid" style="border-radius: var(--radius-sm);">
                        </div>
                    </div>
                </div>
                <div class="modal-footer" style="border-top: 1px solid var(--grey-light);">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" style="border-radius: var(--radius-sm); color: var(--grey-dark); background: var(--grey-light); border: none;">Cancel</button>
                    <?= $this->Form->button('Upload', [
                        'type' => 'submit',
                        'class' => 'btn btn-primary',
                        'id' => 'uploadButton',
                        'style' => 'background: var(--orange); border: none; border-radius: var(--radius-sm); color: #fff; font-weight: 700; padding: 10px 25px; transition: var(--transition);'
                    ]) ?>
                    <?= $this->Form->end() ?>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-xl">
            <div class="card mb-4" style="border-radius: var(--radius); box-shadow: 0 12px 40px var(--shadow); background: #fff; position: relative; overflow: hidden;">
                <div class="card-header d-flex justify-content-between align-items-center" style="border-bottom: 1px solid var(--grey-light); padding: calc(var(--spacing) * 1.5);">
                    <h3 style="color: var(--orange-dark); font-weight: 700; font-family: 'Poppins', sans-serif;">Volunteers</h3>
                    <div>
                        <?= $this->Html->link(
                            'Export CSV',
                            ['action' => 'overview'],
                            ['class' => 'btn btn-outline-primary me-2', 'style' => 'border: 2px solid var(--blue); color: var(--blue); border-radius: var(--radius-sm); font-weight: 600; transition: var(--transition);']
                        ) ?>
                        <?= $this->Html->link(
                            'Upload File',
                            '#',
                            [
                                'class' => 'btn btn-primary me-2',
                                'data-bs-toggle' => 'modal',
                                'data-bs-target' => '#uploadModal',
                                'style' => 'background: var(--orange); border: none; border-radius: var(--radius-sm); color: #fff; font-weight: 700; padding: 10px 25px; transition: var(--transition);'
                            ]
                        ) ?>
                        <?= $this->Html->link(('Add Volunteer'), ['action' => 'add'], ['class' => 'btn btn-primary', 'style' => 'background: var(--orange); border: none; border-radius: var(--radius-sm); color: #fff; font-weight: 700; padding: 10px 25px; transition: var(--transition);']) ?>
                    </div>
                </div>
                <div class="card-body" style="padding: calc(var(--spacing) * 1.5);">
                    <div class="d-flex justify-content-end mb-4">
                        <?= $this->Form->create(null, ['type' => 'get']) ?>
                        <div class="input-group mb-3" style="max-width: 400px;">
                            <?= $this->Form->control('search', [
                                'label' => false,
                                'value' => $this->request->getQuery('search'),
                                'class' => 'form-control',
                                'placeholder' => 'Search name, email or status',
                                'type' => 'text',
                                'style' => 'width: 100%; border: 1px solid var(--grey-light); border-radius: var(--radius-sm); color: var(--grey-dark);'
                            ]) ?>
                            <?= $this->Form->button('Search', [
                                'class' => 'btn btn-primary',
                                'style' => 'margin-left: 8px; background: var(--orange); border: none; border-radius: var(--radius-sm); color: #fff; font-weight: 700; transition: var(--transition);'
                            ]) ?>
                        </div>
                        <?= $this->Form->end() ?>
                    </div>
                    <div class="table-responsive text-nowrap">
                        <table class="table table-striped" style="background: #fff; border-radius: var(--radius-sm);">
                            <thead style="background: var(--grey-lighter);">
                            <tr>
                                <th style="color: var(--orange-dark); font-weight: 700;"><?= $this->Paginator->sort('name') ?></th>
                                <th style="color: var(--orange-dark); font-weight: 700;"><?= $this->Paginator->sort('email') ?></th>
                                <th style="color: var(--orange-dark); font-weight: 700;"><?= $this->Paginator->sort('phone') ?></th>
                                <th style="color: var(--orange-dark); font-weight: 700;"><?= $this->Paginator->sort('postcode') ?></th>
                                <th style="color: var(--orange-dark); font-weight: 700;"><?= $this->Paginator->sort('occupation') ?></th>
                                <th style="color: var(--orange-dark); font-weight: 700;"><?= $this->Paginator->sort('volunteer_status_id', 'Status') ?></th>
<!--                                <th style="color: var(--orange-dark); font-weight: 700;">Action</th>-->
                            </tr>
                            </thead>
                            <tbody class="table-border-bottom-0">
                            <?php foreach ($volunteers as $volunteer): ?>
                                <tr data-edit-url="<?= $this->Url->build(['controller' => 'Volunteers', 'action' => 'edit', $volunteer->id]) ?>" class="clickable-row" style="transition: var(--transition);">
                                    <td style="color: var(--grey-dark);"><?= h($volunteer->first_name . ' ' . $volunteer->last_name) ?></td>
                                    <td>
                                        <a href="mailto:<?= h($volunteer->email) ?>" style="text-decoration: underline; color: var(--orange); transition: var(--transition);">
                                            <?= h($volunteer->email) ?>
                                        </a>
                                    </td>
                                    <td>
                                        <a href="tel:<?= h($volunteer->phone) ?>" style="text-decoration: underline; color: var(--orange); transition: var(--transition);">
                                            <?= h($volunteer->phone) ?>
                                        </a>
                                    </td>
                                    <td style="color: var(--grey-dark);"><?= h($volunteer->postcode) ?></td>
                                    <td style="color: var(--grey-dark);"><?= h($volunteer->occupation) ?></td>
                                    <td>
                                        <?php if ($volunteer->hasValue('volunteer_status')): ?>
                                            <span class="badge bg-label-primary" style="background: var(--blue); color: #fff; border-radius: var(--radius-sm); font-weight: 600;">
                                                <?= $volunteer->volunteer_status->name ?>
                                            </span>
                                        <?php endif; ?>
                                    </td>
<!--                                    <td>-->
<!--                                        --><?php //= $this->Html->link('Generate Certificate', [
//                                            'controller' => 'Certificate',
//                                            'action' => 'editor',
//                                            $volunteer->id
//                                        ], ['class' => 'btn btn-primary', 'style' => 'background: var(--orange); border: none; border-radius: var(--radius-sm); color: #fff; font-weight: 600; transition: var(--transition);']) ?>
<!--                                    </td>-->
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-4">
                        <nav aria-label="Page navigation">
                            <ul class="pagination justify-content-center">
                                <?= $this->Paginator->first('<i class="fas fa-chevron-double-left"></i>', ['escape' => false, 'class' => 'page-item', 'style' => 'color: var(--blue);']) ?>
                                <?= $this->Paginator->prev('<i class="fas fa-chevron-left"></i>', ['escape' => false, 'class' => 'page-item', 'style' => 'color: var(--blue);']) ?>
                                <?php
                                $this->Paginator->setTemplates([
                                    'number' => '<li class="page-item"><a class="page-link" href="{{url}}" style="color: var(--blue);">{{text}}</a></li>',
                                    'current' => '<li class="page-item active"><a class="page-link" href="#" style="background: var(--orange); border-color: var(--orange); color: #fff;">{{text}}</a></li>',
                                ]);
                                echo $this->Paginator->numbers();
                                ?>
                                <?= $this->Paginator->next('<i class="fas fa-chevron-right"></i>', ['escape' => false, 'class' => 'page-item', 'style' => 'color: var(--blue);']) ?>
                                <?= $this->Paginator->last('<i class="fas fa-chevron-double-right"></i>', ['escape' => false, 'class' => 'page-item', 'style' => 'color: var(--blue);']) ?>
                            </ul>
                        </nav>
                        <div class="text-center text-muted mt-2" style="color: var(--grey);">
                            <?= $this->Paginator->counter(('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    :root {
        --orange: #E87533;
        --orange-light: #FFA563;
        --orange-dark: #D05F20;
        --blue: #3E88F2;
        --blue-light: #70A8FF;
        --green: #2EA876;
        --grey-light: #f5f5f5;
        --grey-lighter: #fafafa;
        --grey: #78716c;
        --grey-dark: #4B4945;
        --radius: 20px;
        --radius-sm: 12px;
        --spacing: 30px;
        --shadow: rgba(0,0,0,0.1);
        --shadow-hover: rgba(0,0,0,0.2);
        --transition: all 0.4s cubic-bezier(0.22, 1, 0.36, 1);
    }

    body {
        font-family: "Inter", system-ui, sans-serif;
        background: var(--grey-lighter);
        color: #333;
        line-height: 1.6;
    }

    .container-xxl {
        max-width: 1400px;
        margin: 0 auto;
        padding: var(--spacing);
    }

    .card::before {
        content: "";
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 8px;
        background: linear-gradient(90deg, var(--orange-light), var(--blue));
    }

    .btn-primary:hover, .btn-outline-primary:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 30px rgba(232, 117, 51, 0.35);
    }

    .btn-outline-primary:hover {
        background: var(--blue);
        color: #fff;
    }

    .btn-primary:hover {
        background: var(--orange-dark);
    }

    .table-striped tbody tr:hover {
        background: var(--grey-light);
        transform: scale(1.02);
        box-shadow: 0 4px 15px rgba(0,0,0,0.05);
    }

    .pagination .page-link:hover {
        background: var(--orange-light);
        color: #fff;
    }

    .download-container {
        text-align: center;
        margin: 20px;
    }

    .download-link {
        display: inline-block;
        padding: 12px 20px;
        background: var(--orange);
        color: #fff;
        font-size: 16px;
        font-weight: 700;
        text-decoration: none;
        border-radius: var(--radius-sm);
        transition: var(--transition);
        box-shadow: 0 8px 25px rgba(232, 117, 51, 0.25);
    }

    .download-link:hover {
        background: var(--orange-dark);
        color: #fff;
        transform: translateY(-5px);
        box-shadow: 0 10px 30px rgba(232, 117, 51, 0.35);
    }

    .download-icon {
        margin-right: 8px;
    }
</style>

<style>
@media (max-width: 768px) {
    .container-xxl {
        padding: 15px;
    }

    .card-header {
        flex-direction: column;
        align-items: flex-start;
        gap: 10px;
    }

    .input-group.mb-3 {
        flex-direction: column;
        width: 100%;
    }

    .input-group.mb-3 input,
    .input-group.mb-3 button {
        width: 100% !important;
        margin-top: 8px;
    }

    .table-responsive {
        overflow-x: auto;
    }

    .pagination .page-item {
        font-size: 14px;
    }

    .modal-dialog {
        max-width: 100%;
        margin: 0 10px;
    }

    .card-body .d-flex {
        flex-direction: column;
        align-items: stretch;
    }
}
</style>

<!-- Add JavaScript at the bottom -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.11.5/gsap.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const uploadForm = document.getElementById('uploadForm');
        const uploadModal = new bootstrap.Modal(document.getElementById('uploadModal'));

        uploadForm.addEventListener('submit', function (event) {
            setTimeout(() => {
                uploadModal.hide();
            }, 500);
        });

        const tbody = document.querySelector('tbody');
        tbody.addEventListener('click', function(event) {
            const row = event.target.closest('.clickable-row');
            if (row) {
                const editUrl = row.getAttribute('data-edit-url');
                if (editUrl) {
                    window.location.href = editUrl;
                }
            }
        });

        // Table animation
        gsap.from('.table', {
            opacity: 0,
            y: 50,
            duration: 1,
            ease: 'power3.out'
        });
    });
</script>
