<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Donation> $donations
 */
?>
<!-- Content -->
<div class="container-xxl flex-grow-2 container-p-y">
    <!-- Render flash messages -->
    <?= $this->Flash->render() ?>

    <!-- Upload Modal -->
    <div class="modal fade" id="uploadModal" tabindex="-1" aria-labelledby="uploadModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content" style="border-radius: var(--radius); box-shadow: 0 12px 40px var(--shadow);">
                <div class="modal-header" style="border-bottom: 1px solid var(--grey-light);">
                    <h5 class="modal-title" id="uploadModalLabel" style="color: var(--orange-dark); font-weight: 700;">Upload Donation File</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <?= $this->Form->create(null, ['type' => 'file', 'url' => ['action' => 'upload'], 'id' => 'uploadForm']) ?>
                    <div class="mb-3">
                        <label for="fileInput" class="form-label" style="color: var(--grey-dark);">Select CSV File</label>
                        <?= $this->Form->file('uploaded_file', [
                            'class' => 'form-control',
                            'id' => 'fileInput',
                            'required' => true,
                            'accept' => '.csv',
                            'style' => 'border: 1px solid var(--grey-light); border-radius: var(--radius-sm);'
                        ]) ?>
                        <small class="form-text text-muted">Accepted formats: <span style="color: var(--orange);">.csv</span> only</small>
                    </div>
                    <div class="mb-3">
                        <label class="form-label" style="color: var(--grey-dark);">Sample Data Format</label>
                        <div class="image-container">
                            <img src="<?= $this->Url->build('/img/donation_sample.png') ?>" alt="Donation Sample Image" class="img-fluid" style="border-radius: var(--radius-sm);">
                        </div>
                    </div>
                </div>
                <div class="modal-footer" style="border-top: 1px solid var(--grey-light);">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" style="border-radius: var(--radius-sm); color: var(--grey-dark); background: var(--grey-light); border: none;">Cancel</button>
                    <?= $this->Form->button('Upload', [
                        'type' => 'submit',
                        'class' => 'btn btn-primary',
                        'id' => 'uploadButton',
                        'style' => 'background: var(--orange); border: none; border-radius: var(--radius-sm); color: #fff; font-weight: 700; padding: 10px 25px; transition: var(--transition);'
                    ]) ?>
                    <?= $this->Form->end() ?>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-xl">
            <div class="card mb-4" style="border-radius: var(--radius); box-shadow: 0 12px 40px var(--shadow); background: #fff; position: relative; overflow: hidden;">
                <div class="card-header d-flex justify-content-between align-items-center" style="border-bottom: 1px solid var(--grey-light); padding: calc(var(--spacing) * 1.5);">
                    <h3 style="color: var(--orange-dark); font-weight: 700; font-family: 'Poppins', sans-serif;">Donations</h3>
                </div>
                <div class="card-body" style="padding: calc(var(--spacing) * 1.5);">
                    <div class="mb-4 total-donations" style="background: linear-gradient(145deg, var(--orange-light) 0%, var(--blue-light) 100%); border-radius: var(--radius); padding: calc(var(--spacing) * 1.5); box-shadow: 0 8px 25px rgba(232, 117, 51, 0.2); position: relative; overflow: hidden;">
                        <h5 class="total-donations-text" style="color: #fff; font-size: 2.2rem; font-weight: 800; font-family: 'Poppins', sans-serif; display: flex; align-items: center; justify-content: center; gap: 15px; text-shadow: 0 3px 10px rgba(0,0,0,0.2); transition: var(--transition);">
                            <i class="fas fa-hand-holding-heart" style="color: var(--orange-dark);"></i>
                            Total Donations:
                            <?php
                            $totalAmount = $totalAmount ?? 0;
                            ?>
                            $<span id="donation-counter" data-target="<?= $totalAmount ?>"><?= number_format($totalAmount, 2) ?></span>
                            <?php if (!empty($this->request->getQuery('search'))): ?>
                                <span style="font-size: 1rem; font-weight: 500; margin-left: 10px;">
                                    (filtered by "<?= h($this->request->getQuery('search')) ?>")
                                </span>
                            <?php endif; ?>
                        </h5>
                        <div class="counter-animation" id="counter-float"></div>
                        <ul style="margin-top: 15px; padding-left: 20px; color: #fff; font-size: 1.1rem;">
                            <?php
                            $campaignTotals = [];
                            foreach ($donations as $donation) {
                                if ($donation->campaign && $donation->campaign->title) {
                                    $title = $donation->campaign->title;
                                    if (!isset($campaignTotals[$title])) {
                                        $campaignTotals[$title] = 0;
                                    }
                                    $campaignTotals[$title] += $donation->amount;
                                }
                            }
                            foreach ($campaignTotals as $title => $amount): ?>
                                <li><?= h($title) ?>: $<?= number_format($amount, 2) ?></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                    <div class="d-flex justify-content-end mb-4">
                        <?= $this->Form->create(null, ['type' => 'get']) ?>
                        <div class="input-group mb-3" style="max-width: 400px;">
                            <?= $this->Form->control('search', [
                                'label' => false,
                                'value' => $this->request->getQuery('search'),
                                'class' => 'form-control',
                                'placeholder' => 'Search name, email or transaction ID',
                                'type' => 'text',
                                'style' => 'width: 100%; border: 1px solid var(--grey-light); border-radius: var(--radius-sm); color: var(--grey-dark);'
                            ]) ?>
                            <?= $this->Form->button('Search', [
                                'class' => 'btn btn-primary',
                                'style' => 'margin-left: 8px; background: var(--orange); border: none; border-radius: var(--radius-sm); color: #fff; font-weight: 700; transition: var(--transition);'
                            ]) ?>
                        </div>
                        <?= $this->Form->end() ?>
                    </div>
                    <div class="table-responsive text-nowrap">
                        <?= $this->Form->create(null, ['url' => ['action' => 'bulkDelete'], 'id' => 'bulkDeleteForm']) ?>
                        <table class="table table-striped" style="background: #fff; border-radius: var(--radius-sm);">
                            <thead style="background: var(--grey-lighter);">
                            <tr>
                                <th><input type="checkbox" id="select-all-donations"></th>
                                <th style="color: var(--orange-dark); font-weight: 700;"><?= $this->Paginator->sort('id') ?></th>
                                <th style="color: var(--orange-dark); font-weight: 700;"><?= $this->Paginator->sort('amount') ?></th>
                                <th style="color: var(--orange-dark); font-weight: 700;"><?= $this->Paginator->sort('campaign_id', 'Campaign') ?></th>
                                <th style="color: var(--orange-dark); font-weight: 700;"><?= $this->Paginator->sort('donor_email') ?></th>
                                <th style="color: var(--orange-dark); font-weight: 700;"><?= $this->Paginator->sort('donor_name') ?></th>
                                <th style="color: var(--orange-dark); font-weight: 700;"><?= $this->Paginator->sort('stripe_transaction_id', 'Transaction ID') ?></th>
                                <th style="color: var(--orange-dark); font-weight: 700;"><?= $this->Paginator->sort('status') ?></th>
                                <th style="color: var(--orange-dark); font-weight: 700;"><?= $this->Paginator->sort('created') ?></th>
                                <th class="actions" style="color: var(--orange-dark); font-weight: 700;"><?= __('Actions') ?></th>
                            </tr>
                            </thead>
                            <tbody class="table-border-bottom-0">
                            <?php foreach ($donations as $donation): ?>
                                <tr style="transition: var(--transition);">
                                    <td>
                                        <input type="checkbox" name="selected_ids[]" value="<?= $donation->id ?>" class="donation-checkbox">
                                    </td>
                                    <td style="color: var(--grey-dark);"><?= $this->Number->format($donation->id) ?></td>
                                    <td style="color: var(--grey-dark);">$<?= number_format($donation->amount, 2) ?></td>
                                    <td style="color: var(--grey-dark);"><?= h($donation->campaign->title ?? '—') ?></td>
                                    <td>
                                        <a href="mailto:<?= h($donation->donor_email) ?>" style="text-decoration: underline; color: var(--orange); transition: var(--transition);">
                                            <?= h($donation->donor_email) ?>
                                        </a>
                                    </td>
                                    <td style="color: var(--grey-dark);"><?= h($donation->donor_name ?? '—') ?></td>
                                    <td style="color: var(--grey-dark);"><?= h($donation->stripe_transaction_id) ?></td>
                                    <td>
                                        <span class="badge bg-label-primary" style="background: var(--blue); color: #fff; border-radius: var(--radius-sm); font-weight: 600;">
                                            <?= h($donation->status) ?>
                                        </span>
                                    </td>
                                    <td style="color: var(--grey-dark);"><?= h($donation->created->format('Y-m-d H:i:s')) ?></td>
                                    <td class="actions">
                                        <?= $this->Html->link(__('View'), ['action' => 'view', $donation->id], ['class' => 'btn btn-info btn-sm', 'style' => 'background: var(--blue); border: none; border-radius: var(--radius-sm); color: #fff; font-weight: 600; transition: var(--transition);']) ?>
                                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $donation->id], [
                                            'confirm' => __('Are you sure you want to delete donation #{0}?', $donation->id),
                                            'class' => 'btn btn-danger btn-sm',
                                            'style' => 'background: var(--orange-dark); border: none; border-radius: var(--radius-sm); color: #fff; font-weight: 600; transition: var(--transition);'
                                        ]) ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                        <div class="mt-3 text-end">
                            <button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete the selected donations?')">
                                Delete Selected
                            </button>
                        </div>
                        <?= $this->Form->end() ?>
                    </div>
                    <div class="mt-4">
                        <nav aria-label="Page navigation">
                            <ul class="pagination justify-content-center">
                                <?= $this->Paginator->first('<i class="fas fa-chevron-double-left"></i>', ['escape' => false, 'class' => 'page-item', 'style' => 'color: var(--blue);']) ?>
                                <?= $this->Paginator->prev('<i class="fas fa-chevron-left"></i>', ['escape' => false, 'class' => 'page-item', 'style' => 'color: var(--blue);']) ?>
                                <?php
                                $this->Paginator->setTemplates([
                                    'number' => '<li class="page-item"><a class="page-link" href="{{url}}" style="color: var(--blue);">{{text}}</a></li>',
                                    'current' => '<li class="page-item active"><a class="page-link" href="#" style="background: var(--orange); border-color: var(--orange); color: #fff;">{{text}}</a></li>',
                                ]);
                                echo $this->Paginator->numbers();
                                ?>
                                <?= $this->Paginator->next('<i class="fas fa-chevron-right"></i>', ['escape' => false, 'class' => 'page-item', 'style' => 'color: var(--blue);']) ?>
                                <?= $this->Paginator->last('<i class="fas fa-chevron-double-right"></i>', ['escape' => false, 'class' => 'page-item', 'style' => 'color: var(--blue);']) ?>
                            </ul>
                        </nav>
                        <div class="text-center text-muted mt-2" style="color: var(--grey);">
                            <?= $this->Paginator->counter(('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    :root {
        --orange: #E87533;
        --orange-light: #FFA563;
        --orange-dark: #D05F20;
        --blue: #3E88F2;
        --blue-light: #70A8FF;
        --green: #2EA876;
        --grey-light: #f5f5f5;
        --grey-lighter: #fafafa;
        --grey: #78716c;
        --grey-dark: #4B4945;
        --radius: 20px;
        --radius-sm: 12px;
        --spacing: 30px;
        --shadow: rgba(0,0,0,0.1);
        --shadow-hover: rgba(0,0,0,0.2);
        --transition: all 0.4s cubic-bezier(0.22, 1, 0.36, 1);
    }

    body {
        font-family: "Inter", system-ui, sans-serif;
        background: var(--grey-lighter);
        color: #333;
        line-height: 1.6;
    }

    .container-xxl {
        max-width: 1400px;
        margin: 0 auto;
        padding: var(--spacing);
    }

    .card::before {
        content: "";
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 8px;
        background: linear-gradient(90deg, var(--orange-light), var(--blue));
    }

    .btn-primary:hover, .btn-outline-primary:hover, .btn-info:hover, .btn-danger:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 30px rgba(232, 117, 51, 0.35);
    }

    .btn-outline-primary:hover {
        background: var(--blue);
        color: #fff;
    }

    .btn-info:hover {
        background: var(--blue-light);
    }

    .btn-danger:hover {
        background: #b54a1a;
    }

    /* .table-striped tbody tr:hover {
        background: var(--grey-light);
        transform: scale(1.02);
        box-shadow: 0 4px 15px rgba(0,0,0,0.05);
    } */

    .pagination .page-link:hover {
        background: var(--orange-light);
        color: #fff;
    }

    .total-donations::before {
        content: '';
        position: absolute;
        inset: 0;
        background: url('data:image/svg+xml;utf8,<svg width="60" height="60" viewBox="0 0 60 60" xmlns="http://www.w3.org/2000/svg"><path d="M30 0 L60 30 L30 60 L0 30 Z" fill="none" stroke="rgba(255,255,255,0.2)" stroke-width="1.5"/></svg>');
        background-size: 60px 60px;
        opacity: 0.25;
        animation: patternDrift 25s linear infinite;
    }

    .total-donations-text:hover {
        transform: scale(1.05) translateY(-5px);
        box-shadow: 0 10px 30px rgba(232, 117, 51, 0.35);
        background: rgba(255, 255, 255, 0.1);
        border-radius: var(--radius-sm);
        padding: 10px 20px;
    }

    .download-container {
        text-align: center;
        margin: 20px;
    }

    .download-link {
        display: inline-block;
        padding: 12px 20px;
        background: var(--orange);
        color: #fff;
        font-size: 16px;
        font-weight: 700;
        text-decoration: none;
        border-radius: var(--radius-sm);
        transition: var(--transition);
        box-shadow: 0 8px 25px rgba(232, 117, 51, 0.25);
    }

    .download-link:hover {
        background: var(--orange-dark);
        color: #fff;
        transform: translateY(-5px);
        box-shadow: 0 10px 30px rgba(232, 117, 51, 0.35);
    }

    .download-icon {
        margin-right: 8px;
    }

    .counter-animation {
        position: absolute;
        top: -50px;
        left: 50%;
        transform: translateX(-50%);
        font-size: 1.6rem;
        color: var(--green);
        font-weight: 700;
        animation: riseFade 3s ease forwards;
    }

    @keyframes riseFade {
        0% { opacity: 0; top: 0; }
        20% { opacity: 1; }
        100% { opacity: 0; top: -60px; }
    }

    @keyframes patternDrift {
        0% { background-position: 0 0; }
        100% { background-position: 60px 60px; }
    }

    @keyframes pulse {
        0% { transform: scale(1); }
        50% { transform: scale(1.03); }
        100% { transform: scale(1); }
    }
    @media (max-width: 768px) {
        .container-xxl {
            padding: 15px;
        }

        .card-header {
            flex-direction: column;
            align-items: flex-start;
            gap: 10px;
        }

        .input-group.mb-3 {
            flex-direction: column;
            width: 100%;
        }

        .input-group.mb-3 input,
        .input-group.mb-3 button {
            width: 100% !important;
            margin-top: 8px;
        }

        .table-responsive {
            overflow-x: auto;
        }

        .pagination .page-item {
            font-size: 14px;
        }

        .modal-dialog {
            max-width: 100%;
            margin: 0 10px;
        }

        .card-body .d-flex {
            flex-direction: column;
            align-items: stretch;
        }

        .total-donations-text {
            font-size: 1.5rem;
            flex-direction: column;
            gap: 10px;
            text-align: center;
        }

        .total-donations ul {
            padding-left: 0;
            font-size: 1rem;
            text-align: center;
            list-style-position: inside;
        }
    }
</style>

<!-- Add JavaScript at the bottom -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.11.5/gsap.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const uploadForm = document.getElementById('uploadForm');
        const uploadModal = new bootstrap.Modal(document.getElementById('uploadModal'));

        uploadForm.addEventListener('submit', function (event) {
            setTimeout(() => {
                uploadModal.hide();
            }, 500);
        });

        // Donation Counter Animation
        const counter = document.getElementById('donation-counter');
        const floatEl = document.getElementById('counter-float');
        const totalDonationsText = document.querySelector('.total-donations-text');
        if (counter) {
            const target = parseFloat(counter.dataset.target) || 0;
            gsap.from(totalDonationsText, {
                opacity: 0,
                y: 50,
                duration: 1,
                ease: 'power3.out',
                onStart: () => {
                    totalDonationsText.style.animation = 'pulse 2s ease infinite';
                }
            });
            gsap.to(counter, {
                innerHTML: target,
                duration: 3,
                ease: 'power3.out',
                onUpdate: () => {
                    const currentValue = parseFloat(counter.innerHTML);
                    counter.textContent = currentValue.toLocaleString('en-US', {
                        minimumFractionDigits: 2,
                        maximumFractionDigits: 2
                    });
                },
                onStart: () => {
                    floatEl.textContent = `+ $${target.toLocaleString('en-US', { minimumFractionDigits: 2 })}`;
                    floatEl.classList.add('counter-animation');
                }
            });
        }

        // Bulk select/deselect all checkboxes
        const selectAll = document.getElementById('select-all-donations');
        if (selectAll) {
            selectAll.addEventListener('change', function () {
                document.querySelectorAll('.donation-checkbox').forEach(cb => cb.checked = this.checked);
            });
        }
    });
</script>
