<?php
// templates/layout/default.php
/**
 * Default Layout Template with Navbar/Header
 */
?>
<!DOCTYPE html>
<html>

<head>
    <?= $this->Html->charset() ?>
    <?= $this->Html->meta('viewport', 'width=device-width, initial-scale=1.0') ?>
    <title><?= strip_tags($this->ContentBlock->text('website-name')); ?></title>
    <?= $this->Html->meta('description', '') ?>
    <?= $this->Html->meta('keywords', '') ?>

    <!-- Favicons -->
    <?= $this->Html->meta('icon', 'img/favicon.png', ['pathPrefix' => 'assets/']) ?>
    <?= $this->Html->meta('apple-touch-icon', 'img/apple-touch-icon.png', ['pathPrefix' => 'assets/']) ?>

    <!-- Fonts Preconnect -->
    <?= $this->Html->tag('link', null, ['rel' => 'preconnect', 'href' => 'https://fonts.googleapis.com']) ?>
    <?= $this->Html->tag('link', null, ['rel' => 'preconnect', 'href' => 'https://fonts.gstatic.com', 'crossorigin' => 'anonymous']) ?>
    <!-- Fonts CSS -->
    <?= $this->Html->css('https://fonts.googleapis.com/css2?family=Roboto&family=Noto+Sans&family=Questrial&display=swap') ?>

    <!-- Vendor CSS Files -->
    <?= $this->Html->css([
        'vendor/bootstrap/css/bootstrap.min.css',
        'vendor/bootstrap-icons/bootstrap-icons.css',
        'vendor/aos/aos.css',
        'vendor/glightbox/css/glightbox.min.css',
        'vendor/swiper/swiper-bundle.min.css'
    ], ['pathPrefix' => 'assets/']) ?>

    <!-- Main CSS File -->
    <?= $this->Html->css('main.css', ['pathPrefix' => 'assets/css/']) ?>
</head>

<body class="index-page">
<?= $this->element('header'); ?>
<main class="main">
    <?= $this->Flash->render() ?>
    <?= $this->fetch('content') ?>
</main>
<?= $this->element('footer'); ?>

<!-- Scroll Top -->
<a href="#" id="scroll-top" class="scroll-top d-flex align-items-center justify-content-center">
    <i class="bi bi-arrow-up-short"></i>
</a>

<!-- Vendor JS Files -->
<script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="assets/vendor/php-email-form/validate.js"></script>
<script src="assets/vendor/aos/aos.js"></script>
<script src="assets/vendor/waypoints/noframework.waypoints.js"></script>
<script src="assets/vendor/glightbox/js/glightbox.min.js"></script>
<script src="assets/vendor/imagesloaded/imagesloaded.pkgd.min.js"></script>
<script src="assets/vendor/isotope-layout/isotope.pkgd.min.js"></script>
<script src="assets/vendor/swiper/swiper-bundle.min.js"></script>

<!-- Main JS File -->
<script src="assets/js/main.js"></script>


</body>

</html>

