<?php
/**
 * @var \App\View\AppView $this
 * @var \ContentBlocks\Model\Entity\ContentBlock $contentBlock
 */

$this->assign('title', 'Edit Content Block - Content Blocks');

$this->Html->script('ContentBlocks.ckeditor/ckeditor', ['block' => true]);

$this->Html->css('ContentBlocks.content-blocks', ['block' => true]);
?>

<div class="page-container">
    <div class="row">
        <div class="col-12">
            <div class="card shadow">
                <div class="card-body">
                    <h3 class="content-blocks--form-heading"><?= $contentBlock->label ?></h3>

                    <div class="content-blocks--form-description">
                        <?= $contentBlock->description ?>
                    </div>

                    <?= $this->Form->create($contentBlock, ['type' => 'file']) ?>

                    <?php
                    if ($contentBlock->type === 'text') {
                        echo $this->Form->control('value', [
                            'type' => 'text',
                            'value' => html_entity_decode($contentBlock->value),
                            'label' => false,
                            'class' => 'form-control',
                            'id' => 'value-text'
                        ]);
                    } else if ($contentBlock->type === 'html') {
                        echo $this->Form->control('value', [
                            'type' => 'textarea',
                            'label' => false,
                            'id' => 'content-value-input',
                            'class' => 'form-control'
                        ]);
                        ?>
                        <script>
                            document.addEventListener("DOMContentLoaded", (event) => {
                                CKSource.Editor.create(
                                    document.getElementById('content-value-input'),
                                    {
                                        toolbar: [
                                            "heading", "|",
                                            "bold", "italic", "underline", "|",
                                            "bulletedList", "numberedList", "|",
                                            "alignment", "blockQuote", "|",
                                            "indent", "outdent", "|",
                                            "link", "|",
                                            "insertTable", "imageInsert", "mediaEmbed", "horizontalLine", "|",
                                            "removeFormat", "|",
                                            "sourceEditing", "|",
                                            "undo", "redo",
                                        ],
                                        simpleUpload: {
                                            uploadUrl: <?= json_encode($this->Url->build(['action' => 'upload'])) ?>,
                                            headers: {
                                                'X-CSRF-TOKEN': <?= json_encode($this->request->getAttribute('csrfToken')) ?>,
                                            }
                                        }
                                    }
                                ).then(editor => {
                                    console.log(Array.from(editor.ui.componentFactory.names()));
                                });
                            });
                        </script>
                        <?php
                    } else if ($contentBlock->type === 'image') {
                        if ($contentBlock->value) {
                            echo $this->Html->image($contentBlock->value, ['class' => 'content-blocks--image-preview']);
                        }

                        echo $this->Form->control('value', [
                            'type' => 'file',
                            'accept' => 'image/*',
                            'label' => false,
                            'id' => 'value-image'
                        ]);
                    }
                    ?>
                    <div class="content-blocks--form-actions">
                        <?= $this->Form->button(__('Save'), ['class' => 'button btn btn-primary']) ?>
                        <?= $this->Html->link('Cancel', ['action' => 'index'], ['class' => 'btn btn-outline-secondary']) ?>
                    </div>
                    <?= $this->Form->end() ?>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    :root {
        --orange: #E87533;
        --orange-light: #FFA563;
        --orange-dark: #D05F20;
        --blue: #3E88F2;
        --blue-light: #70A8FF;
        --green: #2EA876;
        --grey-light: #f5f5f5;
        --grey-lighter: #fafafa;
        --grey: #78716c;
        --grey-dark: #4B4945;
        --radius: 20px;
        --radius-sm: 12px;
        --spacing: 30px;
        --shadow: rgba(0,0,0,0.1);
        --shadow-hover: rgba(0,0,0,0.2);
        --transition: all 0.4s cubic-bezier(0.22, 1, 0.36, 1);
    }

    * { box-sizing: border-box; margin: 0; padding: 0; }

    body {
        font-family: "Inter", system-ui, sans-serif;
        background: var(--grey-lighter);
        color: #333;
        line-height: 1.6;
        overflow-x: hidden;
    }

    body::before {
        content: "";
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: radial-gradient(circle at 15% 25%, rgba(232, 117, 51, 0.06) 0%, transparent 50%),
        radial-gradient(circle at 85% 75%, rgba(62, 136, 242, 0.05) 0%, transparent 50%);
        z-index: -1;
    }

    .page-container {
        max-width: 1400px;
        margin: 0 auto;
        padding: var(--spacing);
    }

    .card {
        background: #fff;
        border-radius: var(--radius);
        box-shadow: 0 12px 40px var(--shadow);
        padding: calc(var(--spacing) * 2);
        margin-bottom: calc(var(--spacing) * 2.5);
        position: relative;
    }

    .card-body {
        padding: 0;
    }

    .content-blocks--form-heading {
        font-family: "Poppins", sans-serif;
        font-size: 2.5rem;
        font-weight: 800;
        color: var(--grey-dark);
        text-align: center;
        margin-bottom: calc(var(--spacing) * 2);
        position: relative;
    }

    .content-blocks--form-heading::after {
        content: "";
        position: absolute;
        bottom: -12px;
        left: 50%;
        transform: translateX(-50%);
        width: 120px;
        height: 6px;
        background: linear-gradient(90deg, var(--orange-light), var(--blue));
        border-radius: 6px;
    }

    .content-blocks--form-description {
        font-size: 1.1rem;
        color: var(--grey);
        text-align: center;
        margin-bottom: calc(var(--spacing) * 2);
    }

    .form-control {
        width: 100%;
        padding: 12px;
        border: 1px solid var(--grey-light);
        border-radius: var(--radius-sm);
        font-size: 1.1rem;
        color: var(--grey-dark);
        background: #fff;
        transition: var(--transition);
    }

    .form-control:focus {
        border-color: var(--orange-light);
        box-shadow: 0 0 8px rgba(232, 117, 51, 0.2);
        outline: none;
    }

    .ck-editor__editable_inline {
        min-height: 25rem;
        border: 1px solid var(--grey-light);
        border-radius: var(--radius-sm);
        padding: 10px;
        background: #fff;
        color: var(--grey-dark);
    }

    .content-blocks--image-preview {
        max-width: 100%;
        height: auto;
        border-radius: var(--radius-sm);
        margin-bottom: calc(var(--spacing) * 1);
        box-shadow: 0 4px 15px rgba(0,0,0,0.05);
    }

    .content-blocks--form-actions {
        display: flex;
        justify-content: center;
        gap: 10px;
        margin-top: calc(var(--spacing) * 2);
    }

    .content-blocks--form-actions .button.btn-primary {
        padding: 10px 25px;
        background: var(--orange);
        color: #fff;
        border: none;
        border-radius: var(--radius-sm);
        font-size: 1rem;
        font-weight: 600;
        transition: var(--transition);
        box-shadow: 0 4px 15px rgba(232, 117, 51, 0.3);
    }

    .content-blocks--form-actions .button.btn-primary:hover {
        background: var(--orange-dark);
        transform: translateY(-5px);
        box-shadow: 0 6px 20px rgba(232, 117, 51, 0.4);
    }

    .content-blocks--form-actions a.btn-outline-secondary {
        padding: 10px 25px;
        background: var(--grey-light);
        color: var(--grey-dark);
        border: 1px solid var(--grey-light);
        border-radius: var(--radius-sm);
        font-size: 1rem;
        font-weight: 600;
        text-decoration: none;
        transition: var(--transition);
    }

    .content-blocks--form-actions a.btn-outline-secondary:hover {
        background: var(--grey);
        color: #fff;
        transform: translateY(-5px);
    }

    @media (max-width: 768px) {
        .page-container {
            padding: 15px;
        }

        .card {
            padding: 20px;
        }

        .content-blocks--form-heading {
            font-size: 1.8rem;
        }

        .content-blocks--form-description {
            font-size: 1rem;
        }

        .form-control {
            font-size: 1rem;
            padding: 8px;
        }

        .ck-editor__editable_inline {
            min-height: 15rem;
        }

        .content-blocks--form-actions .button.btn-primary,
        .content-blocks--form-actions a.btn-outline-secondary {
            font-size: 0.9rem;
            padding: 8px 20px;
        }
    }
</style>
